/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.Project;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class ProjectAllowDupPrel
extends ProjectPrel {
    public ProjectAllowDupPrel(RelOptCluster cluster, RelTraitSet traits, RelNode child, List<RexNode> exps, RelDataType rowType) {
        this(cluster, traits, child, exps, rowType, false);
    }

    public ProjectAllowDupPrel(RelOptCluster cluster, RelTraitSet traits, RelNode child, List<RexNode> exps, RelDataType rowType, boolean outputProj) {
        super(cluster, traits, child, exps, rowType, outputProj);
    }

    @Override
    public ProjectAllowDupPrel copy(RelTraitSet traitSet, RelNode input, List<RexNode> exps, RelDataType rowType) {
        return new ProjectAllowDupPrel(this.getCluster(), traitSet, input, exps, rowType, this.outputProj);
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getInput();
        PhysicalOperator childPOP = child.getPhysicalOperator(creator);
        Project p = new Project(this.getProjectExpressions(new DrillParseContext(PrelUtil.getSettings(this.getCluster()))), childPOP, this.outputProj);
        return creator.addMetadata(this, p);
    }

    @Override
    protected List<NamedExpression> getProjectExpressions(DrillParseContext context) {
        ArrayList<NamedExpression> expressions = Lists.newArrayList();
        for (Pair pair : Pair.zip((List)this.exps, (List)this.getRowType().getFieldNames())) {
            LogicalExpression expr = DrillOptiq.toDrill(context, this.getInput(), (RexNode)pair.left);
            expressions.add(new NamedExpression(expr, FieldReference.getWithQuotedRef((CharSequence)pair.right)));
        }
        return expressions;
    }
}

