/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class PrelFactories {
    public static final RelFactories.ProjectFactory PROJECT_FACTORY = new DrillProjectPrelFactory();

    private static class DrillProjectPrelFactory
    implements RelFactories.ProjectFactory {
        private DrillProjectPrelFactory() {
        }

        public RelNode createProject(RelNode child, List<RelHint> hints, List<? extends RexNode> childExprs, List<? extends String> fieldNames, Set<CorrelationId> variablesSet) {
            RelOptCluster cluster = child.getCluster();
            RelDataType rowType = RexUtil.createStructType((RelDataTypeFactory)cluster.getTypeFactory(), childExprs, fieldNames, null);
            return new ProjectPrel(cluster, child.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL), child, Lists.newArrayList(childExprs), rowType);
        }
    }
}

