/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.plan.Context;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.alias.AliasRegistryProvider;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValidator;
import org.apache.drill.exec.server.options.TypeValidators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlannerSettings
implements Context {
    private static final Logger logger = LoggerFactory.getLogger(PlannerSettings.class);
    private int numEndPoints;
    private boolean useDefaultCosting;
    private boolean forceSingleMode;
    public static final int MAX_BROADCAST_THRESHOLD = Integer.MAX_VALUE;
    public static final int DEFAULT_IDENTIFIER_MAX_LENGTH = 1024;
    private static final long INITIAL_OFF_HEAP_ALLOCATION_IN_BYTES = 0x100000L;
    private static final long DEFAULT_MAX_OFF_HEAP_ALLOCATION_IN_BYTES = 0x10000000L;
    private static final long MAX_OFF_HEAP_ALLOCATION_IN_BYTES = 0x400000000L;
    public static final OptionValidator CONSTANT_FOLDING = new TypeValidators.BooleanValidator("planner.enable_constant_folding", new OptionValidator.OptionDescription("If one side of a filter condition is a constant expression, constant folding evaluates the expression in the planning phase and replaces the expression with the constant value. For example, Drill can rewrite WHERE age + 5 < 42 as WHERE age < 37."));
    public static final String DISABLE_EXCHANGE_OPTION = "planner.disable_exchanges";
    public static final OptionValidator EXCHANGE = new TypeValidators.BooleanValidator("planner.disable_exchanges", new OptionValidator.OptionDescription("Toggles the state of hashing to a random exchange."));
    public static final String ENABLE_HASH_AGG_OPTION = "planner.enable_hashagg";
    public static final OptionValidator HASHAGG = new TypeValidators.BooleanValidator("planner.enable_hashagg", new OptionValidator.OptionDescription("Enable hash aggregation; otherwise, Drill does a sort-based aggregation. Writes to disk. Enable is recommended."));
    public static final String ENABLE_STREAM_AGG_OPTION = "planner.enable_streamagg";
    public static final OptionValidator STREAMAGG = new TypeValidators.BooleanValidator("planner.enable_streamagg", new OptionValidator.OptionDescription("Sort-based operation. Writes to disk."));
    public static final OptionValidator TOPN = new TypeValidators.BooleanValidator("planner.enable_topn", new OptionValidator.OptionDescription("Generates the topN plan for queries with the ORDER BY and LIMIT clauses."));
    public static final String ENABLE_HASH_JOIN_OPTION = "planner.enable_hashjoin";
    public static final OptionValidator HASHJOIN = new TypeValidators.BooleanValidator("planner.enable_hashjoin", new OptionValidator.OptionDescription("Enable the memory hungry hash join. Drill assumes that a query will have adequate memory to complete and tries to use the fastest operations possible to complete the planned inner, left, right, or full outer joins using a hash table. Does not write to disk. Disabling hash join allows Drill to manage arbitrarily large data in a small memory footprint."));
    public static final OptionValidator SEMIJOIN = new TypeValidators.BooleanValidator("planner.enable_semijoin", new OptionValidator.OptionDescription("Enable the semi join optimization. Planner removes the distinct processing below the hash join and sets the semi join flag in hash join."));
    public static final OptionValidator MERGEJOIN = new TypeValidators.BooleanValidator("planner.enable_mergejoin", new OptionValidator.OptionDescription("Sort-based operation. A merge join is used for inner join, left and right outer joins. Inputs to the merge join must be sorted. It reads the sorted input streams from both sides and finds matching rows. Writes to disk."));
    public static final OptionValidator NESTEDLOOPJOIN = new TypeValidators.BooleanValidator("planner.enable_nestedloopjoin", new OptionValidator.OptionDescription("Sort-based operation. Writes to disk."));
    public static final OptionValidator MULTIPHASE = new TypeValidators.BooleanValidator("planner.enable_multiphase_agg", new OptionValidator.OptionDescription("Each minor fragment does a local aggregation in phase 1, distributes on a hash basis using GROUP-BY keys partially aggregated results to other fragments, and all the fragments perform a total aggregation using this data."));
    public static final OptionValidator BROADCAST = new TypeValidators.BooleanValidator("planner.enable_broadcast_join", new OptionValidator.OptionDescription("Changes the state of aggregation and join operators. The broadcast join can be used for hash join, merge join and nested loop join. Use to join a large (fact) table to relatively smaller (dimension) tables. Do not disable."));
    public static final OptionValidator BROADCAST_THRESHOLD = new TypeValidators.PositiveLongValidator("planner.broadcast_threshold", Integer.MAX_VALUE, new OptionValidator.OptionDescription("The maximum number of records allowed to be broadcast as part of a query. After one million records, Drill reshuffles data rather than doing a broadcast to one side of the join. Range: 0-2147483647"));
    public static final OptionValidator BROADCAST_FACTOR = new TypeValidators.RangeDoubleValidator("planner.broadcast_factor", 0.0, Double.MAX_VALUE, new OptionValidator.OptionDescription("A heuristic parameter for influencing the broadcast of records as part of a query."));
    public static final OptionValidator NESTEDLOOPJOIN_FACTOR = new TypeValidators.RangeDoubleValidator("planner.nestedloopjoin_factor", 0.0, Double.MAX_VALUE, new OptionValidator.OptionDescription("A heuristic value for influencing the nested loop join."));
    public static final OptionValidator NLJOIN_FOR_SCALAR = new TypeValidators.BooleanValidator("planner.enable_nljoin_for_scalar_only", new OptionValidator.OptionDescription("Supports nested loop join planning where the right input is scalar in order to enable NOT-IN, Inequality, Cartesian, and uncorrelated EXISTS planning."));
    public static final OptionValidator JOIN_ROW_COUNT_ESTIMATE_FACTOR = new TypeValidators.RangeDoubleValidator("planner.join.row_count_estimate_factor", 0.0, Double.MAX_VALUE, new OptionValidator.OptionDescription("The factor for adjusting the estimated row count when considering multiple join order sequences during the planning phase."));
    public static final OptionValidator MUX_EXCHANGE = new TypeValidators.BooleanValidator("planner.enable_mux_exchange", new OptionValidator.OptionDescription("Toggles the state of hashing to a multiplexed exchange."));
    public static final OptionValidator ORDERED_MUX_EXCHANGE = new TypeValidators.BooleanValidator("planner.enable_ordered_mux_exchange", new OptionValidator.OptionDescription("Generates the MUX exchange operator for ORDER BY queries with many minor fragments."));
    public static final OptionValidator DEMUX_EXCHANGE = new TypeValidators.BooleanValidator("planner.enable_demux_exchange", new OptionValidator.OptionDescription("Toggles the state of hashing to a demulitplexed exchange."));
    public static final OptionValidator PARTITION_SENDER_THREADS_FACTOR = new TypeValidators.LongValidator("planner.partitioner_sender_threads_factor", new OptionValidator.OptionDescription("A heuristic param to use to influence final number of threads. The higher the value the fewer the number of threads."));
    public static final OptionValidator PARTITION_SENDER_MAX_THREADS = new TypeValidators.LongValidator("planner.partitioner_sender_max_threads", new OptionValidator.OptionDescription("Upper limit of threads for outbound queuing."));
    public static final OptionValidator PARTITION_SENDER_SET_THREADS = new TypeValidators.LongValidator("planner.partitioner_sender_set_threads", new OptionValidator.OptionDescription("Overwrites the number of threads used to send out batches of records. Set to -1 to disable. Typically not changed."));
    public static final OptionValidator PRODUCER_CONSUMER = new TypeValidators.BooleanValidator("planner.add_producer_consumer", new OptionValidator.OptionDescription("Increase prefetching of data from disk. Disable for in-memory reads."));
    public static final OptionValidator PRODUCER_CONSUMER_QUEUE_SIZE = new TypeValidators.LongValidator("planner.producer_consumer_queue_size", new OptionValidator.OptionDescription("How much data to prefetch from disk in record batches out-of-band of query execution. The larger the queue size, the greater the amount of memory that the queue and overall query execution consumes."));
    public static final OptionValidator HASH_SINGLE_KEY = new TypeValidators.BooleanValidator("planner.enable_hash_single_key", new OptionValidator.OptionDescription("Each hash key is associated with a single value."));
    public static final OptionValidator HASH_JOIN_SWAP = new TypeValidators.BooleanValidator("planner.enable_hashjoin_swap", new OptionValidator.OptionDescription("Enables consideration of multiple join order sequences during the planning phase. Might negatively affect the performance of some queries due to inaccuracy of estimated row count especially after a filter, join, or aggregation."));
    public static final OptionValidator HASH_JOIN_SWAP_MARGIN_FACTOR = new TypeValidators.RangeDoubleValidator("planner.join.hash_join_swap_margin_factor", 0.0, 100.0, new OptionValidator.OptionDescription("The number of join order sequences to consider during the planning phase."));
    public static final String ENABLE_DECIMAL_DATA_TYPE_KEY = "planner.enable_decimal_data_type";
    public static final TypeValidators.BooleanValidator ENABLE_DECIMAL_DATA_TYPE = new TypeValidators.BooleanValidator("planner.enable_decimal_data_type", new OptionValidator.OptionDescription("False disables the DECIMAL data type, including casting to DECIMAL and reading DECIMAL types from Parquet and Hive."));
    public static final OptionValidator HEP_OPT = new TypeValidators.BooleanValidator("planner.enable_hep_opt", null);
    public static final OptionValidator HEP_PARTITION_PRUNING = new TypeValidators.BooleanValidator("planner.enable_hep_partition_pruning", null);
    public static final OptionValidator ROWKEYJOIN_CONVERSION = new TypeValidators.BooleanValidator("planner.enable_rowkeyjoin_conversion", new OptionValidator.OptionDescription("Enables runtime filter pushdown(via rowkey-join) for queries that only filter on rowkeys"));
    public static final TypeValidators.RangeDoubleValidator ROWKEYJOIN_CONVERSION_SELECTIVITY_THRESHOLD = new TypeValidators.RangeDoubleValidator("planner.rowkeyjoin_conversion_selectivity_threshold", 0.0, 1.0, new OptionValidator.OptionDescription("Sets the selectivity (as a percentage) under which Drill uses a rowkey join for queries that only filter on rowkeys"));
    public static final OptionValidator ROWKEYJOIN_CONVERSION_USING_HASHJOIN = new TypeValidators.BooleanValidator("planner.rowkeyjoin_conversion_using_hashjoin", new OptionValidator.OptionDescription("Enables runtime filter pushdown(via hash-join) for queries that only filter on rowkeys"));
    public static final OptionValidator PLANNER_MEMORY_LIMIT = new TypeValidators.RangeLongValidator("planner.memory_limit", 0x100000L, 0x400000000L, new OptionValidator.OptionDescription("Defines the maximum amount of direct memory allocated to a query for planning. When multiple queries run concurrently, each query is allocated the amount of memory set by this parameter.Increase the value of this parameter and rerun the query if partition pruning failed due to insufficient memory."));
    public static final String UNIONALL_DISTRIBUTE_KEY = "planner.enable_unionall_distribute";
    public static final TypeValidators.BooleanValidator UNIONALL_DISTRIBUTE = new TypeValidators.BooleanValidator("planner.enable_unionall_distribute", null);
    public static final String USE_SIMPLE_OPTIMIZER_KEY = "planner.use_simple_optimizer";
    public static final TypeValidators.BooleanValidator USE_SIMPLE_OPTIMIZER = new TypeValidators.BooleanValidator("planner.use_simple_optimizer", new OptionValidator.OptionDescription("Simple optimizer applies fewer rules to reduce planning time and is meant to be used only for simple operational queries that use limit, sort, and filter."));
    public static final TypeValidators.BooleanValidator INDEX_PLANNING = new TypeValidators.BooleanValidator("planner.enable_index_planning", new OptionValidator.OptionDescription("Enables or disables index planning."));
    public static final TypeValidators.BooleanValidator ENABLE_STATS = new TypeValidators.BooleanValidator("planner.enable_statistics", new OptionValidator.OptionDescription("Enable or disable statistics for the filter conditions on indexed columns."));
    public static final TypeValidators.BooleanValidator DISABLE_FULL_TABLE_SCAN = new TypeValidators.BooleanValidator("planner.disable_full_table_scan", new OptionValidator.OptionDescription("Disable generating a full table scan plan (only for internal testing use)"));
    public static final TypeValidators.RangeLongValidator INDEX_MAX_CHOSEN_INDEXES_PER_TABLE = new TypeValidators.RangeLongValidator("planner.index.max_chosen_indexes_per_table", 0L, 100L, new OptionValidator.OptionDescription("The maximum number of 'chosen' indexes for a table after index costing and ranking."));
    public static final TypeValidators.BooleanValidator INDEX_FORCE_SORT_NONCOVERING = new TypeValidators.BooleanValidator("planner.index.force_sort_noncovering", new OptionValidator.OptionDescription("Forces Drill to sort for non-covering indexes. If the query has an ORDER-BY on index columns and a non-covering index is chosen, by default Drill leverages the sortedness of the index columns and does not sort. Fast changing primary table data may produce a partial sort. This option forces a sort within Drill."));
    public static final TypeValidators.BooleanValidator INDEX_USE_HASHJOIN_NONCOVERING = new TypeValidators.BooleanValidator("planner.index.use_hashjoin_noncovering", new OptionValidator.OptionDescription("Enable using HashJoin for non-covering index plans instead of RowKeyJoin (only for internal testing use)."));
    public static final TypeValidators.RangeDoubleValidator INDEX_COVERING_SELECTIVITY_THRESHOLD = new TypeValidators.RangeDoubleValidator("planner.index.covering_selectivity_threshold", 0.0, 1.0, new OptionValidator.OptionDescription("For covering indexes, this option specifies the filter selectivity that corresponds to the leading prefix of the index below which the index is considered for planning."));
    public static final TypeValidators.RangeDoubleValidator INDEX_NONCOVERING_SELECTIVITY_THRESHOLD = new TypeValidators.RangeDoubleValidator("planner.index.noncovering_selectivity_threshold", 0.0, 1.0, new OptionValidator.OptionDescription("For non-covering indexes, this option specifies the filter selectivity that corresponds to the leading prefix of the index below which the index is considered for planning."));
    public static final TypeValidators.RangeDoubleValidator INDEX_ROWKEYJOIN_COST_FACTOR = new TypeValidators.RangeDoubleValidator("planner.index.rowkeyjoin_cost_factor", 0.0, Double.MAX_VALUE, new OptionValidator.OptionDescription("The cost factor that provides some control over the I/O cost for non-covering indexes when the rowkey join back to the primary table causes random I/O from the primary table."));
    public static final TypeValidators.BooleanValidator INDEX_PREFER_INTERSECT_PLANS = new TypeValidators.BooleanValidator("planner.index.prefer_intersect_plans", new OptionValidator.OptionDescription("Given 2 or more single column indexes, this option allows preferring index intersect plans compared to single column indexes (only for internal testing use)."));
    public static final TypeValidators.RangeLongValidator INDEX_MAX_INDEXES_TO_INTERSECT = new TypeValidators.RangeLongValidator("planner.index.max_indexes_to_intersect", 2L, 100L, new OptionValidator.OptionDescription("The maximum number of indexes to intersect in a single query (only for internal testing use)."));
    public static final TypeValidators.RangeDoubleValidator INDEX_STATS_ROWCOUNT_SCALING_FACTOR = new TypeValidators.RangeDoubleValidator("planner.index.statistics_rowcount_scaling_factor", 0.0, 1.0, new OptionValidator.OptionDescription("A factor that allows scaling the row count estimates returned from the storage/format plugin to compensate for under or over estimation."));
    public static final OptionValidator IDENTIFIER_MAX_LENGTH = new TypeValidators.RangeLongValidator("planner.identifier_max_length", 128L, Integer.MAX_VALUE, new OptionValidator.OptionDescription("A minimum length is needed because option names are identifiers themselves."));
    public static final TypeValidators.DoubleValidator FILTER_MIN_SELECTIVITY_ESTIMATE_FACTOR = new TypeValidators.MinRangeDoubleValidator("planner.filter.min_selectivity_estimate_factor", 0.0, 1.0, "planner.filter.max_selectivity_estimate_factor", new OptionValidator.OptionDescription("Available as of Drill 1.8. Sets the minimum filter selectivity estimate to increase the parallelization of the major fragment performing a join. This option is useful for deeply nested queries with complicated predicates and serves as a workaround when statistics are insufficient or unavailable. The selectivity can vary between 0 and 1. The value of this option caps the estimated SELECTIVITY. The estimated ROWCOUNT is derived by multiplying the estimated SELECTIVITY by the estimated ROWCOUNT of the upstream operator. The estimated ROWCOUNT displays when you use the EXPLAIN PLAN INCLUDING ALL ATTRIBUTES FOR command. This option does not control the estimated ROWCOUNT of downstream operators (post FILTER). However, estimated ROWCOUNTs may change because the operator ROWCOUNTs depend on their downstream operators. The FILTER operator relies on the input of its immediate upstream operator, for example SCAN, AGGREGATE. If two filters are present in a plan, each filter may have a different estimated ROWCOUNT based on the immediate upstream operator's estimated ROWCOUNT."));
    public static final TypeValidators.DoubleValidator FILTER_MAX_SELECTIVITY_ESTIMATE_FACTOR = new TypeValidators.MaxRangeDoubleValidator("planner.filter.max_selectivity_estimate_factor", 0.0, 1.0, "planner.filter.min_selectivity_estimate_factor", new OptionValidator.OptionDescription("Available as of Drill 1.8. Sets the maximum filter selectivity estimate. The selectivity can vary between 0 and 1. For more details, see planner.filter.min_selectivity_estimate_factor."));
    public static final String TYPE_INFERENCE_KEY = "planner.enable_type_inference";
    public static final TypeValidators.BooleanValidator TYPE_INFERENCE = new TypeValidators.BooleanValidator("planner.enable_type_inference", null);
    public static final TypeValidators.LongValidator IN_SUBQUERY_THRESHOLD = new TypeValidators.PositiveLongValidator("planner.in_subquery_threshold", Integer.MAX_VALUE, new OptionValidator.OptionDescription("Defines the threshold of values in the IN list of the query to generate a hash join instead of an OR predicate."));
    public static final String PARQUET_ROWGROUP_FILTER_PUSHDOWN_PLANNING_KEY = "planner.store.parquet.rowgroup.filter.pushdown.enabled";
    public static final TypeValidators.BooleanValidator PARQUET_ROWGROUP_FILTER_PUSHDOWN_PLANNING = new TypeValidators.BooleanValidator("planner.store.parquet.rowgroup.filter.pushdown.enabled", new OptionValidator.OptionDescription("Enables filter pushdown optimization for Parquet files. Drill reads the file metadata, stored in the footer, to eliminate row groups based on the filter condition. Default is true. (Drill 1.9+)"));
    public static final String PARQUET_ROWGROUP_FILTER_PUSHDOWN_PLANNING_THRESHOLD_KEY = "planner.store.parquet.rowgroup.filter.pushdown.threshold";
    public static final TypeValidators.LongValidator PARQUET_ROWGROUP_FILTER_PUSHDOWN_PLANNING_THRESHOLD = new TypeValidators.LongValidator("planner.store.parquet.rowgroup.filter.pushdown.threshold", new OptionValidator.OptionDescription("Maximal number of row groups a table can have to enable pruning by the planner. Base this setting on the data set - increasing if needed would add planning overhead, but may reduce execution overhead if the filter is relevant (e.g., on a sorted column, or many nulls). Reduce this setting if the planning time is significant or you do not see any benefit at runtime. A non-positive value disables plan time pruning."));
    public static final String QUOTING_IDENTIFIERS_KEY = "planner.parser.quoting_identifiers";
    public static final TypeValidators.EnumeratedStringValidator QUOTING_IDENTIFIERS = new TypeValidators.EnumeratedStringValidator("planner.parser.quoting_identifiers", new OptionValidator.OptionDescription("Sets the type of identifier quotes for the SQL parser. Default is backticks ('`'). The SQL parser accepts double quotes ('\"') and square brackets ('['). (Drill 1.11+)"), Quoting.BACK_TICK.string, Quoting.DOUBLE_QUOTE.string, Quoting.BRACKET.string);
    public static final String ENABLE_UNNEST_LATERAL_KEY = "planner.enable_unnest_lateral";
    public static final TypeValidators.BooleanValidator ENABLE_UNNEST_LATERAL = new TypeValidators.BooleanValidator("planner.enable_unnest_lateral", new OptionValidator.OptionDescription("Enables lateral join functionality. Default is true. (Drill 1.15+)"));
    public static final TypeValidators.BooleanValidator JOIN_OPTIMIZATION = new TypeValidators.BooleanValidator("planner.enable_join_optimization", new OptionValidator.OptionDescription("Enables join ordering optimization."));
    public static final String FORCE_2PHASE_AGGR_KEY = "planner.force_2phase_aggr";
    public static final TypeValidators.BooleanValidator FORCE_2PHASE_AGGR = new TypeValidators.BooleanValidator("planner.force_2phase_aggr", new OptionValidator.OptionDescription("Forces the cost-based query planner to generate a two phase aggregation for an aggregate operator."));
    public static final TypeValidators.BooleanValidator STATISTICS_USE = new TypeValidators.BooleanValidator("planner.statistics.use", null);
    public static final TypeValidators.RangeDoubleValidator STATISTICS_MULTICOL_NDV_ADJUST_FACTOR = new TypeValidators.RangeDoubleValidator("planner.statistics.multicol_ndv_adjustment_factor", 0.0, 1.0, null);
    public OptionManager options = null;
    public FunctionImplementationRegistry functionImplementationRegistry = null;
    private final String queryUser;
    private final AliasRegistryProvider aliasRegistryProvider;

    public PlannerSettings(OptionManager options, FunctionImplementationRegistry functionImplementationRegistry, String queryUser, AliasRegistryProvider aliasRegistryProvider) {
        this.options = options;
        this.functionImplementationRegistry = functionImplementationRegistry;
        this.queryUser = queryUser;
        this.aliasRegistryProvider = aliasRegistryProvider;
    }

    public OptionManager getOptions() {
        return this.options;
    }

    public boolean isSingleMode() {
        return this.forceSingleMode || this.options.getOption((String)PlannerSettings.EXCHANGE.getOptionName()).bool_val != false;
    }

    public void forceSingleMode() {
        this.forceSingleMode = true;
    }

    public int numEndPoints() {
        return this.numEndPoints;
    }

    public double getRowCountEstimateFactor() {
        return this.options.getOption((String)PlannerSettings.JOIN_ROW_COUNT_ESTIMATE_FACTOR.getOptionName()).float_val;
    }

    public double getBroadcastFactor() {
        return this.options.getOption((String)PlannerSettings.BROADCAST_FACTOR.getOptionName()).float_val;
    }

    public double getNestedLoopJoinFactor() {
        return this.options.getOption((String)PlannerSettings.NESTEDLOOPJOIN_FACTOR.getOptionName()).float_val;
    }

    public boolean isNlJoinForScalarOnly() {
        return this.options.getOption((String)PlannerSettings.NLJOIN_FOR_SCALAR.getOptionName()).bool_val;
    }

    public boolean useDefaultCosting() {
        return this.useDefaultCosting;
    }

    public void setNumEndPoints(int numEndPoints) {
        this.numEndPoints = numEndPoints;
    }

    public void setUseDefaultCosting(boolean defcost) {
        this.useDefaultCosting = defcost;
    }

    public boolean isHashAggEnabled() {
        return this.options.getOption((String)PlannerSettings.HASHAGG.getOptionName()).bool_val;
    }

    public boolean isConstantFoldingEnabled() {
        return this.options.getOption((String)PlannerSettings.CONSTANT_FOLDING.getOptionName()).bool_val;
    }

    public boolean isStreamAggEnabled() {
        return this.options.getOption((String)PlannerSettings.STREAMAGG.getOptionName()).bool_val;
    }

    public boolean isHashJoinEnabled() {
        return this.options.getOption((String)PlannerSettings.HASHJOIN.getOptionName()).bool_val;
    }

    public boolean isSemiJoinEnabled() {
        return this.options.getOption((String)PlannerSettings.SEMIJOIN.getOptionName()).bool_val;
    }

    public boolean isMergeJoinEnabled() {
        return this.options.getOption((String)PlannerSettings.MERGEJOIN.getOptionName()).bool_val;
    }

    public boolean isNestedLoopJoinEnabled() {
        return this.options.getOption((String)PlannerSettings.NESTEDLOOPJOIN.getOptionName()).bool_val;
    }

    public boolean isMultiPhaseAggEnabled() {
        return this.options.getOption((String)PlannerSettings.MULTIPHASE.getOptionName()).bool_val;
    }

    public boolean isBroadcastJoinEnabled() {
        return this.options.getOption((String)PlannerSettings.BROADCAST.getOptionName()).bool_val;
    }

    public boolean isHashSingleKey() {
        return this.options.getOption((String)PlannerSettings.HASH_SINGLE_KEY.getOptionName()).bool_val;
    }

    public boolean isHashJoinSwapEnabled() {
        return this.options.getOption((String)PlannerSettings.HASH_JOIN_SWAP.getOptionName()).bool_val;
    }

    public boolean isHepPartitionPruningEnabled() {
        return this.options.getOption((String)PlannerSettings.HEP_PARTITION_PRUNING.getOptionName()).bool_val;
    }

    public boolean isRowKeyJoinConversionEnabled() {
        return this.options.getOption((String)PlannerSettings.ROWKEYJOIN_CONVERSION.getOptionName()).bool_val;
    }

    public boolean isRowKeyJoinConversionUsingHashJoin() {
        return this.options.getOption((String)PlannerSettings.ROWKEYJOIN_CONVERSION_USING_HASHJOIN.getOptionName()).bool_val;
    }

    public double getRowKeyJoinConversionSelThreshold() {
        return this.options.getOption(ROWKEYJOIN_CONVERSION_SELECTIVITY_THRESHOLD);
    }

    public boolean isHepOptEnabled() {
        return this.options.getOption((String)PlannerSettings.HEP_OPT.getOptionName()).bool_val;
    }

    public double getHashJoinSwapMarginFactor() {
        return this.options.getOption((String)PlannerSettings.HASH_JOIN_SWAP_MARGIN_FACTOR.getOptionName()).float_val / 100.0;
    }

    public long getBroadcastThreshold() {
        return this.options.getOption((String)PlannerSettings.BROADCAST_THRESHOLD.getOptionName()).num_val;
    }

    public long getSliceTarget() {
        return this.options.getOption((String)"planner.slice_target").num_val;
    }

    public boolean isMemoryEstimationEnabled() {
        return this.options.getOption((String)"planner.memory.enable_memory_estimation").bool_val;
    }

    public String getFsPartitionColumnLabel() {
        return this.options.getOption((String)"drill.exec.storage.file.partition.column.label").string_val;
    }

    public long getIdentifierMaxLength() {
        return this.options.getOption((String)PlannerSettings.IDENTIFIER_MAX_LENGTH.getOptionName()).num_val;
    }

    public long getPlanningMemoryLimit() {
        return this.options.getOption((String)PlannerSettings.PLANNER_MEMORY_LIMIT.getOptionName()).num_val;
    }

    public String getQueryUser() {
        return this.queryUser;
    }

    public AliasRegistryProvider getAliasRegistryProvider() {
        return this.aliasRegistryProvider;
    }

    public static long getInitialPlanningMemorySize() {
        return 0x100000L;
    }

    public double getFilterMinSelectivityEstimateFactor() {
        return this.options.getOption(FILTER_MIN_SELECTIVITY_ESTIMATE_FACTOR);
    }

    public double getFilterMaxSelectivityEstimateFactor() {
        return this.options.getOption(FILTER_MAX_SELECTIVITY_ESTIMATE_FACTOR);
    }

    public boolean isTypeInferenceEnabled() {
        return this.options.getOption(TYPE_INFERENCE);
    }

    public boolean isForce2phaseAggr() {
        return this.options.getOption(FORCE_2PHASE_AGGR);
    }

    public long getInSubqueryThreshold() {
        return this.options.getOption(IN_SUBQUERY_THRESHOLD);
    }

    public boolean isUnionAllDistributeEnabled() {
        return this.options.getOption(UNIONALL_DISTRIBUTE);
    }

    public boolean isParquetRowGroupFilterPushdownPlanningEnabled() {
        return this.options.getOption(PARQUET_ROWGROUP_FILTER_PUSHDOWN_PLANNING);
    }

    public long getParquetRowGroupFilterPushDownThreshold() {
        return this.options.getOption(PARQUET_ROWGROUP_FILTER_PUSHDOWN_PLANNING_THRESHOLD);
    }

    public Quoting getQuotingIdentifiers() {
        String quotingIdentifiersCharacter;
        switch (quotingIdentifiersCharacter = this.options.getOption(QUOTING_IDENTIFIERS)) {
            case "\"": {
                return Quoting.DOUBLE_QUOTE;
            }
            case "`": {
                return Quoting.BACK_TICK;
            }
            case "[": {
                return Quoting.BRACKET;
            }
        }
        for (Quoting value : Quoting.values()) {
            if (!value.string.equals(quotingIdentifiersCharacter)) continue;
            return value;
        }
        throw UserException.validationError().message("Unknown quoting identifier character '%s'", quotingIdentifiersCharacter).build(logger);
    }

    public boolean isJoinOptimizationEnabled() {
        return this.options.getOption(JOIN_OPTIMIZATION);
    }

    public boolean isUnnestLateralEnabled() {
        return this.options.getOption(ENABLE_UNNEST_LATERAL);
    }

    public boolean isIndexPlanningEnabled() {
        return this.options.getOption(INDEX_PLANNING);
    }

    public boolean isStatisticsEnabled() {
        return this.options.getOption(ENABLE_STATS);
    }

    public boolean isDisableFullTableScan() {
        return this.options.getOption(DISABLE_FULL_TABLE_SCAN);
    }

    public long getIndexMaxChosenIndexesPerTable() {
        return this.options.getOption(INDEX_MAX_CHOSEN_INDEXES_PER_TABLE);
    }

    public boolean isIndexForceSortNonCovering() {
        return this.options.getOption(INDEX_FORCE_SORT_NONCOVERING);
    }

    public boolean isIndexUseHashJoinNonCovering() {
        return this.options.getOption(INDEX_USE_HASHJOIN_NONCOVERING);
    }

    public double getIndexCoveringSelThreshold() {
        return this.options.getOption(INDEX_COVERING_SELECTIVITY_THRESHOLD);
    }

    public double getIndexNonCoveringSelThreshold() {
        return this.options.getOption(INDEX_NONCOVERING_SELECTIVITY_THRESHOLD);
    }

    public double getIndexRowKeyJoinCostFactor() {
        return this.options.getOption(INDEX_ROWKEYJOIN_COST_FACTOR);
    }

    public boolean isIndexIntersectPlanPreferred() {
        return this.options.getOption(INDEX_PREFER_INTERSECT_PLANS);
    }

    public long getMaxIndexesToIntersect() {
        return this.options.getOption(INDEX_MAX_INDEXES_TO_INTERSECT);
    }

    public double getIndexStatsRowCountScalingFactor() {
        return this.options.getOption(INDEX_STATS_ROWCOUNT_SCALING_FACTOR);
    }

    public boolean useStatistics() {
        return this.options.getOption(STATISTICS_USE);
    }

    public double getStatisticsMultiColNdvAdjustmentFactor() {
        return this.options.getOption(STATISTICS_MULTICOL_NDV_ADJUST_FACTOR);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz == PlannerSettings.class) {
            return (T)this;
        }
        return null;
    }
}

