/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.physical.ExchangePrel;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.record.BatchSchema;

public class OrderedPartitionExchangePrel
extends ExchangePrel {
    public OrderedPartitionExchangePrel(RelOptCluster cluster, RelTraitSet traitSet, RelNode input) {
        super(cluster, traitSet, input);
        assert (input.getConvention() == Prel.DRILL_PHYSICAL);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }
        RelNode child = this.getInput();
        double inputRows = mq.getRowCount(child);
        int rowWidth = child.getRowType().getFieldCount() * 8;
        double rangePartitionCpuCost = 12.0 * inputRows;
        double svrCpuCost = 8.0 * inputRows;
        double networkCost = 512.0 * inputRows * (double)rowWidth;
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        return costFactory.makeCost(inputRows, rangePartitionCpuCost + svrCpuCost, 0.0, networkCost);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new OrderedPartitionExchangePrel(this.getCluster(), traitSet, (RelNode)OrderedPartitionExchangePrel.sole(inputs));
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        throw new IOException(this.getClass().getSimpleName() + " not supported yet!");
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }
}

