/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.drill.exec.physical.impl.join.JoinUtils;
import org.apache.drill.exec.planner.logical.DrillJoin;
import org.apache.drill.exec.planner.logical.DrillJoinRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.JoinPruleBase;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;

public class NestedLoopJoinPrule
extends JoinPruleBase {
    public static final RelOptRule INSTANCE = new NestedLoopJoinPrule("Prel.NestedLoopJoinPrule", RelOptHelper.any(DrillJoinRel.class));
    protected static final Logger tracer = CalciteTrace.getPlannerTracer();

    private NestedLoopJoinPrule(String name, RelOptRuleOperand operand) {
        super(operand, name);
    }

    @Override
    protected boolean checkPreconditions(DrillJoin join, RelNode left, RelNode right, PlannerSettings settings) {
        JoinRelType type = join.getJoinType();
        if (type != JoinRelType.INNER && type != JoinRelType.LEFT) {
            return false;
        }
        ArrayList<Integer> leftKeys = Lists.newArrayList();
        ArrayList<Integer> rightKeys = Lists.newArrayList();
        ArrayList<Boolean> filterNulls = Lists.newArrayList();
        JoinUtils.JoinCategory category = JoinUtils.getJoinCategory(left, right, join.getCondition(), leftKeys, rightKeys, filterNulls);
        if (category == JoinUtils.JoinCategory.EQUALITY && (settings.isHashJoinEnabled() || settings.isMergeJoinEnabled())) {
            return false;
        }
        if (settings.isNlJoinForScalarOnly()) {
            return JoinUtils.hasScalarSubqueryInput(left, right);
        }
        return true;
    }

    public boolean matches(RelOptRuleCall call) {
        return PrelUtil.getPlannerSettings(call.getPlanner()).isNestedLoopJoinEnabled();
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode right;
        RelNode left;
        PlannerSettings settings = PrelUtil.getPlannerSettings(call.getPlanner());
        if (!settings.isNestedLoopJoinEnabled()) {
            return;
        }
        DrillJoinRel join = (DrillJoinRel)call.rel(0);
        if (!this.checkPreconditions(join, left = join.getLeft(), right = join.getRight(), settings)) {
            return;
        }
        try {
            if (this.checkBroadcastConditions(call.getPlanner(), join, left, right)) {
                this.createBroadcastPlan(call, join, join.getCondition(), JoinPruleBase.PhysicalJoinType.NESTEDLOOP_JOIN, left, right, null, null);
            }
        }
        catch (InvalidRelException e) {
            tracer.warn(e.toString());
        }
    }
}

