/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.NestedLoopJoinPOP;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.physical.JoinPrel;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.record.BatchSchema;

public class NestedLoopJoinPrel
extends JoinPrel {
    public NestedLoopJoinPrel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType) throws InvalidRelException {
        super(cluster, traits, left, right, condition, joinType);
    }

    public NestedLoopJoinPrel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, boolean semijoin) throws InvalidRelException {
        super(cluster, traits, left, right, condition, joinType, semijoin);
    }

    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        try {
            return new NestedLoopJoinPrel(this.getCluster(), traitSet, left, right, conditionExpr, joinType);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return this.getLeft().estimateRowCount(mq) * this.getRight().estimateRowCount(mq);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }
        double leftRowCount = mq.getRowCount(this.getLeft());
        double rightRowCount = mq.getRowCount(this.getRight());
        double nljFactor = PrelUtil.getSettings(this.getCluster()).getNestedLoopJoinFactor();
        int exprNum = RelOptUtil.conjunctions((RexNode)this.getCondition()).size() + RelOptUtil.disjunctions((RexNode)this.getCondition()).size();
        double joinConditionCost = 4 * exprNum;
        double cpuCost = joinConditionCost * (leftRowCount * rightRowCount) * nljFactor;
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        return costFactory.makeCost(leftRowCount * rightRowCount, cpuCost, 0.0, 0.0, 0.0);
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        PhysicalOperator leftPop = ((Prel)this.left).getPhysicalOperator(creator);
        PhysicalOperator rightPop = ((Prel)this.right).getPhysicalOperator(creator);
        LogicalExpression condition = DrillOptiq.toDrill(new DrillParseContext(PrelUtil.getSettings(this.getCluster())), this.getInputs(), this.getCondition());
        NestedLoopJoinPOP nlj = new NestedLoopJoinPOP(leftPop, rightPop, this.getJoinType(), condition);
        return creator.addMetadata(this, nlj);
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.DEFAULT;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }
}

