/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.drill.exec.metastore.analyze.MetadataAggregateContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.MetadataStreamAggPOP;
import org.apache.drill.exec.planner.common.DrillRelNode;
import org.apache.drill.exec.planner.physical.AggPrelBase;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class MetadataStreamAggPrel
extends SingleRel
implements DrillRelNode,
Prel {
    private final MetadataAggregateContext context;
    private final AggPrelBase.OperatorPhase phase;

    public MetadataStreamAggPrel(RelOptCluster cluster, RelTraitSet traits, RelNode input, MetadataAggregateContext context, AggPrelBase.OperatorPhase phase) {
        super(cluster, traits, input);
        this.context = context;
        this.phase = phase;
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getInput();
        MetadataStreamAggPOP physicalOperator = new MetadataStreamAggPOP(child.getPhysicalOperator(creator), this.context, this.phase);
        return creator.addMetadata(this, physicalOperator);
    }

    @Override
    public <T, X, E extends Throwable> T accept(PrelVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitPrel(this, value);
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.DEFAULT;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    @Override
    public boolean needsFinalColumnReordering() {
        return false;
    }

    @Override
    public Iterator<Prel> iterator() {
        return PrelUtil.iter(this.getInput());
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        Preconditions.checkState(inputs.size() == 1);
        return new MetadataStreamAggPrel(this.getCluster(), traitSet, inputs.iterator().next(), this.context, this.phase);
    }

    public AggPrelBase.OperatorPhase getPhase() {
        return this.phase;
    }
}

