/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.common.logical.data.JoinCondition;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.MergeJoinPOP;
import org.apache.drill.exec.physical.impl.join.JoinUtils;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.physical.JoinPrel;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class MergeJoinPrel
extends JoinPrel {
    public MergeJoinPrel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType) throws InvalidRelException {
        super(cluster, traits, left, right, condition, joinType);
        this.joincategory = JoinUtils.getJoinCategory(left, right, condition, this.leftKeys, this.rightKeys, this.filterNulls);
    }

    public MergeJoinPrel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, boolean semijoin) throws InvalidRelException {
        super(cluster, traits, left, right, condition, joinType, semijoin);
        this.joincategory = JoinUtils.getJoinCategory(left, right, condition, this.leftKeys, this.rightKeys, this.filterNulls);
    }

    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        try {
            return new MergeJoinPrel(this.getCluster(), traitSet, left, right, conditionExpr, joinType);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }
        if (this.joincategory == JoinUtils.JoinCategory.CARTESIAN || this.joincategory == JoinUtils.JoinCategory.INEQUALITY || this.getJoinType() == JoinRelType.FULL) {
            return planner.getCostFactory().makeInfiniteCost();
        }
        double leftRowCount = mq.getRowCount(this.getLeft());
        double rightRowCount = mq.getRowCount(this.getRight());
        double joinConditionCost = 4 * this.getLeftKeys().size();
        double cpuCost = joinConditionCost * (leftRowCount + rightRowCount);
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        return costFactory.makeCost(leftRowCount + rightRowCount, cpuCost, 0.0, 0.0);
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        List fields = this.getRowType().getFieldNames();
        assert (MergeJoinPrel.isUnique(fields));
        int leftCount = this.left.getRowType().getFieldCount();
        List<String> leftFields = fields.subList(0, leftCount);
        List<String> rightFields = fields.subList(leftCount, fields.size());
        PhysicalOperator leftPop = ((Prel)this.left).getPhysicalOperator(creator);
        PhysicalOperator rightPop = ((Prel)this.right).getPhysicalOperator(creator);
        JoinRelType jtype = this.getJoinType();
        ArrayList<JoinCondition> conditions = Lists.newArrayList();
        this.buildJoinConditions(conditions, leftFields, rightFields, this.leftKeys, this.rightKeys);
        MergeJoinPOP mjoin = new MergeJoinPOP(leftPop, rightPop, conditions, jtype);
        return creator.addMetadata(this, mjoin);
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.DEFAULT;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }
}

