/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.Limit;
import org.apache.drill.exec.physical.config.PartitionLimit;
import org.apache.drill.exec.planner.common.DrillLimitRelBase;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;
import org.apache.drill.exec.record.BatchSchema;

public class LimitPrel
extends DrillLimitRelBase
implements Prel {
    private boolean isPartitioned = false;

    public LimitPrel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, child, offset, fetch);
    }

    public LimitPrel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode offset, RexNode fetch, boolean pushDown) {
        super(cluster, traitSet, child, offset, fetch, pushDown);
    }

    public LimitPrel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode offset, RexNode fetch, boolean pushDown, boolean isPartitioned) {
        super(cluster, traitSet, child, offset, fetch, pushDown);
        this.isPartitioned = isPartitioned;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new LimitPrel(this.getCluster(), traitSet, (RelNode)LimitPrel.sole(inputs), this.offset, this.fetch, this.isPushDown(), this.isPartitioned);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs, boolean pushDown) {
        return new LimitPrel(this.getCluster(), traitSet, (RelNode)LimitPrel.sole(inputs), this.offset, this.fetch, pushDown, this.isPartitioned);
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getInput();
        PhysicalOperator childPOP = child.getPhysicalOperator(creator);
        int first = this.offset != null ? Math.max(0, RexLiteral.intValue((RexNode)this.offset)) : 0;
        Integer last = this.fetch != null ? Integer.valueOf(Math.max(0, RexLiteral.intValue((RexNode)this.fetch)) + first) : null;
        Limit limit = this.isPartitioned ? new PartitionLimit(childPOP, first, last, "$drill_implicit_field$") : new Limit(childPOP, first, last);
        return creator.addMetadata(this, limit);
    }

    @Override
    public Iterator<Prel> iterator() {
        return PrelUtil.iter(this.getInput());
    }

    @Override
    public <T, X, E extends Throwable> T accept(PrelVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitPrel(this, value);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        pw.itemIf("partitioned", (Object)this.isPartitioned, this.isPartitioned);
        return pw;
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.NONE_AND_TWO;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.TWO_BYTE;
    }

    @Override
    public boolean needsFinalColumnReordering() {
        return true;
    }

    @Override
    public Prel prepareForLateralUnnestPipeline(List<RelNode> children) {
        return new LimitPrel(this.getCluster(), this.traitSet, children.get(0), this.getOffset(), this.getFetch(), this.isPushDown(), true);
    }
}

