/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.drill.exec.planner.logical.DrillLateralJoinRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.LateralJoinPrel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.Prule;

public class LateralJoinPrule
extends Prule {
    public static final RelOptRule INSTANCE = new LateralJoinPrule("Prel.LateralJoinPrule", RelOptHelper.any(DrillLateralJoinRel.class));

    private LateralJoinPrule(String name, RelOptRuleOperand operand) {
        super(operand, name);
    }

    public void onMatch(RelOptRuleCall call) {
        DrillLateralJoinRel lateralJoinRel = (DrillLateralJoinRel)call.rel(0);
        RelNode left = lateralJoinRel.getLeft();
        RelNode right = lateralJoinRel.getRight();
        RelTraitSet traitsLeft = left.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL);
        RelTraitSet traitsRight = right.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL);
        RelTraitSet corrTraits = traitsLeft.plus((RelTrait)DrillDistributionTrait.RANDOM_DISTRIBUTED);
        RelNode convertedLeft = LateralJoinPrule.convert(left, traitsLeft);
        RelNode convertedRight = LateralJoinPrule.convert(right, traitsRight);
        LateralJoinPrel lateralJoinPrel = new LateralJoinPrel(lateralJoinRel.getCluster(), corrTraits, convertedLeft, convertedRight, lateralJoinRel.excludeCorrelateColumn, lateralJoinRel.getCorrelationId(), lateralJoinRel.getRequiredColumns(), lateralJoinRel.getJoinType());
        call.transformTo((RelNode)lateralJoinPrel);
    }
}

