/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexChecker;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.logical.data.JoinCondition;
import org.apache.drill.exec.physical.impl.join.JoinUtils;
import org.apache.drill.exec.planner.common.DrillJoinRelBase;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JoinPrel
extends DrillJoinRelBase
implements Prel {
    private static final Logger logger = LoggerFactory.getLogger(JoinPrel.class);
    protected final boolean isSemiJoin;
    protected JoinUtils.JoinCategory joincategory;

    public JoinPrel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType) {
        this(cluster, traits, left, right, condition, joinType, false);
    }

    public JoinPrel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, boolean isSemiJoin) {
        super(cluster, traits, left, right, condition, joinType);
        this.isSemiJoin = isSemiJoin;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PrelVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitJoin(this, value);
    }

    @Override
    public Iterator<Prel> iterator() {
        return PrelUtil.iter(this.getLeft(), this.getRight());
    }

    public RelNode getJoinInput(int offset, RelNode input) {
        assert (JoinPrel.uniqueFieldNames(input.getRowType()));
        List fields = this.getRowType().getFieldNames();
        List inputFields = input.getRowType().getFieldNames();
        List outputFields = fields.size() > offset ? fields.subList(offset, offset + inputFields.size()) : new ArrayList();
        if (!outputFields.equals(inputFields)) {
            return this.rename(input, input.getRowType().getFieldList(), outputFields);
        }
        return input;
    }

    private RelNode rename(RelNode input, List<RelDataTypeField> inputFields, List<String> outputFieldNames) {
        if (outputFieldNames.size() == 0) {
            return input;
        }
        ArrayList<RexNode> exprs = Lists.newArrayList();
        for (RelDataTypeField field : inputFields) {
            RexInputRef expr = input.getCluster().getRexBuilder().makeInputRef(field.getType(), field.getIndex());
            exprs.add((RexNode)expr);
        }
        RelDataType rowType = RexUtil.createStructType((RelDataTypeFactory)input.getCluster().getTypeFactory(), exprs, outputFieldNames, null);
        ProjectPrel proj = new ProjectPrel(input.getCluster(), input.getTraitSet(), input, exprs, rowType);
        return proj;
    }

    @Override
    public boolean needsFinalColumnReordering() {
        return true;
    }

    protected void buildJoinConditions(List<JoinCondition> conditions, List<String> leftFields, List<String> rightFields, List<Integer> leftKeys, List<Integer> rightKeys) {
        List conjuncts = RelOptUtil.conjunctions((RexNode)this.getCondition());
        int i = 0;
        for (Pair pair : Pair.zip(leftKeys, rightKeys)) {
            int n = i;
            i = (short)(i + 1);
            RexNode conditionExpr = (RexNode)conjuncts.get(n);
            SqlKind kind = conditionExpr.getKind();
            if (kind != SqlKind.EQUALS && kind != SqlKind.IS_NOT_DISTINCT_FROM) {
                throw UserException.unsupportedError().message("Unsupported comparator in join condition %s", conditionExpr).build(logger);
            }
            conditions.add(new JoinCondition(kind.toString(), FieldReference.getWithQuotedRef(leftFields.get((Integer)pair.left)), FieldReference.getWithQuotedRef(rightFields.get((Integer)pair.right))));
        }
    }

    @Override
    public boolean isSemiJoin() {
        return this.isSemiJoin;
    }

    public boolean isValid(Litmus litmus, RelNode.Context context) {
        if (!this.isSemiJoin && !super.isValid(litmus, context)) {
            return false;
        }
        if (this.getRowType().getFieldCount() != this.getSystemFieldList().size() + this.left.getRowType().getFieldCount() + (this.isSemiJoin ? 0 : this.right.getRowType().getFieldCount())) {
            return litmus.fail("field count mismatch", new Object[0]);
        }
        if (this.condition != null) {
            if (this.condition.getType().getSqlTypeName() != SqlTypeName.BOOLEAN) {
                return litmus.fail("condition must be boolean: {}", new Object[]{this.condition.getType()});
            }
            RexChecker checker = new RexChecker(new RelDataTypeFactory.Builder(this.getCluster().getTypeFactory()).addAll((Iterable)this.getSystemFieldList()).addAll((Iterable)this.getLeft().getRowType().getFieldList()).addAll((Iterable)this.getRight().getRowType().getFieldList()).build(), context, litmus);
            this.condition.accept((RexVisitor)checker);
            if (checker.getFailureCount() > 0) {
                return litmus.fail(checker.getFailureCount() + " failures in condition " + this.condition, new Object[0]);
            }
        }
        return litmus.succeed();
    }

    public RelDataType deriveRowType() {
        if (this.isSemiJoin) {
            return SqlValidatorUtil.deriveJoinRowType((RelDataType)this.left.getRowType(), null, (JoinRelType)this.joinType, (RelDataTypeFactory)this.getCluster().getTypeFactory(), null, new ArrayList());
        }
        return super.deriveRowType();
    }
}

