/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.HashToRandomExchange;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.ExchangePrel;
import org.apache.drill.exec.planner.physical.HashPrelUtil;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.UnorderedDeMuxExchangePrel;
import org.apache.drill.exec.planner.physical.UnorderedMuxExchangePrel;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class HashToRandomExchangePrel
extends ExchangePrel {
    private final List<DrillDistributionTrait.DistributionField> fields;

    public HashToRandomExchangePrel(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<DrillDistributionTrait.DistributionField> fields) {
        super(cluster, traitSet, input);
        this.fields = fields;
        assert (input.getConvention() == Prel.DRILL_PHYSICAL);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }
        RelNode child = this.getInput();
        double inputRows = mq.getRowCount(child);
        int rowWidth = child.getRowType().getFieldCount() * 8;
        double hashCpuCost = 8.0 * inputRows / (double)this.fields.size();
        double svrCpuCost = 8.0 * inputRows;
        double networkCost = 512.0 * inputRows * (double)rowWidth;
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        return costFactory.makeCost(inputRows, hashCpuCost + svrCpuCost, 0.0, networkCost);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new HashToRandomExchangePrel(this.getCluster(), traitSet, (RelNode)HashToRandomExchangePrel.sole(inputs), this.fields);
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getInput();
        PhysicalOperator childPOP = child.getPhysicalOperator(creator);
        if (PrelUtil.getSettings(this.getCluster()).isSingleMode()) {
            return childPOP;
        }
        HashToRandomExchange g = new HashToRandomExchange(childPOP, HashPrelUtil.getHashExpression(this.fields, this.getInput().getRowType()));
        return creator.addMetadata(this, g);
    }

    public List<DrillDistributionTrait.DistributionField> getFields() {
        return this.fields;
    }

    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        for (Ord ord : Ord.zip(this.fields)) {
            pw.item("dist" + ord.i, ord.e);
        }
        return pw;
    }

    @Override
    public Prel constructMuxPrel(Prel child, OptionManager options) {
        boolean isMuxEnabled = options.getOption((String)PlannerSettings.MUX_EXCHANGE.getOptionName()).bool_val;
        Prel newPrel = child;
        List childFields = child.getRowType().getFieldNames();
        ArrayList<RexNode> removeUpdatedExpr = null;
        if (isMuxEnabled) {
            List<DrillDistributionTrait.DistributionField> distFields = this.getFields();
            ArrayList<String> outputFieldNames = Lists.newArrayList(childFields);
            RexBuilder rexBuilder = this.getCluster().getRexBuilder();
            List childRowTypeFields = child.getRowType().getFieldList();
            HashPrelUtil.RexNodeBasedHashExpressionCreatorHelper hashHelper = new HashPrelUtil.RexNodeBasedHashExpressionCreatorHelper(rexBuilder);
            ArrayList<RexInputRef> distFieldRefs = Lists.newArrayListWithExpectedSize(distFields.size());
            for (DrillDistributionTrait.DistributionField distributionField : distFields) {
                int fieldId = distributionField.getFieldId();
                distFieldRefs.add(rexBuilder.makeInputRef(((RelDataTypeField)childRowTypeFields.get(fieldId)).getType(), fieldId));
            }
            ArrayList<RexNode> updatedExpr = Lists.newArrayListWithExpectedSize(childRowTypeFields.size());
            removeUpdatedExpr = Lists.newArrayListWithExpectedSize(childRowTypeFields.size());
            for (RelDataTypeField field : childRowTypeFields) {
                RexInputRef rex = rexBuilder.makeInputRef(field.getType(), field.getIndex());
                updatedExpr.add((RexNode)rex);
                removeUpdatedExpr.add((RexNode)rex);
            }
            outputFieldNames.add("E_X_P_R_H_A_S_H_F_I_E_L_D");
            RexLiteral rexLiteral = rexBuilder.makeBigintLiteral(BigDecimal.valueOf(1301011L));
            updatedExpr.add(HashPrelUtil.createHashBasedPartitionExpression(distFieldRefs, rexLiteral, hashHelper));
            RelDataType rowType = RexUtil.createStructType((RelDataTypeFactory)this.getCluster().getTypeFactory(), updatedExpr, outputFieldNames, null);
            ProjectPrel addColumnprojectPrel = new ProjectPrel(child.getCluster(), child.getTraitSet(), child, updatedExpr, rowType);
            newPrel = new UnorderedMuxExchangePrel(addColumnprojectPrel.getCluster(), addColumnprojectPrel.getTraitSet(), addColumnprojectPrel);
        }
        newPrel = new HashToRandomExchangePrel(this.getCluster(), this.getTraitSet(), newPrel, this.getFields());
        if (options.getOption((String)PlannerSettings.DEMUX_EXCHANGE.getOptionName()).bool_val.booleanValue()) {
            HashToRandomExchangePrel hashExchangePrel = (HashToRandomExchangePrel)newPrel;
            newPrel = new UnorderedDeMuxExchangePrel(this.getCluster(), this.getTraitSet(), hashExchangePrel, hashExchangePrel.getFields());
        }
        if (isMuxEnabled) {
            RelDataType removeRowType = RexUtil.createStructType((RelDataTypeFactory)newPrel.getCluster().getTypeFactory(), removeUpdatedExpr, (List)childFields, null);
            ProjectPrel removeColumnProjectPrel = new ProjectPrel(newPrel.getCluster(), newPrel.getTraitSet(), newPrel, removeUpdatedExpr, removeRowType);
            return removeColumnProjectPrel;
        }
        return newPrel;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.ALL;
    }
}

