/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.HashToMergeExchange;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.ExchangePrel;
import org.apache.drill.exec.planner.physical.HashPrelUtil;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.record.BatchSchema;

public class HashToMergeExchangePrel
extends ExchangePrel {
    private final List<DrillDistributionTrait.DistributionField> distFields;
    private int numEndPoints = 0;
    private final RelCollation collation;

    public HashToMergeExchangePrel(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<DrillDistributionTrait.DistributionField> fields, RelCollation collation, int numEndPoints) {
        super(cluster, traitSet, input);
        this.distFields = fields;
        this.collation = collation;
        this.numEndPoints = numEndPoints;
        assert (input.getConvention() == Prel.DRILL_PHYSICAL);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }
        RelNode child = this.getInput();
        double inputRows = mq.getRowCount(child);
        int rowWidth = child.getRowType().getFieldCount() * 8;
        double hashCpuCost = 8.0 * inputRows * (double)this.distFields.size();
        double svrCpuCost = 8.0 * inputRows;
        double mergeCpuCost = 4.0 * inputRows * (Math.log(this.numEndPoints) / Math.log(2.0));
        double networkCost = 512.0 * inputRows * (double)rowWidth;
        DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
        return costFactory.makeCost(inputRows, hashCpuCost + svrCpuCost + mergeCpuCost, 0.0, networkCost);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new HashToMergeExchangePrel(this.getCluster(), traitSet, (RelNode)HashToMergeExchangePrel.sole(inputs), this.distFields, this.collation, this.numEndPoints);
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getInput();
        PhysicalOperator childPOP = child.getPhysicalOperator(creator);
        if (PrelUtil.getSettings(this.getCluster()).isSingleMode()) {
            return childPOP;
        }
        HashToMergeExchange g = new HashToMergeExchange(childPOP, HashPrelUtil.getHashExpression(this.distFields, this.getInput().getRowType()), PrelUtil.getOrdering(this.collation, this.getInput().getRowType()));
        return creator.addMetadata(this, g);
    }

    public RelCollation getCollation() {
        return this.collation;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }
}

