/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.drill.common.logical.data.JoinCondition;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.HashJoinPOP;
import org.apache.drill.exec.physical.impl.join.JoinUtils;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.JoinPrel;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.work.filter.RuntimeFilterDef;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class HashJoinPrel
extends JoinPrel {
    private boolean swapped = false;
    private RuntimeFilterDef runtimeFilterDef;
    protected boolean isRowKeyJoin = false;
    private int joinControl;

    public HashJoinPrel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, boolean semiJoin) throws InvalidRelException {
        this(cluster, traits, left, right, condition, joinType, false, null, false, 0, semiJoin);
    }

    public HashJoinPrel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, boolean swapped, RuntimeFilterDef runtimeFilterDef, boolean isRowKeyJoin, int joinControl) throws InvalidRelException {
        this(cluster, traits, left, right, condition, joinType, swapped, runtimeFilterDef, isRowKeyJoin, joinControl, false);
    }

    public HashJoinPrel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, boolean swapped, RuntimeFilterDef runtimeFilterDef, boolean isRowKeyJoin, int joinControl, boolean semiJoin) throws InvalidRelException {
        super(cluster, traits, left, right, condition, joinType, semiJoin);
        Preconditions.checkArgument(this.isSemiJoin && !swapped || swapped && !this.isSemiJoin || !swapped && !this.isSemiJoin);
        if (this.isSemiJoin) {
            Preconditions.checkArgument(!swapped, "swapping of inputs is not allowed for semi-joins");
            Preconditions.checkArgument(HashJoinPrel.validateTraits(this.traitSet, left, right));
        }
        this.swapped = swapped;
        this.isRowKeyJoin = isRowKeyJoin;
        this.joincategory = JoinUtils.getJoinCategory(left, right, condition, this.leftKeys, this.rightKeys, this.filterNulls);
        this.runtimeFilterDef = runtimeFilterDef;
        this.joinControl = joinControl;
    }

    private static boolean validateTraits(RelTraitSet traitSet, RelNode left, RelNode right) {
        ImmutableBitSet bitSet = ImmutableBitSet.range((int)left.getRowType().getFieldCount(), (int)(left.getRowType().getFieldCount() + right.getRowType().getFieldCount()));
        for (RelTrait trait : traitSet) {
            if (trait.getTraitDef().getTraitClass().equals(RelCollation.class)) {
                RelCollation collationTrait = (RelCollation)trait;
                for (RelFieldCollation relFieldCollation : collationTrait.getFieldCollations()) {
                    if (bitSet.indexOf(relFieldCollation.getFieldIndex()) <= 0) continue;
                    return false;
                }
                continue;
            }
            if (!trait.getTraitDef().getTraitClass().equals(DrillDistributionTrait.class)) continue;
            DrillDistributionTrait distributionTrait = (DrillDistributionTrait)trait;
            for (DrillDistributionTrait.DistributionField distributionField : distributionTrait.getFields()) {
                if (bitSet.indexOf(distributionField.getFieldId()) <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        try {
            return new HashJoinPrel(this.getCluster(), traitSet, left, right, conditionExpr, joinType, this.swapped, this.runtimeFilterDef, this.isRowKeyJoin, this.joinControl, this.isSemiJoin);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        if (PrelUtil.getSettings(this.getCluster()).useDefaultCosting()) {
            return super.computeSelfCost(planner, mq).multiplyBy(0.1);
        }
        if (this.joincategory == JoinUtils.JoinCategory.CARTESIAN || this.joincategory == JoinUtils.JoinCategory.INEQUALITY) {
            return planner.getCostFactory().makeInfiniteCost();
        }
        return this.computeHashJoinCost(planner, mq);
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        if (!this.swapped) {
            return this.getHashJoinPop(creator, this.left, this.right, this.leftKeys, this.rightKeys, this.isRowKeyJoin, this.joinControl);
        }
        return this.getHashJoinPop(creator, this.right, this.left, this.rightKeys, this.leftKeys, this.isRowKeyJoin, this.joinControl);
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.DEFAULT;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }

    private PhysicalOperator getHashJoinPop(PhysicalPlanCreator creator, RelNode left, RelNode right, List<Integer> leftKeys, List<Integer> rightKeys, boolean isRowKeyJoin, int htControl) throws IOException {
        List fields = this.getRowType().getFieldNames();
        assert (HashJoinPrel.isUnique(fields));
        List leftFields = left.getRowType().getFieldNames();
        List rightFields = right.getRowType().getFieldNames();
        PhysicalOperator leftPop = ((Prel)left).getPhysicalOperator(creator);
        PhysicalOperator rightPop = ((Prel)right).getPhysicalOperator(creator);
        JoinRelType jtype = this.getJoinType();
        ArrayList<JoinCondition> conditions = Lists.newArrayList();
        this.buildJoinConditions(conditions, leftFields, rightFields, leftKeys, rightKeys);
        RuntimeFilterDef runtimeFilterDef = this.getRuntimeFilterDef();
        HashJoinPOP hjoin = new HashJoinPOP(leftPop, rightPop, conditions, jtype, this.isSemiJoin, runtimeFilterDef, isRowKeyJoin, htControl);
        return creator.addMetadata(this, hjoin);
    }

    public void setSwapped(boolean swapped) {
        this.swapped = swapped;
    }

    public boolean isSwapped() {
        return this.swapped;
    }

    public RuntimeFilterDef getRuntimeFilterDef() {
        return this.runtimeFilterDef;
    }

    public void setRuntimeFilterDef(RuntimeFilterDef runtimeFilterDef) {
        this.runtimeFilterDef = runtimeFilterDef;
    }

    public boolean isRowKeyJoin() {
        return this.isRowKeyJoin;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("semi-join: ", (Object)this.isSemiJoin);
    }
}

