/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.drill.exec.planner.physical.BroadcastExchangePrel;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.HashToRandomExchangePrel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.RangePartitionExchangePrel;
import org.apache.drill.exec.planner.physical.UnionExchangePrel;

public class DrillDistributionTraitDef
extends RelTraitDef<DrillDistributionTrait> {
    public static final DrillDistributionTraitDef INSTANCE = new DrillDistributionTraitDef();

    private DrillDistributionTraitDef() {
    }

    public boolean canConvert(RelOptPlanner planner, DrillDistributionTrait fromTrait, DrillDistributionTrait toTrait) {
        return true;
    }

    public Class<DrillDistributionTrait> getTraitClass() {
        return DrillDistributionTrait.class;
    }

    public DrillDistributionTrait getDefault() {
        return DrillDistributionTrait.DEFAULT;
    }

    public String getSimpleName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public RelNode convert(RelOptPlanner planner, RelNode rel, DrillDistributionTrait toDist, boolean allowInfiniteCostConverters) {
        DrillDistributionTrait currentDist = (DrillDistributionTrait)rel.getTraitSet().getTrait((RelTraitDef)INSTANCE);
        if (currentDist.equals(toDist)) {
            return rel;
        }
        if (currentDist.equals(DrillDistributionTrait.DEFAULT) && !(rel instanceof RelSubset)) {
            return null;
        }
        if (rel.getConvention() != Prel.DRILL_PHYSICAL) {
            return null;
        }
        switch (toDist.getType()) {
            case SINGLETON: {
                return new UnionExchangePrel(rel.getCluster(), planner.emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)toDist), rel);
            }
            case HASH_DISTRIBUTED: {
                return new HashToRandomExchangePrel(rel.getCluster(), planner.emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)toDist), rel, toDist.getFields());
            }
            case RANGE_DISTRIBUTED: {
                return new RangePartitionExchangePrel(rel.getCluster(), planner.emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)toDist), rel, toDist.getFields(), toDist.getPartitionFunction());
            }
            case BROADCAST_DISTRIBUTED: {
                return new BroadcastExchangePrel(rel.getCluster(), planner.emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)toDist), rel);
            }
            case ANY: {
                return rel;
            }
        }
        return null;
    }
}

