/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.planner.logical.DrillAnalyzeRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.FilterPrel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.StatsAggPrel;
import org.apache.drill.exec.planner.physical.StatsMergePrel;
import org.apache.drill.exec.planner.physical.UnionExchangePrel;
import org.apache.drill.exec.planner.physical.UnpivotMapsPrel;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;

public class AnalyzePrule
extends Prule {
    public static final RelOptRule INSTANCE = new AnalyzePrule();
    private static final List<String> PHASE_1_FUNCTIONS = ImmutableList.of("rowcount", "nonnullrowcount", "sum_width", "approx_count_dups", "hll", "tdigest");
    private static Map<String, String> PHASE_2_FUNCTIONS = new HashMap<String, String>();
    private static final List<String> UNPIVOT_FUNCTIONS;

    public AnalyzePrule() {
        super(RelOptHelper.some(DrillAnalyzeRel.class, (RelTrait)DrillRel.DRILL_LOGICAL, RelOptHelper.any(RelNode.class), new RelOptRuleOperand[0]), "Prel.AnalyzePrule");
    }

    public void onMatch(RelOptRuleCall call) {
        DrillAnalyzeRel analyze = (DrillAnalyzeRel)call.rel(0);
        RelNode input = call.rel(1);
        RelTraitSet singleDistTrait = call.getPlanner().emptyTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)DrillDistributionTrait.SINGLETON);
        RelTraitSet traits = input.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)DrillDistributionTrait.DEFAULT);
        RelNode convertedInput = AnalyzePrule.convert(input, traits);
        ArrayList<String> mapFields1 = Lists.newArrayList(PHASE_1_FUNCTIONS);
        HashMap<String, String> mapFields2 = Maps.newHashMap(PHASE_2_FUNCTIONS);
        ArrayList<String> mapFields3 = Lists.newArrayList(UNPIVOT_FUNCTIONS);
        mapFields1.add(0, "column");
        mapFields1.add(1, "majortype");
        mapFields2.put("column", "column");
        mapFields2.put("majortype", "majortype");
        mapFields3.add(0, "column");
        mapFields3.add(1, "majortype");
        if (analyze.getSamplePercent() < 100.0) {
            RexBuilder builder = convertedInput.getCluster().getRexBuilder();
            RexNode sampleCondition = PrelUtil.getSettings(convertedInput.getCluster()).getOptions().getOption(ExecConstants.DETERMINISTIC_SAMPLING_VALIDATOR) ? builder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{builder.makeCall((SqlOperator)SqlStdOperatorTable.RAND, new RexNode[]{builder.makeExactLiteral(BigDecimal.valueOf(1L))}), builder.makeExactLiteral(BigDecimal.valueOf(analyze.getSamplePercent() / 100.0))}) : builder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{builder.makeCall((SqlOperator)SqlStdOperatorTable.RAND, new RexNode[0]), builder.makeExactLiteral(BigDecimal.valueOf(analyze.getSamplePercent() / 100.0))});
            convertedInput = new FilterPrel(convertedInput.getCluster(), convertedInput.getTraitSet(), convertedInput, sampleCondition);
        }
        StatsAggPrel statsAggPrel = new StatsAggPrel(analyze.getCluster(), traits, convertedInput, PHASE_1_FUNCTIONS);
        UnionExchangePrel exch = new UnionExchangePrel(statsAggPrel.getCluster(), singleDistTrait, statsAggPrel);
        StatsMergePrel statsMergePrel = new StatsMergePrel(exch.getCluster(), singleDistTrait, exch, mapFields2, analyze.getSamplePercent());
        UnpivotMapsPrel newAnalyze = new UnpivotMapsPrel(statsMergePrel.getCluster(), singleDistTrait, statsMergePrel, mapFields3);
        call.transformTo((RelNode)newAnalyze);
    }

    static {
        PHASE_2_FUNCTIONS.put("rowcount", "rowcount");
        PHASE_2_FUNCTIONS.put("nonnullrowcount", "nonnullrowcount");
        PHASE_2_FUNCTIONS.put("avg_width", "sum_width");
        PHASE_2_FUNCTIONS.put("sum", "approx_count_dups");
        PHASE_2_FUNCTIONS.put("hll_merge", "hll");
        PHASE_2_FUNCTIONS.put("approx_count_distinct", "hll");
        PHASE_2_FUNCTIONS.put("tdigest_merge", "tdigest");
        UNPIVOT_FUNCTIONS = ImmutableList.of("rowcount", "nonnullrowcount", "avg_width", "hll_merge", "sum", "approx_count_distinct", "tdigest_merge");
    }
}

