/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical.partition;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.BitSets;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.expr.fn.interpreter.InterpreterEvaluator;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.physical.base.FileGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.FileSystemPartitionDescriptor;
import org.apache.drill.exec.planner.PartitionDescriptor;
import org.apache.drill.exec.planner.PartitionLocation;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.DrillValuesRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.logical.SelectionBasedTableScan;
import org.apache.drill.exec.planner.logical.partition.FindPartitionConditions;
import org.apache.drill.exec.planner.logical.partition.RewriteAsBinaryOperators;
import org.apache.drill.exec.planner.logical.partition.RewriteCombineBinaryOperators;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.FormatSelection;
import org.apache.drill.exec.store.dfs.MetadataContext;
import org.apache.drill.exec.util.DrillFileSystemUtil;
import org.apache.drill.exec.vector.NullableBitVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PruneScanRule
extends StoragePluginOptimizerRule {
    static final Logger logger = LoggerFactory.getLogger(PruneScanRule.class);
    final OptimizerRulesContext optimizerContext;

    public PruneScanRule(RelOptRuleOperand operand, String id, OptimizerRulesContext optimizerContext) {
        super(operand, id);
        this.optimizerContext = optimizerContext;
    }

    public static RelOptRule getDirFilterOnProject(OptimizerRulesContext optimizerRulesContext) {
        return new DirPruneScanFilterOnProjectRule(optimizerRulesContext);
    }

    public static RelOptRule getDirFilterOnScan(OptimizerRulesContext optimizerRulesContext) {
        return new DirPruneScanFilterOnScanRule(optimizerRulesContext);
    }

    public static RelOptRule getConvertAggScanToValuesRule(OptimizerRulesContext optimizerRulesContext) {
        return new ConvertAggScanToValuesRule(optimizerRulesContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOnMatch(RelOptRuleCall call, Filter filterRel, Project projectRel, TableScan scanRel) {
        String pruningClassName = ((Object)((Object)this)).getClass().getName();
        logger.debug("Beginning partition pruning, pruning class: {}", (Object)pruningClassName);
        Stopwatch totalPruningTime = logger.isDebugEnabled() ? Stopwatch.createStarted() : null;
        PlannerSettings settings = PrelUtil.getPlannerSettings(call.getPlanner());
        PartitionDescriptor descriptor = this.getPartitionDescriptor(settings, scanRel);
        BufferAllocator allocator = this.optimizerContext.getAllocator();
        Object selection = DrillRelOptUtil.getDrillTable((RelNode)scanRel).getSelection();
        MetadataContext metaContext = null;
        if (selection instanceof FormatSelection) {
            metaContext = ((FormatSelection)selection).getSelection().getMetaContext();
        }
        RexNode condition = projectRel == null ? filterRel.getCondition() : RelOptUtil.pushPastProject((RexNode)filterRel.getCondition(), (Project)projectRel);
        RewriteAsBinaryOperators visitor = new RewriteAsBinaryOperators(true, filterRel.getCluster().getRexBuilder());
        condition = (RexNode)condition.accept((RexVisitor)visitor);
        HashMap<Integer, String> fieldNameMap = new HashMap<Integer, String>();
        List fieldNames = scanRel.getRowType().getFieldNames();
        BitSet columnBitset = new BitSet();
        BitSet partitionColumnBitSet = new BitSet();
        HashMap<Integer, Integer> partitionMap = new HashMap<Integer, Integer>();
        int relColIndex = 0;
        for (String field : fieldNames) {
            Integer partitionIndex = descriptor.getIdIfValid(field);
            if (partitionIndex != null) {
                fieldNameMap.put(partitionIndex, field);
                partitionColumnBitSet.set(partitionIndex);
                columnBitset.set(relColIndex);
                partitionMap.put(relColIndex, partitionIndex);
            }
            ++relColIndex;
        }
        if (partitionColumnBitSet.isEmpty()) {
            if (totalPruningTime != null) {
                logger.debug("No partition columns are projected from the scan..continue. Total pruning elapsed time: {} ms", (Object)totalPruningTime.elapsed(TimeUnit.MILLISECONDS));
            }
            PruneScanRule.setPruneStatus(metaContext, MetadataContext.PruneStatus.NOT_PRUNED);
            return;
        }
        Stopwatch miscTimer = logger.isDebugEnabled() ? Stopwatch.createStarted() : null;
        FindPartitionConditions c = new FindPartitionConditions(columnBitset, filterRel.getCluster().getRexBuilder());
        c.analyze(condition);
        RexNode pruneCondition = c.getFinalCondition();
        BitSet referencedDirsBitSet = c.getReferencedDirs();
        if (miscTimer != null) {
            logger.debug("Total elapsed time to build and analyze filter tree: {} ms", (Object)miscTimer.elapsed(TimeUnit.MILLISECONDS));
            miscTimer.reset();
        }
        if (pruneCondition == null) {
            if (totalPruningTime != null) {
                logger.debug("No conditions were found eligible for partition pruning. Total pruning elapsed time: {} ms", (Object)totalPruningTime.elapsed(TimeUnit.MILLISECONDS));
            }
            PruneScanRule.setPruneStatus(metaContext, MetadataContext.PruneStatus.NOT_PRUNED);
            return;
        }
        ArrayList<PartitionLocation> newPartitions = new ArrayList<PartitionLocation>();
        long numTotal = 0L;
        int batchIndex = 0;
        PartitionLocation firstLocation = null;
        LogicalExpression materializedExpr = null;
        String[] spInfo = null;
        int maxIndex = -1;
        BitSet matchBitSet = new BitSet();
        for (List partitions : descriptor) {
            numTotal += (long)partitions.size();
            logger.debug("Evaluating partition pruning for batch {}", (Object)batchIndex);
            if (batchIndex == 0) {
                firstLocation = (PartitionLocation)partitions.get(0);
            }
            NullableBitVector output = new NullableBitVector(MaterializedField.create("", Types.optional(TypeProtos.MinorType.BIT)), allocator);
            VectorContainer container = new VectorContainer();
            try {
                ValueVector[] vectors = new ValueVector[descriptor.getMaxHierarchyLevel()];
                Iterator iterator = BitSets.toIter((BitSet)partitionColumnBitSet).iterator();
                while (iterator.hasNext()) {
                    int partitionColumnIndex = (Integer)iterator.next();
                    Iterator column = SchemaPath.getSimplePath((String)fieldNameMap.get(partitionColumnIndex));
                    TypeProtos.MajorType type = descriptor.getVectorType((SchemaPath)((Object)column), settings).toBuilder().setMode(TypeProtos.DataMode.OPTIONAL).build();
                    MaterializedField field = MaterializedField.create(((SchemaPath)((Object)column)).getLastSegment().getNameSegment().getPath(), type);
                    ValueVector v = TypeHelper.getNewVector(field, allocator);
                    v.allocateNew();
                    vectors[partitionColumnIndex] = v;
                    container.add(v);
                }
                if (miscTimer != null) {
                    miscTimer.start();
                }
                descriptor.populatePartitionVectors(vectors, partitions, partitionColumnBitSet, fieldNameMap);
                if (miscTimer != null) {
                    logger.debug("Elapsed time to populate partitioning column vectors: {} ms within batchIndex: {}", (Object)miscTimer.elapsed(TimeUnit.MILLISECONDS), (Object)batchIndex);
                    miscTimer.reset();
                }
                if (batchIndex == 0 && (materializedExpr = this.materializePruneExpr(pruneCondition, settings, (RelNode)scanRel, container)) == null) {
                    if (totalPruningTime != null) {
                        logger.debug("Total pruning elapsed time: {} ms", (Object)totalPruningTime.elapsed(TimeUnit.MILLISECONDS));
                    }
                    PruneScanRule.setPruneStatus(metaContext, MetadataContext.PruneStatus.NOT_PRUNED);
                    return;
                }
                output.allocateNew(partitions.size());
                if (miscTimer != null) {
                    miscTimer.start();
                }
                InterpreterEvaluator.evaluate(partitions.size(), this.optimizerContext, container, output, materializedExpr);
                if (miscTimer != null) {
                    logger.debug("Elapsed time in interpreter evaluation: {} ms within batchIndex: {} with # of partitions : {}", new Object[]{miscTimer.elapsed(TimeUnit.MILLISECONDS), batchIndex, partitions.size()});
                    miscTimer.reset();
                }
                int recordCount = 0;
                int qualifiedCount = 0;
                if (descriptor.supportsMetadataCachePruning() && ((PartitionLocation)partitions.get(0)).isCompositePartition()) {
                    for (PartitionLocation part : partitions) {
                        assert (part.isCompositePartition());
                        if (!output.getAccessor().isNull(recordCount) && output.getAccessor().get(recordCount) == 1) {
                            int j;
                            newPartitions.add(part);
                            Pair<String[], Integer> p = this.composePartition(referencedDirsBitSet, partitionMap, vectors, recordCount);
                            String[] parts = (String[])p.getLeft();
                            int tmpIndex = (Integer)p.getRight();
                            maxIndex = Math.max(maxIndex, tmpIndex);
                            if (spInfo == null) {
                                spInfo = parts;
                                for (j = 0; j <= tmpIndex; ++j) {
                                    if (parts[j] == null) continue;
                                    matchBitSet.set(j);
                                }
                            } else {
                                for (j = 0; j <= tmpIndex; ++j) {
                                    if (parts[j] == null || spInfo[j] == null) {
                                        matchBitSet.clear(j);
                                        continue;
                                    }
                                    if (parts[j].equals(spInfo[j])) continue;
                                    matchBitSet.clear(j);
                                }
                            }
                            ++qualifiedCount;
                        }
                        ++recordCount;
                    }
                } else {
                    for (PartitionLocation part : partitions) {
                        if (!output.getAccessor().isNull(recordCount) && output.getAccessor().get(recordCount) == 1) {
                            newPartitions.add(part);
                            ++qualifiedCount;
                        }
                        ++recordCount;
                    }
                }
                logger.debug("Within batch {}: total records: {}, qualified records: {}", new Object[]{batchIndex, recordCount, qualifiedCount});
                ++batchIndex;
            }
            catch (Exception e) {
                logger.warn("Exception while trying to prune partition.", (Throwable)e);
                if (totalPruningTime != null) {
                    logger.debug("Total pruning elapsed time: {} ms", (Object)totalPruningTime.elapsed(TimeUnit.MILLISECONDS));
                }
                PruneScanRule.setPruneStatus(metaContext, MetadataContext.PruneStatus.NOT_PRUNED);
                return;
            }
            finally {
                container.clear();
                if (output == null) continue;
                output.clear();
            }
        }
        try {
            TableScan inputRel;
            if ((long)newPartitions.size() == numTotal) {
                logger.debug("No partitions were eligible for pruning");
                return;
            }
            boolean canDropFilter = true;
            boolean wasAllPartitionsPruned = false;
            Path cacheFileRoot = null;
            if (newPartitions.isEmpty()) {
                assert (firstLocation != null);
                newPartitions.add(firstLocation.getPartitionLocationRecursive().get(0));
                canDropFilter = false;
                wasAllPartitionsPruned = true;
                logger.debug("All {} partitions were pruned; added back a single partition to allow creating a schema", (Object)numTotal);
                if (firstLocation.isCompositePartition()) {
                    cacheFileRoot = Path.mergePaths((Path)descriptor.getBaseTableLocation(), (Path)firstLocation.getCompositePartitionPath());
                }
            }
            logger.debug("Pruned {} partitions down to {}", (Object)numTotal, (Object)newPartitions.size());
            List conjuncts = RelOptUtil.conjunctions((RexNode)condition);
            List pruneConjuncts = RelOptUtil.conjunctions((RexNode)pruneCondition);
            conjuncts.removeAll(pruneConjuncts);
            RexNode newCondition = RexUtil.composeConjunction((RexBuilder)filterRel.getCluster().getRexBuilder(), (Iterable)conjuncts, (boolean)false);
            RewriteCombineBinaryOperators reverseVisitor = new RewriteCombineBinaryOperators(true, filterRel.getCluster().getRexBuilder());
            condition = (RexNode)condition.accept((RexVisitor)reverseVisitor);
            pruneCondition = (RexNode)pruneCondition.accept((RexVisitor)reverseVisitor);
            if (descriptor.supportsMetadataCachePruning() && !wasAllPartitionsPruned) {
                int index = -1;
                if (!matchBitSet.isEmpty()) {
                    int j;
                    StringBuilder path = new StringBuilder();
                    index = matchBitSet.length() - 1;
                    for (j = 0; j < matchBitSet.length(); ++j) {
                        if (matchBitSet.get(j)) continue;
                        index = j - 1;
                        break;
                    }
                    for (j = 0; j <= index; ++j) {
                        path.append("/").append((String)spInfo[j]);
                    }
                    cacheFileRoot = Path.mergePaths((Path)descriptor.getBaseTableLocation(), (Path)DrillFileSystemUtil.createPathSafe(path.toString()));
                }
                if (index != maxIndex) {
                    canDropFilter = false;
                }
            }
            TableScan tableScan = inputRel = descriptor.supportsMetadataCachePruning() ? descriptor.createTableScan(newPartitions, cacheFileRoot, wasAllPartitionsPruned, metaContext) : descriptor.createTableScan(newPartitions, wasAllPartitionsPruned);
            if (projectRel != null) {
                inputRel = projectRel.copy(projectRel.getTraitSet(), Collections.singletonList(inputRel));
            }
            if (newCondition.isAlwaysTrue() && canDropFilter) {
                call.transformTo((RelNode)inputRel);
            } else {
                RelNode newFilter = filterRel.copy(filterRel.getTraitSet(), Collections.singletonList(inputRel));
                call.transformTo(newFilter);
            }
            PruneScanRule.setPruneStatus(metaContext, MetadataContext.PruneStatus.PRUNED);
        }
        catch (Exception e) {
            logger.warn("Exception while using the pruned partitions.", (Throwable)e);
        }
        finally {
            if (totalPruningTime != null) {
                logger.debug("Total pruning elapsed time: {} ms", (Object)totalPruningTime.elapsed(TimeUnit.MILLISECONDS));
            }
        }
    }

    private Pair<String[], Integer> composePartition(BitSet referencedDirsBitSet, Map<Integer, Integer> partitionMap, ValueVector[] vectors, int recordCount) {
        String[] partition = new String[vectors.length];
        int maxIndex = -1;
        Iterator iterator = BitSets.toIter((BitSet)referencedDirsBitSet).iterator();
        while (iterator.hasNext()) {
            String value;
            int referencedDirsIndex = (Integer)iterator.next();
            int partitionColumnIndex = partitionMap.get(referencedDirsIndex);
            ValueVector vv = vectors[partitionColumnIndex];
            if (vv.getAccessor().getValueCount() <= 0 || vv.getAccessor().getObject(recordCount) == null) continue;
            partition[partitionColumnIndex] = value = vv.getAccessor().getObject(recordCount).toString();
            maxIndex = Math.max(maxIndex, partitionColumnIndex);
        }
        return Pair.of((Object)partition, (Object)maxIndex);
    }

    protected LogicalExpression materializePruneExpr(RexNode pruneCondition, PlannerSettings settings, RelNode scanRel, VectorContainer container) {
        logger.debug("Attempting to prune {}", (Object)pruneCondition);
        LogicalExpression expr = DrillOptiq.toDrill(new DrillParseContext(settings), scanRel, pruneCondition);
        ErrorCollectorImpl errors = new ErrorCollectorImpl();
        LogicalExpression materializedExpr = ExpressionTreeMaterializer.materialize(expr, container, errors, this.optimizerContext.getFunctionRegistry());
        if (materializedExpr.getMajorType().getMode() == TypeProtos.DataMode.REQUIRED) {
            materializedExpr = ExpressionTreeMaterializer.convertToNullableType(materializedExpr, materializedExpr.getMajorType().getMinorType(), this.optimizerContext.getFunctionRegistry(), errors);
        }
        if (errors.getErrorCount() != 0) {
            logger.warn("Failure while materializing expression [{}].  Errors: {}", (Object)expr, (Object)errors);
            return null;
        }
        return materializedExpr;
    }

    protected OptimizerRulesContext getOptimizerRulesContext() {
        return this.optimizerContext;
    }

    public abstract PartitionDescriptor getPartitionDescriptor(PlannerSettings var1, TableScan var2);

    private static boolean isQualifiedDirPruning(TableScan scan) {
        if (PruneScanRule.supportsScan(scan)) {
            Object selection = DrillRelOptUtil.getDrillTable((RelNode)scan).getSelection();
            return selection instanceof FormatSelection && ((FormatSelection)selection).supportsDirPruning();
        }
        if (scan instanceof DrillScanRel) {
            GroupScan groupScan = ((DrillScanRel)scan).getGroupScan();
            return groupScan instanceof FileGroupScan && groupScan.supportsPartitionFilterPushdown() && !((DrillScanRel)scan).partitionFilterPushdown();
        }
        return false;
    }

    private static void setPruneStatus(MetadataContext metaContext, MetadataContext.PruneStatus pruneStatus) {
        if (metaContext != null) {
            metaContext.setPruneStatus(pruneStatus);
        }
    }

    private static boolean supportsScan(TableScan scan) {
        return scan instanceof SelectionBasedTableScan;
    }

    private static class DirPruneScanFilterOnProjectRule
    extends PruneScanRule {
        public DirPruneScanFilterOnProjectRule(OptimizerRulesContext optimizerRulesContext) {
            super(RelOptHelper.some(Filter.class, RelOptHelper.some(Project.class, RelOptHelper.any(TableScan.class), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "DirPruneScanRule:Filter_On_Project", optimizerRulesContext);
        }

        @Override
        public PartitionDescriptor getPartitionDescriptor(PlannerSettings settings, TableScan scanRel) {
            return new FileSystemPartitionDescriptor(settings, scanRel);
        }

        public boolean matches(RelOptRuleCall call) {
            TableScan scan = (TableScan)call.rel(2);
            return PruneScanRule.isQualifiedDirPruning(scan);
        }

        public void onMatch(RelOptRuleCall call) {
            Filter filterRel = (Filter)call.rel(0);
            Project projectRel = (Project)call.rel(1);
            TableScan scanRel = (TableScan)call.rel(2);
            this.doOnMatch(call, filterRel, projectRel, scanRel);
        }
    }

    private static class DirPruneScanFilterOnScanRule
    extends PruneScanRule {
        public DirPruneScanFilterOnScanRule(OptimizerRulesContext optimizerRulesContext) {
            super(RelOptHelper.some(Filter.class, RelOptHelper.any(TableScan.class), new RelOptRuleOperand[0]), "DirPruneScanRule:Filter_On_Scan", optimizerRulesContext);
        }

        @Override
        public PartitionDescriptor getPartitionDescriptor(PlannerSettings settings, TableScan scanRel) {
            return new FileSystemPartitionDescriptor(settings, scanRel);
        }

        public boolean matches(RelOptRuleCall call) {
            TableScan scan = (TableScan)call.rel(1);
            return PruneScanRule.isQualifiedDirPruning(scan);
        }

        public void onMatch(RelOptRuleCall call) {
            Filter filterRel = (Filter)call.rel(0);
            TableScan scanRel = (TableScan)call.rel(1);
            this.doOnMatch(call, filterRel, null, scanRel);
        }
    }

    private static class ConvertAggScanToValuesRule
    extends PruneScanRule {
        private final Pattern dirPattern;

        private ConvertAggScanToValuesRule(OptimizerRulesContext optimizerRulesContext) {
            super(RelOptHelper.some(Aggregate.class, (RelTrait)DrillRel.DRILL_LOGICAL, RelOptHelper.any(TableScan.class), new RelOptRuleOperand[0]), "PartitionColumnScanPruningRule:Prune_On_Scan", optimizerRulesContext);
            String partitionColumnLabel = optimizerRulesContext.getPlannerSettings().getFsPartitionColumnLabel();
            this.dirPattern = Pattern.compile(partitionColumnLabel + "\\d+");
        }

        @Override
        public PartitionDescriptor getPartitionDescriptor(PlannerSettings settings, TableScan scanRel) {
            return new FileSystemPartitionDescriptor(settings, scanRel);
        }

        public boolean matches(RelOptRuleCall call) {
            Aggregate aggregate = (Aggregate)call.rel(0);
            TableScan scan = (TableScan)call.rel(1);
            if (!ConvertAggScanToValuesRule.isQualifiedFilePruning(scan) || scan.getRowType().getFieldCount() != aggregate.getRowType().getFieldCount()) {
                return false;
            }
            List fieldNames = scan.getRowType().getFieldNames();
            for (String field : fieldNames) {
                if (this.dirPattern.matcher(field).matches()) continue;
                return false;
            }
            return this.isDistinct((RelNode)scan) || aggregate.getGroupCount() > 0;
        }

        private boolean isDistinct(RelNode relNode) {
            RelMetadataQuery mq = relNode.getCluster().getMetadataQuery();
            return Boolean.TRUE.equals(mq.areRowsUnique(relNode));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMatch(RelOptRuleCall call) {
            TableScan scan = (TableScan)call.rel(1);
            String pruningClassName = ((Object)((Object)this)).getClass().getName();
            logger.debug("Beginning file partition pruning, pruning class: {}", (Object)pruningClassName);
            Stopwatch totalPruningTime = logger.isDebugEnabled() ? Stopwatch.createStarted() : null;
            Object selection = DrillRelOptUtil.getDrillTable((RelNode)scan).getSelection();
            MetadataContext metaContext = null;
            FileSelection fileSelection = null;
            if (selection instanceof FormatSelection) {
                fileSelection = ((FormatSelection)selection).getSelection();
                metaContext = fileSelection.getMetaContext();
            }
            PlannerSettings settings = PrelUtil.getPlannerSettings(call.getPlanner());
            PartitionDescriptor descriptor = this.getPartitionDescriptor(settings, scan);
            List fieldNames = scan.getRowType().getFieldNames();
            List<Object> values = Collections.emptyList();
            ArrayList<Integer> indexes = new ArrayList<Integer>(fieldNames.size());
            for (Object field : fieldNames) {
                int index = descriptor.getPartitionHierarchyIndex((String)field);
                indexes.add(index);
            }
            if (metaContext != null && metaContext.getDirectories() != null) {
                logger.debug("Using Metadata Directories cache");
                values = this.getValues(fileSelection.getSelectionRoot(), metaContext.getDirectories(), indexes);
            }
            if (values.isEmpty()) {
                logger.debug("Not using Metadata Directories cache");
                int batchIndex = 0;
                values = new ArrayList();
                for (List partitions : descriptor) {
                    logger.debug("Evaluating file partition pruning for batch {}", (Object)batchIndex);
                    try {
                        values.addAll(this.getValues(partitions, indexes));
                    }
                    catch (Exception e) {
                        logger.warn("Exception while trying to prune files.", (Throwable)e);
                        if (totalPruningTime != null) {
                            logger.debug("Total pruning elapsed time: {} ms", (Object)totalPruningTime.elapsed(TimeUnit.MILLISECONDS));
                        }
                        return;
                    }
                    ++batchIndex;
                }
                if (values.isEmpty()) {
                    return;
                }
            }
            try {
                ArrayList<RelDataTypeFieldImpl> typeFields = new ArrayList<RelDataTypeFieldImpl>(fieldNames.size());
                RelDataTypeFactory typeFactory = scan.getCluster().getTypeFactory();
                int i = 0;
                for (String field : fieldNames) {
                    RelDataType dataType = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.VARCHAR, 65535), true);
                    typeFields.add(new RelDataTypeFieldImpl(field, i++, dataType));
                }
                RelRecordType t = new RelRecordType(scan.getRowType().getStructKind(), typeFields);
                RelNode newInput = DrillRelFactories.LOGICAL_BUILDER.create(scan.getCluster(), null).values((RelDataType)t, values.toArray()).build();
                RelTraitSet traits = newInput.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL);
                newInput = new DrillValuesRel(newInput.getCluster(), newInput.getRowType(), ((LogicalValues)newInput).getTuples(), traits);
                Aggregate aggregate = (Aggregate)call.rel(0);
                Aggregate newAggregate = aggregate.copy(aggregate.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL), newInput, aggregate.getGroupSet(), (List)aggregate.getGroupSets(), aggregate.getAggCallList());
                call.transformTo((RelNode)newAggregate);
            }
            catch (Exception e) {
                logger.warn("Exception while using the pruned partitions.", (Throwable)e);
            }
            finally {
                if (totalPruningTime != null) {
                    logger.debug("Total pruning elapsed time: {} ms", (Object)totalPruningTime.elapsed(TimeUnit.MILLISECONDS));
                }
            }
        }

        private List<String> getValues(Path selectionRoot, List<Path> directories, List<Integer> indexes) {
            ArrayList<String> values = new ArrayList<String>();
            for (Path dir : directories) {
                List<String> parts = ColumnExplorer.listPartitionValues(dir, selectionRoot, true);
                for (int index : indexes) {
                    if (index < parts.size()) {
                        values.add(parts.get(index));
                        continue;
                    }
                    values.add(null);
                }
            }
            return values;
        }

        private List<String> getValues(List<PartitionLocation> partitions, List<Integer> indexes) {
            ArrayList<String> values = new ArrayList<String>(partitions.size() * indexes.size());
            partitions.forEach(partition -> indexes.forEach(index -> values.add(partition.getPartitionValue((int)index))));
            return values;
        }

        private static boolean isQualifiedFilePruning(TableScan scan) {
            if (PruneScanRule.supportsScan(scan)) {
                Object selection = DrillRelOptUtil.getDrillTable((RelNode)scan).getSelection();
                return selection instanceof FormatSelection;
            }
            if (scan instanceof DrillScanRel) {
                GroupScan groupScan = ((DrillScanRel)scan).getGroupScan();
                return groupScan instanceof FileGroupScan;
            }
            return false;
        }
    }
}

