/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical.partition;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.TableScan;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.ParquetPartitionDescriptor;
import org.apache.drill.exec.planner.PartitionDescriptor;
import org.apache.drill.exec.planner.logical.DrillFilterRel;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.logical.partition.PruneScanRule;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.store.parquet.AbstractParquetGroupScan;

public class ParquetPruneScanRule {
    public static RelOptRule getFilterOnProjectParquet(OptimizerRulesContext optimizerRulesContext) {
        return new PruneScanRule(RelOptHelper.some(DrillFilterRel.class, RelOptHelper.some(DrillProjectRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "PruneScanRule:Filter_On_Project_Parquet", optimizerRulesContext){

            @Override
            public PartitionDescriptor getPartitionDescriptor(PlannerSettings settings, TableScan scanRel) {
                return new ParquetPartitionDescriptor(settings, (DrillScanRel)scanRel);
            }

            public boolean matches(RelOptRuleCall call) {
                DrillScanRel scan = (DrillScanRel)call.rel(2);
                GroupScan groupScan = scan.getGroupScan();
                if (PrelUtil.getPlannerSettings(scan.getCluster().getPlanner()).isHepPartitionPruningEnabled()) {
                    return groupScan instanceof AbstractParquetGroupScan && groupScan.supportsPartitionFilterPushdown() && !scan.partitionFilterPushdown();
                }
                return groupScan instanceof AbstractParquetGroupScan && groupScan.supportsPartitionFilterPushdown();
            }

            public void onMatch(RelOptRuleCall call) {
                DrillFilterRel filterRel = (DrillFilterRel)call.rel(0);
                DrillProjectRel projectRel = (DrillProjectRel)call.rel(1);
                DrillScanRel scanRel = (DrillScanRel)call.rel(2);
                this.doOnMatch(call, filterRel, projectRel, scanRel);
            }
        };
    }

    public static RelOptRule getFilterOnScanParquet(OptimizerRulesContext optimizerRulesContext) {
        return new PruneScanRule(RelOptHelper.some(DrillFilterRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), "PruneScanRule:Filter_On_Scan_Parquet", optimizerRulesContext){

            @Override
            public PartitionDescriptor getPartitionDescriptor(PlannerSettings settings, TableScan scanRel) {
                return new ParquetPartitionDescriptor(settings, (DrillScanRel)scanRel);
            }

            public boolean matches(RelOptRuleCall call) {
                DrillScanRel scan = (DrillScanRel)call.rel(1);
                GroupScan groupScan = scan.getGroupScan();
                if (PrelUtil.getPlannerSettings(scan.getCluster().getPlanner()).isHepPartitionPruningEnabled()) {
                    return groupScan instanceof AbstractParquetGroupScan && groupScan.supportsPartitionFilterPushdown() && !scan.partitionFilterPushdown();
                }
                return groupScan instanceof AbstractParquetGroupScan && groupScan.supportsPartitionFilterPushdown();
            }

            public void onMatch(RelOptRuleCall call) {
                DrillFilterRel filterRel = (DrillFilterRel)call.rel(0);
                DrillScanRel scanRel = (DrillScanRel)call.rel(1);
                this.doOnMatch(call, filterRel, null, scanRel);
            }
        };
    }
}

