/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.map.CaseInsensitiveMap;

public class StoragePlugins
implements Iterable<Map.Entry<String, StoragePluginConfig>> {
    private final Map<String, StoragePluginConfig> storage;

    @JsonCreator
    public StoragePlugins(@JsonProperty(value="storage") Map<String, StoragePluginConfig> storage) {
        CaseInsensitiveMap<StoragePluginConfig> caseInsensitiveStorage = CaseInsensitiveMap.newHashMap();
        Optional.ofNullable(storage).ifPresent(caseInsensitiveStorage::putAll);
        this.storage = caseInsensitiveStorage;
    }

    public StoragePlugins() {
        this(new HashMap<String, StoragePluginConfig>());
    }

    @JsonProperty(value="storage")
    public Map<String, StoragePluginConfig> getStorage() {
        return this.storage;
    }

    public String toString() {
        int maxLen = 10;
        return "StoragePlugins [storage=" + (this.storage != null ? this.toString(this.storage.entrySet(), 10) : null) + "]";
    }

    @Override
    public Iterator<Map.Entry<String, StoragePluginConfig>> iterator() {
        return this.storage.entrySet().iterator();
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StoragePlugins)) {
            return false;
        }
        return this.storage.equals(((StoragePlugins)obj).getStorage());
    }

    public int hashCode() {
        return Objects.hash(this.storage);
    }

    public void put(String name, StoragePluginConfig config) {
        this.storage.put(name, config);
    }

    public void putAll(StoragePlugins plugins) {
        Optional.ofNullable(plugins).ifPresent(p -> this.storage.putAll(p.getStorage()));
    }

    public StoragePluginConfig putIfAbsent(String name, StoragePluginConfig config) {
        return this.storage.putIfAbsent(name, config);
    }

    public StoragePluginConfig getConfig(String pluginName) {
        return this.storage.get(pluginName);
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }
}

