/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexChecker;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.drill.common.logical.data.Join;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillJoinRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.torel.ConversionContext;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

public class RowKeyJoinRel
extends DrillJoinRel
implements DrillRel {
    boolean isSemiJoin;

    public RowKeyJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType) {
        super(cluster, traits, left, right, condition, joinType);
    }

    public RowKeyJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, boolean isSemiJoin) {
        super(cluster, traits, left, right, condition, joinType);
        this.isSemiJoin = isSemiJoin;
    }

    public RowKeyJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, int joinControl) {
        super(cluster, traits, left, right, condition, joinType, joinControl);
    }

    public RowKeyJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, List<Integer> leftKeys, List<Integer> rightKeys) throws InvalidRelException {
        super(cluster, traits, left, right, condition, joinType, leftKeys, rightKeys);
    }

    @Override
    public RowKeyJoinRel copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new RowKeyJoinRel(this.getCluster(), traitSet, left, right, condition, joinType, this.isSemiJoin());
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        return super.implement(implementor);
    }

    @Override
    public boolean isSemiJoin() {
        return this.isSemiJoin;
    }

    public RelDataType deriveRowType() {
        return SqlValidatorUtil.deriveJoinRowType((RelDataType)this.left.getRowType(), (RelDataType)(this.isSemiJoin() ? null : this.right.getRowType()), (JoinRelType)JoinRelType.INNER, (RelDataTypeFactory)this.getCluster().getTypeFactory(), null, ImmutableList.of());
    }

    public static RowKeyJoinRel convert(Join join, ConversionContext context) throws InvalidRelException {
        Pair<RelNode, RelNode> inputs = RowKeyJoinRel.getJoinInputs(join, context);
        RexNode rexCondition = RowKeyJoinRel.getJoinCondition(join, context);
        RowKeyJoinRel joinRel = new RowKeyJoinRel(context.getCluster(), context.getLogicalTraits(), (RelNode)inputs.left, (RelNode)inputs.right, rexCondition, join.getJoinType());
        return joinRel;
    }

    public boolean isValid(Litmus litmus, RelNode.Context context) {
        if (this.getRowType().getFieldCount() != this.getSystemFieldList().size() + this.left.getRowType().getFieldCount() + (this.isSemiJoin() ? 0 : this.right.getRowType().getFieldCount())) {
            return litmus.fail("field count mismatch", new Object[0]);
        }
        if (this.condition != null) {
            if (this.condition.getType().getSqlTypeName() != SqlTypeName.BOOLEAN) {
                return litmus.fail("condition must be boolean: {}", new Object[]{this.condition.getType()});
            }
            RexChecker checker = new RexChecker(this.getCluster().getTypeFactory().builder().addAll((Iterable)this.getSystemFieldList()).addAll((Iterable)this.getLeft().getRowType().getFieldList()).addAll((Iterable)this.getRight().getRowType().getFieldList()).build(), context, litmus);
            this.condition.accept((RexVisitor)checker);
            if (checker.getFailureCount() > 0) {
                return litmus.fail(checker.getFailureCount() + " failures in condition " + this.condition, new Object[0]);
            }
        }
        return litmus.succeed();
    }
}

