/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.MetadataHandler;
import org.apache.drill.exec.metastore.analyze.MetadataHandlerContext;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillRel;

public class MetadataHandlerRel
extends SingleRel
implements DrillRel {
    private final MetadataHandlerContext context;

    public MetadataHandlerRel(RelOptCluster cluster, RelTraitSet traits, RelNode input, MetadataHandlerContext context) {
        super(cluster, traits, input);
        this.context = context;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double dRows = mq.getRowCount(this.getInput());
        double dCpu = dRows * 4.0;
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new MetadataHandlerRel(this.getCluster(), traitSet, (RelNode)MetadataHandlerRel.sole(inputs), this.context);
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        LogicalOperator inputOp = implementor.visitChild(this, 0, this.getInput());
        MetadataHandler rel = new MetadataHandler();
        rel.setInput(inputOp);
        return rel;
    }

    public MetadataHandlerContext getContext() {
        return this.context;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("context: ", (Object)this.context);
    }
}

