/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.IOException;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.exec.physical.base.AbstractWriter;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Writer;
import org.apache.drill.exec.planner.logical.CreateTableEntry;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.StorageStrategy;
import org.apache.drill.exec.store.dfs.FileSystemConfig;
import org.apache.drill.exec.store.dfs.FormatPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="filesystem")
public class FileSystemCreateTableEntry
implements CreateTableEntry {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemCreateTableEntry.class);
    private final FileSystemConfig storageConfig;
    private final FormatPlugin formatPlugin;
    private final String location;
    private final List<String> partitionColumns;
    private final StorageStrategy storageStrategy;

    @JsonCreator
    public FileSystemCreateTableEntry(@JsonProperty(value="storageConfig") FileSystemConfig storageConfig, @JsonProperty(value="formatConfig") FormatPluginConfig formatConfig, @JsonProperty(value="location") String location, @JsonProperty(value="partitionColumn") List<String> partitionColumns, @JsonProperty(value="storageStrategy") StorageStrategy storageStrategy, @JacksonInject StoragePluginRegistry engineRegistry) throws ExecutionSetupException {
        this.storageConfig = storageConfig;
        this.formatPlugin = engineRegistry.resolveFormat(storageConfig, formatConfig, FormatPlugin.class);
        this.location = location;
        this.partitionColumns = partitionColumns;
        this.storageStrategy = storageStrategy;
    }

    public FileSystemCreateTableEntry(FileSystemConfig storageConfig, FormatPlugin formatPlugin, String location, List<String> partitionColumns, StorageStrategy storageStrategy) {
        this.storageConfig = storageConfig;
        this.formatPlugin = formatPlugin;
        this.location = location;
        this.partitionColumns = partitionColumns;
        this.storageStrategy = storageStrategy;
    }

    @JsonProperty(value="storageConfig")
    public FileSystemConfig getStorageConfig() {
        return this.storageConfig;
    }

    @JsonProperty(value="formatConfig")
    public FormatPluginConfig getFormatConfig() {
        return this.formatPlugin.getConfig();
    }

    @Override
    public Writer getWriter(PhysicalOperator child) throws IOException {
        if (!this.formatPlugin.supportsAutoPartitioning() && this.partitionColumns != null && this.partitionColumns.size() != 0) {
            throw UserException.unsupportedError().message(String.format("%s format does not support auto-partitioning.", this.formatPlugin.getName()), new Object[0]).build(logger);
        }
        AbstractWriter writer = this.formatPlugin.getWriter(child, this.location, this.partitionColumns);
        writer.setStorageStrategy(this.storageStrategy);
        return writer;
    }

    @Override
    public List<String> getPartitionColumns() {
        return this.partitionColumns;
    }
}

