/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;

public class FieldsReWriterUtil {
    public static String getFieldNameFromItemStarField(RexCall rexCall, List<String> fieldNames) {
        if (!SqlStdOperatorTable.ITEM.equals((Object)rexCall.getOperator())) {
            return null;
        }
        if (rexCall.getOperands().size() != 2) {
            return null;
        }
        if (!(rexCall.getOperands().get(0) instanceof RexInputRef) || !(rexCall.getOperands().get(1) instanceof RexLiteral)) {
            return null;
        }
        RexInputRef rexInputRef = (RexInputRef)rexCall.getOperands().get(0);
        String parentFieldName = fieldNames.get(rexInputRef.getIndex());
        if (!"**".equals(parentFieldName)) {
            return null;
        }
        RexLiteral rexLiteral = (RexLiteral)rexCall.getOperands().get(1);
        if (SqlTypeName.CHAR.equals((Object)rexLiteral.getType().getSqlTypeName())) {
            return RexLiteral.stringValue((RexNode)rexLiteral);
        }
        return null;
    }

    public static class FieldsReWriter
    extends RexShuttle {
        private final Map<RexNode, Integer> mapper;

        public FieldsReWriter(Map<RexNode, Integer> mapper) {
            this.mapper = mapper;
        }

        public RexNode visitCall(RexCall call) {
            Integer index = this.mapper.get(call);
            if (index != null) {
                return new RexInputRef(index.intValue(), call.getType());
            }
            return super.visitCall(call);
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            Integer index = this.mapper.get(inputRef);
            if (index != null) {
                return new RexInputRef(index.intValue(), inputRef.getType());
            }
            return super.visitInputRef(inputRef);
        }
    }

    public static class DesiredField {
        private final String name;
        private final RelDataType type;
        private final List<RexNode> nodes = new ArrayList<RexNode>();

        public DesiredField(String name, RelDataType type, RexNode node) {
            this.name = name;
            this.type = type;
            this.addNode(node);
        }

        public void addNode(RexNode originalNode) {
            this.nodes.add(originalNode);
        }

        public String getName() {
            return this.name;
        }

        public RelDataType getType() {
            return this.type;
        }

        public List<RexNode> getNodes() {
            return this.nodes;
        }
    }
}

