/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.common.logical.data.Window;
import org.apache.drill.exec.planner.common.DrillWindowRelBase;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class DrillWindowRel
extends DrillWindowRelBase
implements DrillRel {
    public DrillWindowRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, List<RexLiteral> constants, RelDataType rowType, List<Window.Group> groups) {
        super(cluster, traits, child, constants, rowType, groups);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DrillWindowRel(this.getCluster(), traitSet, (RelNode)DrillWindowRel.sole(inputs), this.constants, this.getRowType(), this.groups);
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        LogicalOperator inputOp = implementor.visitChild(this, 0, this.getInput());
        Window.Builder builder = new Window.Builder();
        List fields = this.getRowType().getFieldNames();
        List childFields = this.getInput().getRowType().getFieldNames();
        for (Window.Group window : this.groups) {
            for (RelFieldCollation orderKey : window.orderKeys.getFieldCollations()) {
                builder.addOrdering(new Order.Ordering(orderKey.getDirection(), new FieldReference((CharSequence)fields.get(orderKey.getFieldIndex()))));
            }
            Iterator<Object> iterator = BitSets.toIter((ImmutableBitSet)window.keys).iterator();
            while (iterator.hasNext()) {
                int group = (Integer)iterator.next();
                FieldReference fr = new FieldReference((CharSequence)childFields.get(group), ExpressionPosition.UNKNOWN);
                builder.addWithin(fr, fr);
            }
            int groupCardinality = window.keys.cardinality();
            for (Ord aggCall : Ord.zip((List)window.getAggregateCalls((Window)this))) {
                FieldReference ref = new FieldReference((CharSequence)fields.get(groupCardinality + aggCall.i));
                LogicalExpression expr = this.toDrill((AggregateCall)aggCall.e, childFields);
                builder.addAggregation(ref, expr);
            }
        }
        builder.setInput(inputOp);
        org.apache.drill.common.logical.data.Window frame = (org.apache.drill.common.logical.data.Window)builder.build();
        return frame;
    }

    protected LogicalExpression toDrill(AggregateCall call, List<String> fn) {
        ArrayList<LogicalExpression> args = Lists.newArrayList();
        for (Integer i : call.getArgList()) {
            args.add(new FieldReference(fn.get(i)));
        }
        if (args.isEmpty()) {
            args.add(new ValueExpressions.LongExpression(1L));
        }
        FunctionCall expr = new FunctionCall(call.getAggregation().getName().toLowerCase(), args, ExpressionPosition.UNKNOWN);
        return expr;
    }
}

