/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.drill.exec.dotdrill.View;
import org.apache.drill.exec.ops.ViewExpansionContext;
import org.apache.drill.exec.planner.logical.DrillViewInfoProvider;
import org.apache.drill.exec.planner.sql.conversion.DrillViewExpander;

public class DrillViewTable
implements TranslatableTable,
DrillViewInfoProvider {
    private final View view;
    private final String viewOwner;
    private final ViewExpansionContext viewExpansionContext;

    public DrillViewTable(View view, String viewOwner, ViewExpansionContext viewExpansionContext) {
        this.view = view;
        this.viewOwner = viewOwner;
        this.viewExpansionContext = viewExpansionContext;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return this.view.getRowType(typeFactory);
    }

    public Statistic getStatistic() {
        return Statistics.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        DrillViewExpander viewExpander = this.viewExpansionContext.getViewExpander();
        ViewExpansionContext.ViewExpansionToken token = null;
        try {
            RelNode rel;
            RelDataType rowType = relOptTable.getRowType();
            if (this.viewExpansionContext.isImpersonationEnabled()) {
                token = this.viewExpansionContext.reserveViewExpansionToken(this.viewOwner);
                rel = this.expandViewForImpersonatedUser(viewExpander, this.view.getWorkspaceSchemaPath(), token.getSchemaTree());
            } else {
                rel = viewExpander.expandView((RelDataType)rowType, (String)this.view.getSql(), this.view.getWorkspaceSchemaPath(), Collections.emptyList()).rel;
            }
            if (!this.view.isDynamic() && !this.view.hasStar()) {
                rel = RelOptUtil.createCastRel((RelNode)rel, (RelDataType)rowType, (boolean)true);
            }
            RelNode relNode = rel;
            return relNode;
        }
        finally {
            if (token != null) {
                token.release();
            }
        }
    }

    protected RelNode expandViewForImpersonatedUser(DrillViewExpander context, List<String> workspaceSchemaPath, SchemaPlus tokenSchemaTree) {
        return context.expandView((String)this.view.getSql(), (SchemaPlus)tokenSchemaTree, workspaceSchemaPath).rel;
    }

    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.VIEW;
    }

    @Override
    public String getViewSql() {
        return this.view.getSql();
    }

    public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, SqlNode parent, CalciteConnectionConfig config) {
        return true;
    }

    public boolean isRolledUp(String column) {
        return false;
    }
}

