/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.ArrayList;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.exec.planner.logical.DrillUnionRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.slf4j.Logger;

public class DrillUnionAllRule
extends RelOptRule {
    public static final RelOptRule INSTANCE = new DrillUnionAllRule();
    protected static final Logger tracer = CalciteTrace.getPlannerTracer();

    private DrillUnionAllRule() {
        super(RelOptHelper.any(LogicalUnion.class, (RelTrait)Convention.NONE), DrillRelFactories.LOGICAL_BUILDER, "DrillUnionRule");
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalUnion union = (LogicalUnion)call.rel(0);
        if (!union.all) {
            return;
        }
        RelTraitSet traits = union.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL);
        ArrayList<RelNode> convertedInputs = new ArrayList<RelNode>();
        for (RelNode input : union.getInputs()) {
            RelNode convertedInput = DrillUnionAllRule.convert((RelNode)input, (RelTraitSet)input.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL).simplify());
            convertedInputs.add(convertedInput);
        }
        try {
            call.transformTo((RelNode)new DrillUnionRel(union.getCluster(), traits, convertedInputs, union.all, true));
        }
        catch (InvalidRelException e) {
            tracer.warn(e.toString());
        }
    }
}

