/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.logical.data.Join;
import org.apache.drill.common.logical.data.JoinCondition;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.LogicalSemiJoin;
import org.apache.drill.exec.planner.common.DrillJoinRelBase;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillJoin;
import org.apache.drill.exec.planner.logical.DrillJoinRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class DrillSemiJoinRel
extends DrillJoinRelBase
implements DrillJoin,
DrillRel {
    public DrillSemiJoinRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, List<Integer> leftKeys, List<Integer> rightKeys) {
        super(cluster, traitSet, left, right, condition, JoinRelType.SEMI);
        this.leftKeys = leftKeys;
        this.rightKeys = rightKeys;
    }

    public static DrillSemiJoinRel create(RelNode left, RelNode right, RexNode condition, List<Integer> leftKeys, List<Integer> rightKeys) {
        RelOptCluster cluster = left.getCluster();
        return new DrillSemiJoinRel(cluster, cluster.traitSetOf((RelTrait)DrillRel.DRILL_LOGICAL), left, right, condition, leftKeys, rightKeys);
    }

    public DrillSemiJoinRel copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        Preconditions.checkArgument(joinType == JoinRelType.SEMI);
        JoinInfo joinInfo = JoinInfo.of((RelNode)left, (RelNode)right, (RexNode)condition);
        Preconditions.checkArgument(joinInfo.isEqui());
        return new DrillSemiJoinRel(this.getCluster(), traitSet, left, right, condition, (List<Integer>)joinInfo.leftKeys, (List<Integer>)joinInfo.rightKeys);
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.addAll(this.getInput(0).getRowType().getFieldNames());
        fields.addAll(this.getInput(1).getRowType().getFieldNames());
        Preconditions.checkArgument(DrillJoinRel.isUnique(fields));
        int leftCount = this.left.getRowType().getFieldCount();
        List leftFields = fields.subList(0, leftCount);
        List rightFields = fields.subList(leftCount, leftCount + this.right.getRowType().getFieldCount());
        LogicalOperator leftOp = DrillJoinRel.implementInput(implementor, 0, 0, this.left, this, fields);
        LogicalOperator rightOp = DrillJoinRel.implementInput(implementor, 1, leftCount, this.right, this, fields);
        Join.Builder builder = Join.builder();
        builder.type(this.joinType);
        builder.left(leftOp);
        builder.right(rightOp);
        ArrayList<JoinCondition> conditions = Lists.newArrayList();
        for (Pair pair : Pair.zip((List)this.leftKeys, (List)this.rightKeys)) {
            conditions.add(new JoinCondition("==", new FieldReference((CharSequence)leftFields.get((Integer)pair.left)), new FieldReference((CharSequence)rightFields.get((Integer)pair.right))));
        }
        return new LogicalSemiJoin(leftOp, rightOp, conditions, this.joinType);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return this.computeLogicalJoinCost(planner, mq);
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        RexNode semiJoinSelectivity = RelMdUtil.makeSemiJoinSelectivityRexNode((RelMetadataQuery)mq, (org.apache.calcite.rel.core.Join)this);
        Double selectivity = mq.getSelectivity(this.getLeft(), semiJoinSelectivity);
        return selectivity * mq.getRowCount(this.getLeft());
    }
}

