/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.logical.SelectionBasedTableScan;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.exec.util.Utilities;

public class DrillPushProjectIntoScanRule
extends RelOptRule {
    public static final RelOptRule INSTANCE = new DrillPushProjectIntoScanRule(LogicalProject.class, SelectionBasedTableScan.class, "DrillPushProjectIntoScanRule:none"){

        @Override
        protected boolean skipScanConversion(RelDataType projectRelDataType, TableScan scan) {
            return false;
        }
    };
    public static final RelOptRule DRILL_LOGICAL_INSTANCE = new DrillPushProjectIntoScanRule(LogicalProject.class, DrillScanRel.class, "DrillPushProjectIntoScanRule:logical");
    public static final RelOptRule DRILL_PHYSICAL_INSTANCE = new DrillPushProjectIntoScanRule(ProjectPrel.class, ScanPrel.class, "DrillPushProjectIntoScanRule:physical"){

        @Override
        protected ScanPrel createScan(TableScan scan, DrillRelOptUtil.ProjectPushInfo projectPushInfo) {
            ScanPrel drillScan = (ScanPrel)scan;
            return new ScanPrel(drillScan.getCluster(), drillScan.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL), drillScan.getGroupScan().clone(projectPushInfo.getFields()), projectPushInfo.createNewRowType(drillScan.getCluster().getTypeFactory()), drillScan.getTable());
        }

        @Override
        protected ProjectPrel createProject(Project project, TableScan newScan, List<RexNode> newProjects) {
            return new ProjectPrel(project.getCluster(), project.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL), (RelNode)newScan, newProjects, project.getRowType());
        }
    };

    public DrillPushProjectIntoScanRule(Class<? extends Project> projectClass, Class<? extends TableScan> scanClass, String description) {
        super(RelOptHelper.some(projectClass, RelOptHelper.any(scanClass), new RelOptRuleOperand[0]), description);
    }

    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        TableScan scan = (TableScan)call.rel(1);
        try {
            List<RexNode> newProjects;
            if (scan.getRowType().getFieldList().isEmpty()) {
                return;
            }
            DrillRelOptUtil.ProjectPushInfo projectPushInfo = DrillRelOptUtil.getFieldsInformation(scan.getRowType(), project.getProjects());
            if (!this.canPushProjectIntoScan(scan.getTable(), projectPushInfo) || this.skipScanConversion(projectPushInfo.createNewRowType(project.getCluster().getTypeFactory()), scan)) {
                return;
            }
            TableScan newScan = this.createScan(scan, projectPushInfo);
            Project newProject = this.createProject(project, newScan, newProjects = project.getProjects().stream().map(n -> (RexNode)n.accept((RexVisitor)projectPushInfo.getInputReWriter())).collect(Collectors.toList()));
            if (ProjectRemoveRule.isTrivial((Project)newProject)) {
                call.transformTo((RelNode)newScan);
            } else {
                call.transformTo((RelNode)newProject);
            }
        }
        catch (IOException e) {
            throw new DrillRuntimeException(e);
        }
    }

    protected boolean skipScanConversion(RelDataType projectRelDataType, TableScan scan) {
        return projectRelDataType.equals(scan.getRowType());
    }

    protected Project createProject(Project project, TableScan newScan, List<RexNode> newProjects) {
        return new DrillProjectRel(project.getCluster(), project.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL), (RelNode)newScan, newProjects, project.getRowType());
    }

    protected TableScan createScan(TableScan scan, DrillRelOptUtil.ProjectPushInfo projectPushInfo) {
        return new DrillScanRel(scan.getCluster(), scan.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL), scan.getTable(), projectPushInfo.createNewRowType(scan.getCluster().getTypeFactory()), projectPushInfo.getFields());
    }

    protected boolean canPushProjectIntoScan(RelOptTable table, DrillRelOptUtil.ProjectPushInfo projectPushInfo) throws IOException {
        DrillTable drillTable = Utilities.getDrillTable(table);
        return !Utilities.isStarQuery(projectPushInfo.getFields()) && drillTable.getGroupScan().canPushdownProjects(projectPushInfo.getFields());
    }
}

