/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.logical.DrillLimitRel;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DrillPushLimitToScanRule
extends RelOptRule {
    private static final Logger logger = LoggerFactory.getLogger(DrillPushLimitToScanRule.class);
    public static DrillPushLimitToScanRule LIMIT_ON_SCAN = new DrillPushLimitToScanRule(RelOptHelper.some(DrillLimitRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), "DrillPushLimitToScanRule_LimitOnScan"){

        public boolean matches(RelOptRuleCall call) {
            DrillLimitRel limitRel = (DrillLimitRel)call.rel(0);
            DrillScanRel scanRel = (DrillScanRel)call.rel(1);
            return scanRel.getGroupScan().supportsLimitPushdown() && limitRel.getFetch() != null;
        }

        public void onMatch(RelOptRuleCall call) {
            DrillLimitRel limitRel = (DrillLimitRel)call.rel(0);
            DrillScanRel scanRel = (DrillScanRel)call.rel(1);
            this.doOnMatch(call, limitRel, scanRel, null);
        }
    };
    public static DrillPushLimitToScanRule LIMIT_ON_PROJECT = new DrillPushLimitToScanRule(RelOptHelper.some(DrillLimitRel.class, RelOptHelper.any(DrillProjectRel.class), new RelOptRuleOperand[0]), "DrillPushLimitToScanRule_LimitOnProject"){

        public boolean matches(RelOptRuleCall call) {
            DrillLimitRel limitRel = (DrillLimitRel)call.rel(0);
            DrillProjectRel projectRel = (DrillProjectRel)call.rel(1);
            return !limitRel.isPushDown() && limitRel.getFetch() != null && (!DrillRelOptUtil.isLimit0(limitRel.getFetch()) || !DrillRelOptUtil.isProjectOutputSchemaUnknown(projectRel)) && !DrillRelOptUtil.isProjectOutputRowcountUnknown(projectRel);
        }

        public void onMatch(RelOptRuleCall call) {
            DrillLimitRel limitRel = (DrillLimitRel)call.rel(0);
            DrillProjectRel projectRel = (DrillProjectRel)call.rel(1);
            RelNode child = projectRel.getInput();
            RelNode limitUnderProject = limitRel.copy(limitRel.getTraitSet(), ImmutableList.of(child));
            RelNode newProject = projectRel.copy(projectRel.getTraitSet(), ImmutableList.of(limitUnderProject));
            call.transformTo(newProject);
        }
    };

    private DrillPushLimitToScanRule(RelOptRuleOperand operand, String description) {
        super(operand, DrillRelFactories.LOGICAL_BUILDER, description);
    }

    protected void doOnMatch(RelOptRuleCall call, DrillLimitRel limitRel, DrillScanRel scanRel, DrillProjectRel projectRel) {
        try {
            RelNode newLimit;
            int rowCountRequested = (int)limitRel.estimateRowCount(limitRel.getCluster().getMetadataQuery());
            GroupScan newGroupScan = scanRel.getGroupScan().applyLimit(rowCountRequested);
            if (newGroupScan == null) {
                return;
            }
            DrillScanRel newScanRel = new DrillScanRel(scanRel.getCluster(), scanRel.getTraitSet(), scanRel.getTable(), newGroupScan, scanRel.getRowType(), scanRel.getColumns(), scanRel.partitionFilterPushdown());
            if (projectRel != null) {
                RelNode newProject = projectRel.copy(projectRel.getTraitSet(), ImmutableList.of(newScanRel));
                newLimit = limitRel.copy(limitRel.getTraitSet(), ImmutableList.of(newProject));
            } else {
                newLimit = limitRel.copy(limitRel.getTraitSet(), ImmutableList.of(newScanRel));
            }
            call.transformTo(newLimit);
            logger.debug("Converted to a new DrillScanRel" + newScanRel.getGroupScan());
        }
        catch (Exception e) {
            logger.warn("Exception while using the pruned partitions.", (Throwable)e);
        }
    }
}

