/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Pair;
import org.apache.drill.exec.planner.common.DrillProjectRelBase;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.logical.DrillFilterRel;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class DrillPushFilterPastProjectRule
extends RelOptRule {
    public static final RelOptRule LOGICAL = new DrillPushFilterPastProjectRule(LogicalFilter.class, LogicalProject.class, DrillRelFactories.LOGICAL_BUILDER, "DrillPushFilterPastProjectRule:logical");
    public static final RelOptRule DRILL_INSTANCE = new DrillPushFilterPastProjectRule(DrillFilterRel.class, DrillProjectRelBase.class, DrillRelFactories.LOGICAL_BUILDER, "DrillPushFilterPastProjectRule:drill_logical");
    private static final Collection<String> BANNED_OPERATORS = new ArrayList<String>(2);

    private DrillPushFilterPastProjectRule(Class<? extends Filter> filter, Class<? extends Project> project, RelBuilderFactory relBuilderFactory, String description) {
        super(DrillPushFilterPastProjectRule.operand(filter, (RelOptRuleOperand)DrillPushFilterPastProjectRule.operand(project, (RelOptRuleOperandChildren)DrillPushFilterPastProjectRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, description);
    }

    public void onMatch(RelOptRuleCall call) {
        Filter filterRel = (Filter)call.rel(0);
        Project projRel = (Project)call.rel(1);
        RelBuilder builder = call.builder();
        List predList = RelOptUtil.conjunctions((RexNode)filterRel.getCondition());
        ArrayList<RexNode> qualifiedPredList = Lists.newArrayList();
        ArrayList<RexNode> unqualifiedPredList = Lists.newArrayList();
        for (RexNode pred : predList) {
            if (DrillRelOptUtil.findOperators(pred, projRel.getProjects(), BANNED_OPERATORS) == null) {
                qualifiedPredList.add(pred);
                continue;
            }
            unqualifiedPredList.add(pred);
        }
        RexNode qualifedPred = RexUtil.composeConjunction((RexBuilder)filterRel.getCluster().getRexBuilder(), qualifiedPredList, (boolean)true);
        if (qualifedPred == null) {
            return;
        }
        RexNode newCondition = RelOptUtil.pushPastProject((RexNode)qualifedPred, (Project)projRel);
        RelNode newFilterRel = builder.push(projRel.getInput()).filter(new RexNode[]{newCondition}).build();
        RelNode newProjRel = builder.push(newFilterRel).projectNamed((Iterable)Pair.left((List)projRel.getNamedProjects()), (Iterable)Pair.right((List)projRel.getNamedProjects()), true).build();
        RexNode unqualifiedPred = RexUtil.composeConjunction((RexBuilder)filterRel.getCluster().getRexBuilder(), unqualifiedPredList, (boolean)true);
        if (unqualifiedPred == null) {
            call.transformTo(newProjRel);
        } else {
            RelNode filterNotPushed = builder.push(newProjRel).filter(new RexNode[]{unqualifiedPred}).build();
            call.transformTo(filterNotPushed);
        }
    }

    static {
        BANNED_OPERATORS.add("flatten");
        BANNED_OPERATORS.add("item");
    }
}

