/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.common.logical.data.Project;
import org.apache.drill.exec.planner.common.DrillProjectRelBase;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.torel.ConversionContext;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class DrillProjectRel
extends DrillProjectRelBase
implements DrillRel {
    public DrillProjectRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, List<? extends RexNode> exps, RelDataType rowType) {
        super(DRILL_LOGICAL, cluster, traits, child, exps, rowType);
    }

    public Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> exps, RelDataType rowType) {
        return new DrillProjectRel(this.getCluster(), traitSet, input, exps, rowType);
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        LogicalOperator inputOp = implementor.visitChild(this, 0, this.getInput());
        Project.Builder builder = org.apache.drill.common.logical.data.Project.builder();
        builder.setInput(inputOp);
        for (NamedExpression e : this.getProjectExpressions(implementor.getContext())) {
            builder.addExpr(e);
        }
        return builder.build();
    }

    public static DrillProjectRel convert(org.apache.drill.common.logical.data.Project project, ConversionContext context) throws InvalidRelException {
        RelNode input = context.toRel(project.getInput());
        ArrayList<RelDataTypeFieldImpl> fields = Lists.newArrayList();
        ArrayList<RexNode> exps = Lists.newArrayList();
        for (NamedExpression expr : project.getSelections()) {
            fields.add(new RelDataTypeFieldImpl(expr.getRef().getRootSegment().getPath(), fields.size(), context.getTypeFactory().createSqlType(SqlTypeName.ANY)));
            exps.add(context.toRex(expr.getExpr()));
        }
        return new DrillProjectRel(context.getCluster(), context.getLogicalTraits(), input, exps, (RelDataType)new RelRecordType(fields));
    }

    public static DrillProjectRel create(RelOptCluster cluster, RelTraitSet traits, RelNode child, List<? extends RexNode> exps, RelDataType rowType) {
        return new DrillProjectRel(cluster, traits, child, exps, rowType);
    }
}

