/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.drill.exec.planner.StarColumnHelper;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.logical.DrillLateralJoinRel;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillRel;

public class DrillProjectPushIntoLateralJoinRule
extends RelOptRule {
    public static final DrillProjectPushIntoLateralJoinRule INSTANCE = new DrillProjectPushIntoLateralJoinRule(RelFactories.LOGICAL_BUILDER);

    public DrillProjectPushIntoLateralJoinRule(RelBuilderFactory relFactory) {
        super(DrillProjectPushIntoLateralJoinRule.operand(DrillProjectRel.class, (RelOptRuleOperand)DrillProjectPushIntoLateralJoinRule.operand(DrillLateralJoinRel.class, (RelOptRuleOperandChildren)DrillProjectPushIntoLateralJoinRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relFactory, null);
    }

    public void onMatch(RelOptRuleCall call) {
        DrillProjectRel origProj = (DrillProjectRel)call.rel(0);
        DrillLateralJoinRel corr = (DrillLateralJoinRel)call.rel(1);
        if (StarColumnHelper.containsStarColumn(origProj.getRowType()) || StarColumnHelper.containsStarColumn(corr.getRowType()) || corr.excludeCorrelateColumn) {
            return;
        }
        DrillRelOptUtil.InputRefVisitor collectRefs = new DrillRelOptUtil.InputRefVisitor();
        for (Object exp : origProj.getProjects()) {
            exp.accept((RexVisitor)collectRefs);
        }
        int correlationIndex = corr.getRequiredColumns().nextSetBit(0);
        for (RexInputRef inputRef : collectRefs.getInputRefs()) {
            if (inputRef.getIndex() != correlationIndex) continue;
            return;
        }
        RelNode left = corr.getLeft();
        RelNode right = corr.getRight();
        RelNode convertedLeft = DrillProjectPushIntoLateralJoinRule.convert((RelNode)left, (RelTraitSet)left.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL).simplify());
        RelNode convertedRight = DrillProjectPushIntoLateralJoinRule.convert((RelNode)right, (RelTraitSet)right.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL).simplify());
        RelTraitSet traits = corr.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL);
        boolean trivial = DrillRelOptUtil.isTrivialProject(origProj, true);
        DrillRel relNode = new DrillLateralJoinRel(corr.getCluster(), traits, convertedLeft, convertedRight, true, corr.getCorrelationId(), corr.getRequiredColumns(), corr.getJoinType());
        if (!trivial) {
            Map<Integer, Integer> mapWithoutCorr = this.buildMapWithoutCorrColumn(corr, correlationIndex);
            List<RexNode> outputExprs = DrillRelOptUtil.transformExprs(origProj.getCluster().getRexBuilder(), origProj.getProjects(), mapWithoutCorr);
            relNode = new DrillProjectRel(origProj.getCluster(), left.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL), relNode, outputExprs, origProj.getRowType());
        }
        call.transformTo((RelNode)relNode);
    }

    private Map<Integer, Integer> buildMapWithoutCorrColumn(RelNode corr, int correlationIndex) {
        int index = 0;
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        for (int i = 0; i < corr.getRowType().getFieldList().size(); ++i) {
            if (i == correlationIndex) continue;
            result.put(i, index++);
        }
        return result;
    }
}

