/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionCallFactory;
import org.apache.drill.common.expression.IfExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.NullExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.TypedNullConstant;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.alias.AliasRegistry;
import org.apache.drill.exec.alias.AliasRegistryProvider;
import org.apache.drill.exec.planner.StarColumnHelper;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.work.ExecErrorConstants;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillOptiq {
    public static final String UNSUPPORTED_REX_NODE_ERROR = "Cannot convert RexNode to equivalent Drill expression. ";
    private static final Logger logger = LoggerFactory.getLogger(DrillOptiq.class);

    public static LogicalExpression toDrill(DrillParseContext context, RelNode input, RexNode expr) {
        return DrillOptiq.toDrill(context, Lists.newArrayList(input), expr);
    }

    public static LogicalExpression toDrill(DrillParseContext context, List<RelNode> inputs, RexNode expr) {
        RexToDrill visitor = new RexToDrill(context, inputs);
        return (LogicalExpression)expr.accept((RexVisitor)visitor);
    }

    public static LogicalExpression toDrill(DrillParseContext context, RelDataType type, RexBuilder builder, RexNode expr) {
        RexToDrill visitor = new RexToDrill(context, type, builder);
        return (LogicalExpression)expr.accept((RexVisitor)visitor);
    }

    public static boolean isLiteralNull(RexLiteral literal) {
        return literal.getTypeName().getName().equals("NULL");
    }

    public static class RexToDrill
    extends RexVisitorImpl<LogicalExpression> {
        private final DrillParseContext context;
        private final List<RelDataTypeField> fieldList;
        private final RelDataType rowType;
        private final RexBuilder builder;

        RexToDrill(DrillParseContext context, List<RelNode> inputs) {
            super(true);
            this.context = context;
            this.fieldList = new ArrayList<RelDataTypeField>();
            if (inputs.size() > 0 && inputs.get(0) != null) {
                this.rowType = inputs.get(0).getRowType();
                this.builder = inputs.get(0).getCluster().getRexBuilder();
            } else {
                this.rowType = null;
                this.builder = null;
            }
            for (RelNode input : inputs) {
                if (input == null) continue;
                this.fieldList.addAll(input.getRowType().getFieldList());
            }
        }

        public RexToDrill(DrillParseContext context, RelNode input) {
            this(context, Lists.newArrayList(input));
        }

        public RexToDrill(DrillParseContext context, RelDataType rowType, RexBuilder builder) {
            super(true);
            this.context = context;
            this.rowType = rowType;
            this.builder = builder;
            this.fieldList = rowType.getFieldList();
        }

        protected RelDataType getRowType() {
            return this.rowType;
        }

        protected RexBuilder getRexBuilder() {
            return this.builder;
        }

        public LogicalExpression visitInputRef(RexInputRef inputRef) {
            int index = inputRef.getIndex();
            RelDataTypeField field = this.fieldList.get(index);
            return FieldReference.getWithQuotedRef(field.getName());
        }

        public LogicalExpression visitCall(RexCall call) {
            SqlSyntax syntax = call.getOperator().getSyntax();
            switch (syntax) {
                case BINARY: {
                    logger.debug("Binary");
                    String funcName = call.getOperator().getName().toLowerCase();
                    return this.doFunction(call, funcName);
                }
                case FUNCTION: 
                case FUNCTION_ID: {
                    logger.debug("Function");
                    return this.getDrillFunctionFromOptiqCall(call);
                }
                case POSTFIX: {
                    logger.debug("Postfix");
                    switch (call.getKind()) {
                        case IS_NOT_NULL: 
                        case IS_NOT_TRUE: 
                        case IS_NOT_FALSE: 
                        case IS_NULL: 
                        case IS_TRUE: 
                        case IS_FALSE: 
                        case OTHER: {
                            return FunctionCallFactory.createExpression(call.getOperator().getName().toLowerCase(), ExpressionPosition.UNKNOWN, (LogicalExpression)((RexNode)call.getOperands().get(0)).accept((RexVisitor)this));
                        }
                    }
                    throw this.notImplementedException(syntax, call);
                }
                case PREFIX: {
                    LogicalExpression arg = (LogicalExpression)((RexNode)call.getOperands().get(0)).accept((RexVisitor)this);
                    switch (call.getKind()) {
                        case NOT: {
                            return FunctionCallFactory.createExpression(call.getOperator().getName().toLowerCase(), ExpressionPosition.UNKNOWN, arg);
                        }
                        case MINUS_PREFIX: {
                            ArrayList<LogicalExpression> operands = new ArrayList<LogicalExpression>();
                            operands.add((LogicalExpression)((RexNode)call.getOperands().get(0)).accept((RexVisitor)this));
                            return FunctionCallFactory.createExpression("u-", operands);
                        }
                    }
                    throw this.notImplementedException(syntax, call);
                }
                case SPECIAL: {
                    switch (call.getKind()) {
                        case CAST: {
                            return this.getDrillCastFunctionFromOptiq(call);
                        }
                        case ROW: {
                            List fieldList = call.getType().getFieldList();
                            List oldOperands = call.getOperands();
                            ArrayList<LogicalExpression> newOperands = new ArrayList<LogicalExpression>();
                            for (int i = 0; i < oldOperands.size(); ++i) {
                                RexLiteral nameOperand = this.getRexBuilder().makeLiteral(((RelDataTypeField)fieldList.get(i)).getName());
                                RexNode valueOperand = (RexNode)call.operands.get(i);
                                newOperands.add((LogicalExpression)nameOperand.accept((RexVisitor)this));
                                newOperands.add((LogicalExpression)valueOperand.accept((RexVisitor)this));
                            }
                            return FunctionCallFactory.createExpression(call.op.getName().toLowerCase(), newOperands);
                        }
                        case LIKE: 
                        case SIMILAR: {
                            return this.getDrillFunctionFromOptiqCall(call);
                        }
                        case CASE: {
                            List<LogicalExpression> caseArgs = new ArrayList();
                            for (RexNode r : call.getOperands()) {
                                caseArgs.add((LogicalExpression)r.accept((RexVisitor)this));
                            }
                            caseArgs = Lists.reverse(caseArgs);
                            assert (caseArgs.size() % 2 == 1);
                            LogicalExpression elseExpression = (LogicalExpression)caseArgs.get(0);
                            for (int i = 1; i < caseArgs.size(); i += 2) {
                                elseExpression = IfExpression.newBuilder().setElse(elseExpression).setIfCondition(new IfExpression.IfCondition((LogicalExpression)caseArgs.get(i + 1), (LogicalExpression)caseArgs.get(i))).build();
                            }
                            return elseExpression;
                        }
                    }
                    if (call.getOperator() == SqlStdOperatorTable.ITEM) {
                        return this.handleItemOperator(call, syntax);
                    }
                    if (call.getOperator() == SqlStdOperatorTable.DATETIME_PLUS) {
                        return this.doFunction(call, "+");
                    }
                    if (call.getOperator() == SqlStdOperatorTable.MINUS_DATE) {
                        return this.doFunction(call, "-");
                    }
                }
                case INTERNAL: {
                    if (call.getOperator() != SqlStdOperatorTable.SEARCH) break;
                    return (LogicalExpression)RexUtil.expandSearch((RexBuilder)this.getRexBuilder(), null, (RexNode)call).accept((RexVisitor)this);
                }
            }
            throw this.notImplementedException(syntax, call);
        }

        private SchemaPath handleItemOperator(RexCall call, SqlSyntax syntax) {
            RexLiteral literal;
            SchemaPath left = (SchemaPath)((RexNode)call.getOperands().get(0)).accept((RexVisitor)this);
            RelDataType dataType = ((RexNode)call.getOperands().get(0)).getType();
            boolean isMap = dataType.getSqlTypeName() == SqlTypeName.MAP;
            String rootSegName = left.getRootSegment().getPath();
            if (StarColumnHelper.isStarColumn(rootSegName)) {
                rootSegName = rootSegName.substring(0, rootSegName.indexOf("**"));
                RexLiteral literal2 = (RexLiteral)call.getOperands().get(1);
                return SchemaPath.getSimplePath(rootSegName + literal2.getValue2().toString());
            }
            RexNode operand = (RexNode)call.getOperands().get(1);
            if (operand instanceof RexLiteral) {
                literal = (RexLiteral)operand;
            } else if (isMap && operand.getKind() == SqlKind.CAST) {
                SqlTypeName keyType;
                SqlTypeName castType = operand.getType().getSqlTypeName();
                Preconditions.checkArgument(castType == (keyType = dataType.getKeyType().getSqlTypeName()), String.format("Wrong type CAST: expected '%s' but found '%s'", keyType.getName(), castType.getName()));
                literal = (RexLiteral)((RexCall)operand).operands.get(0);
            } else {
                throw this.notImplementedException(syntax, call);
            }
            switch (literal.getTypeName()) {
                case DECIMAL: 
                case INTEGER: {
                    if (isMap) {
                        return this.handleMapNumericKey(literal, operand, dataType, left);
                    }
                    return left.getChild(((BigDecimal)literal.getValue()).intValue());
                }
                case CHAR: 
                case TIMESTAMP: 
                case TIME: 
                case DATE: {
                    if (isMap) {
                        return this.handleMapCharKey(literal, operand, dataType, left);
                    }
                    return left.getChild(literal.getValue2().toString());
                }
                case BOOLEAN: {
                    if (!isMap) break;
                    BasicSqlType sqlType = (BasicSqlType)operand.getType();
                    TypeProtos.DataMode mode = sqlType.isNullable() ? TypeProtos.DataMode.OPTIONAL : TypeProtos.DataMode.REQUIRED;
                    return left.getChild(literal.getValue().toString(), (Object)literal.getValue(), Types.withMode(TypeProtos.MinorType.BIT, mode));
                }
            }
            throw this.notImplementedException(syntax, call);
        }

        private DrillRuntimeException notImplementedException(SqlSyntax syntax, RexCall call) {
            String message = String.format("Syntax '%s(%s)' is not implemented.", syntax.toString(), call.toString());
            throw new DrillRuntimeException(message);
        }

        private SchemaPath handleMapNumericKey(RexLiteral literal, RexNode operand, RelDataType mapType, SchemaPath parentPath) {
            Number originalValue;
            TypeProtos.MajorType type;
            BigDecimal literalValue = (BigDecimal)literal.getValue();
            RelDataType sqlType = operand.getType();
            TypeProtos.DataMode mode = sqlType.isNullable() ? TypeProtos.DataMode.OPTIONAL : TypeProtos.DataMode.REQUIRED;
            boolean arraySegment = false;
            switch (mapType.getKeyType().getSqlTypeName()) {
                case DOUBLE: {
                    type = Types.withMode(TypeProtos.MinorType.FLOAT8, mode);
                    originalValue = literalValue.doubleValue();
                    break;
                }
                case FLOAT: {
                    type = Types.withMode(TypeProtos.MinorType.FLOAT4, mode);
                    originalValue = Float.valueOf(literalValue.floatValue());
                    break;
                }
                case DECIMAL: {
                    type = Types.withPrecisionAndScale(TypeProtos.MinorType.VARDECIMAL, mode, literalValue.precision(), literalValue.scale());
                    originalValue = literalValue;
                    break;
                }
                case BIGINT: {
                    type = Types.withMode(TypeProtos.MinorType.BIGINT, mode);
                    originalValue = literalValue.longValue();
                    break;
                }
                case INTEGER: {
                    type = Types.withMode(TypeProtos.MinorType.INT, mode);
                    originalValue = literalValue.intValue();
                    arraySegment = true;
                    break;
                }
                case SMALLINT: {
                    type = Types.withMode(TypeProtos.MinorType.SMALLINT, mode);
                    originalValue = literalValue.shortValue();
                    arraySegment = true;
                    break;
                }
                case TINYINT: {
                    type = Types.withMode(TypeProtos.MinorType.TINYINT, mode);
                    originalValue = literalValue.byteValue();
                    arraySegment = true;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Shouldn't reach there. Type: " + mapType.getKeyType().getSqlTypeName()));
                }
            }
            if (arraySegment) {
                return parentPath.getChild((Integer)originalValue, (Object)originalValue, type);
            }
            return parentPath.getChild(originalValue.toString(), (Object)originalValue, type);
        }

        private SchemaPath handleMapCharKey(RexLiteral literal, RexNode operand, RelDataType mapType, SchemaPath parentPath) {
            TypeProtos.MajorType type;
            TypeProtos.DataMode mode = operand.getType().isNullable() ? TypeProtos.DataMode.OPTIONAL : TypeProtos.DataMode.REQUIRED;
            Object value = literal.getValue2();
            switch (mapType.getKeyType().getSqlTypeName()) {
                case TIMESTAMP: {
                    type = Types.withMode(TypeProtos.MinorType.TIMESTAMP, mode);
                    value = literal.getValueAs(TimestampString.class);
                    break;
                }
                case DATE: {
                    type = Types.withMode(TypeProtos.MinorType.DATE, mode);
                    value = literal.getValueAs(DateString.class);
                    break;
                }
                case TIME: {
                    type = Types.withMode(TypeProtos.MinorType.TIME, mode);
                    value = literal.getValueAs(TimeString.class);
                    break;
                }
                case INTERVAL_DAY: {
                    type = Types.withMode(TypeProtos.MinorType.INTERVALDAY, mode);
                    break;
                }
                case INTERVAL_YEAR: {
                    type = Types.withMode(TypeProtos.MinorType.INTERVALYEAR, mode);
                    break;
                }
                case INTERVAL_MONTH: {
                    type = Types.withMode(TypeProtos.MinorType.INTERVAL, mode);
                    break;
                }
                default: {
                    type = Types.withMode(TypeProtos.MinorType.VARCHAR, mode);
                }
            }
            return parentPath.getChild(value.toString(), value, type);
        }

        private LogicalExpression doFunction(RexCall call, String funcName) {
            List<LogicalExpression> args = new ArrayList<LogicalExpression>();
            for (RexNode r : call.getOperands()) {
                args.add((LogicalExpression)r.accept((RexVisitor)this));
            }
            if (FunctionCallFactory.isBooleanOperator(funcName)) {
                LogicalExpression func = FunctionCallFactory.createBooleanOperator(funcName, args);
                return func;
            }
            args = Lists.reverse(args);
            LogicalExpression lastArg = args.get(0);
            for (int i = 1; i < args.size(); ++i) {
                lastArg = FunctionCallFactory.createExpression(funcName, Lists.newArrayList(args.get(i), lastArg));
            }
            return lastArg;
        }

        private LogicalExpression doUnknown(RexNode o) {
            throw UserException.planError().message("Cannot convert RexNode to equivalent Drill expression. RexNode Class: %s, RexNode Digest: %s", o.getClass().getName(), o.toString()).build(logger);
        }

        public LogicalExpression visitLocalRef(RexLocalRef localRef) {
            return this.doUnknown((RexNode)localRef);
        }

        public LogicalExpression visitOver(RexOver over) {
            return this.doUnknown((RexNode)over);
        }

        public LogicalExpression visitCorrelVariable(RexCorrelVariable correlVariable) {
            return this.doUnknown((RexNode)correlVariable);
        }

        public LogicalExpression visitDynamicParam(RexDynamicParam dynamicParam) {
            return this.doUnknown((RexNode)dynamicParam);
        }

        public LogicalExpression visitRangeRef(RexRangeRef rangeRef) {
            return this.doUnknown((RexNode)rangeRef);
        }

        public LogicalExpression visitFieldAccess(RexFieldAccess fieldAccess) {
            SchemaPath logicalRef = (SchemaPath)fieldAccess.getReferenceExpr().accept((RexVisitor)this);
            return logicalRef.getChild(fieldAccess.getField().getName());
        }

        private LogicalExpression getDrillCastFunctionFromOptiq(RexCall call) {
            TypeProtos.MajorType castType;
            LogicalExpression arg = (LogicalExpression)((RexNode)call.getOperands().get(0)).accept((RexVisitor)this);
            switch (call.getType().getSqlTypeName()) {
                case CHAR: 
                case VARCHAR: {
                    castType = Types.required(TypeProtos.MinorType.VARCHAR).toBuilder().setPrecision(call.getType().getPrecision()).build();
                    break;
                }
                case INTEGER: {
                    castType = Types.required(TypeProtos.MinorType.INT);
                    break;
                }
                case FLOAT: {
                    castType = Types.required(TypeProtos.MinorType.FLOAT4);
                    break;
                }
                case DOUBLE: {
                    castType = Types.required(TypeProtos.MinorType.FLOAT8);
                    break;
                }
                case DECIMAL: {
                    if (!this.context.getPlannerSettings().getOptions().getOption(PlannerSettings.ENABLE_DECIMAL_DATA_TYPE)) {
                        throw UserException.unsupportedError().message(ExecErrorConstants.DECIMAL_DISABLE_ERR_MSG, new Object[0]).build(logger);
                    }
                    int precision = call.getType().getPrecision();
                    int scale = call.getType().getScale();
                    castType = TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.VARDECIMAL).setPrecision(precision).setScale(scale).build();
                    break;
                }
                case INTERVAL_YEAR: 
                case INTERVAL_MONTH: 
                case INTERVAL_YEAR_MONTH: {
                    castType = Types.required(TypeProtos.MinorType.INTERVALYEAR);
                    break;
                }
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    castType = Types.required(TypeProtos.MinorType.INTERVALDAY);
                    break;
                }
                case BOOLEAN: {
                    castType = Types.required(TypeProtos.MinorType.BIT);
                    break;
                }
                case BINARY: {
                    castType = Types.required(TypeProtos.MinorType.VARBINARY);
                    break;
                }
                case ANY: {
                    return arg;
                }
                default: {
                    castType = Types.required(TypeProtos.MinorType.valueOf(call.getType().getSqlTypeName().getName()));
                }
            }
            return FunctionCallFactory.createCast(castType, ExpressionPosition.UNKNOWN, arg);
        }

        private LogicalExpression getDrillFunctionFromOptiqCall(RexCall call) {
            String functionName;
            ArrayList<LogicalExpression> args = new ArrayList<LogicalExpression>();
            for (RexNode n : call.getOperands()) {
                args.add((LogicalExpression)n.accept((RexVisitor)this));
            }
            int argsSize = args.size();
            switch (functionName = call.getOperator().getName().toLowerCase()) {
                case "extract": {
                    assert (args.get(0) instanceof ValueExpressions.QuotedString);
                    String timeUnitStr = (String)((ValueExpressions.QuotedString)args.get((int)0)).value;
                    TimeUnit timeUnit = timeUnitStr.contentEquals("DAYOFWEEK") ? TimeUnit.DOW : (timeUnitStr.contentEquals("DAYOFYEAR") ? TimeUnit.DOY : TimeUnit.valueOf(timeUnitStr));
                    switch (timeUnit) {
                        case YEAR: 
                        case QUARTER: 
                        case MONTH: 
                        case WEEK: 
                        case DAY: 
                        case DOW: 
                        case DOY: 
                        case EPOCH: 
                        case HOUR: 
                        case MINUTE: 
                        case SECOND: {
                            String functionPostfix = StringUtils.capitalize((String)timeUnitStr.toLowerCase());
                            functionName = functionName + functionPostfix;
                            return FunctionCallFactory.createExpression(functionName, args.subList(1, 2));
                        }
                    }
                    throw new UnsupportedOperationException("extract function supports the following time units: YEAR, QUARTER, MONTH, WEEK, DAY, DAYOFWEEK, DAYOFYEAR, EPOCH, HOUR, MINUTE, SECOND");
                }
                case "timestampdiff": {
                    Preconditions.checkArgument(args.get(0) instanceof ValueExpressions.QuotedString, "The first argument of TIMESTAMPDIFF function should be QuotedString");
                    String timeUnitStr = (String)((ValueExpressions.QuotedString)args.get((int)0)).value;
                    TimeUnit timeUnit = TimeUnit.valueOf(timeUnitStr);
                    switch (timeUnit) {
                        case YEAR: 
                        case QUARTER: 
                        case MONTH: 
                        case WEEK: 
                        case DAY: 
                        case HOUR: 
                        case MINUTE: 
                        case SECOND: 
                        case MILLISECOND: 
                        case MICROSECOND: 
                        case NANOSECOND: {
                            String functionPostfix = StringUtils.capitalize((String)timeUnitStr.toLowerCase());
                            functionName = functionName + functionPostfix;
                            return FunctionCallFactory.createExpression(functionName, args.subList(1, 3));
                        }
                    }
                    throw new UnsupportedOperationException("TIMESTAMPDIFF function supports the following time units: YEAR, MONTH, DAY, HOUR, MINUTE, SECOND, QUARTER, WEEK, MICROSECOND, NANOSECOND");
                }
                case "trim": {
                    String trimFunc;
                    ArrayList<LogicalExpression> trimArgs = new ArrayList<LogicalExpression>();
                    assert (args.get(0) instanceof ValueExpressions.QuotedString);
                    switch (((String)((ValueExpressions.QuotedString)args.get((int)0)).value).toUpperCase()) {
                        case "LEADING": {
                            trimFunc = "ltrim";
                            break;
                        }
                        case "TRAILING": {
                            trimFunc = "rtrim";
                            break;
                        }
                        case "BOTH": {
                            trimFunc = "btrim";
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Invalid argument for TRIM function. Expected one of the following: LEADING, TRAILING, BOTH");
                        }
                    }
                    trimArgs.add((LogicalExpression)args.get(2));
                    trimArgs.add((LogicalExpression)args.get(1));
                    return FunctionCallFactory.createExpression(trimFunc, trimArgs);
                }
                case "date_part": {
                    assert (argsSize == 2);
                    assert (args.get(0) instanceof ValueExpressions.QuotedString);
                    ValueExpressions.QuotedString extractString = (ValueExpressions.QuotedString)args.get(0);
                    String functionPostfix = StringUtils.capitalize((String)((String)extractString.value).toLowerCase());
                    return FunctionCallFactory.createExpression("extract" + functionPostfix, args.subList(1, 2));
                }
                case "concat": {
                    if (argsSize == 1) {
                        LinkedList<LogicalExpression> concatArgs = new LinkedList<LogicalExpression>(args);
                        concatArgs.add(ValueExpressions.QuotedString.EMPTY_STRING);
                        return FunctionCallFactory.createExpression(functionName, concatArgs);
                    }
                    if (argsSize <= 2) break;
                    ArrayList<LogicalExpression> concatArgs = new ArrayList<LogicalExpression>();
                    concatArgs.add((LogicalExpression)args.get(0));
                    concatArgs.add((LogicalExpression)args.get(1));
                    LogicalExpression first = FunctionCallFactory.createExpression(functionName, concatArgs);
                    for (int i = 2; i < argsSize; ++i) {
                        concatArgs = new ArrayList();
                        concatArgs.add(first);
                        concatArgs.add((LogicalExpression)args.get(i));
                        first = FunctionCallFactory.createExpression(functionName, concatArgs);
                    }
                    return first;
                }
                case "length": {
                    if (argsSize != 2) break;
                    assert (args.get(1) instanceof ValueExpressions.QuotedString);
                    String encodingType = (String)((ValueExpressions.QuotedString)args.get((int)1)).value;
                    functionName = functionName + StringUtils.capitalize((String)encodingType.toLowerCase());
                    return FunctionCallFactory.createExpression(functionName, args.subList(0, 1));
                }
                case "convert_from": 
                case "convert_to": {
                    if (!(args.get(1) instanceof ValueExpressions.QuotedString)) break;
                    return FunctionCallFactory.createConvert(functionName, (String)((ValueExpressions.QuotedString)args.get((int)1)).value, (LogicalExpression)args.get(0), ExpressionPosition.UNKNOWN);
                }
                case "date_trunc": {
                    return this.handleDateTruncFunction(args);
                }
                case "httprequest": 
                case "http_request": {
                    String completeRawPluginName = (String)((ValueExpressions.QuotedString)args.get((int)0)).value;
                    String username = this.context.getPlannerSettings().getQueryUser();
                    AliasRegistryProvider aliasRegistryProvider = this.context.getPlannerSettings().getAliasRegistryProvider();
                    AliasRegistry storageAliasRegistry = aliasRegistryProvider.getStorageAliasesRegistry();
                    AliasRegistry tableAliasRegistry = aliasRegistryProvider.getTableAliasesRegistry();
                    SchemaPath schemaPath = SchemaPath.parseFromString(completeRawPluginName);
                    String rawPluginName = SchemaPath.getSimplePath(schemaPath.rootName()).toExpr();
                    String rawEndpoint = SchemaPath.getSimplePath(schemaPath.getLastSegment().getNameSegment().getPath()).toExpr();
                    String actualPluginName = storageAliasRegistry.getUserAliases(username).get(rawPluginName);
                    if (StringUtils.isEmpty((CharSequence)actualPluginName)) {
                        actualPluginName = rawPluginName;
                    }
                    actualPluginName = SchemaPath.parseFromString(actualPluginName).getRootSegmentPath();
                    String actualEndpointName = tableAliasRegistry.getUserAliases(username).get(rawEndpoint);
                    if (StringUtils.isEmpty((CharSequence)actualEndpointName)) {
                        actualEndpointName = rawEndpoint;
                    }
                    actualEndpointName = SchemaPath.parseFromString(actualEndpointName).getRootSegmentPath();
                    String finalPluginName = SchemaPath.getCompoundPath(actualPluginName, actualEndpointName).getAsUnescapedPath();
                    ValueExpressions.QuotedString q = new ValueExpressions.QuotedString(finalPluginName, finalPluginName.length(), ExpressionPosition.UNKNOWN);
                    ArrayList<LogicalExpression> requestArgs = new ArrayList<LogicalExpression>();
                    requestArgs.add(q);
                    requestArgs.addAll(args.subList(1, args.size()));
                    return FunctionCallFactory.createExpression(functionName, requestArgs);
                }
            }
            return FunctionCallFactory.createExpression(functionName, args);
        }

        private LogicalExpression handleDateTruncFunction(List<LogicalExpression> args) {
            assert (args.get(0) instanceof ValueExpressions.QuotedString);
            String timeUnitStr = ((String)((ValueExpressions.QuotedString)args.get((int)0)).value).toUpperCase();
            TimeUnit timeUnit = TimeUnit.valueOf(timeUnitStr);
            switch (timeUnit) {
                case YEAR: 
                case QUARTER: 
                case MONTH: 
                case WEEK: 
                case DAY: 
                case HOUR: 
                case MINUTE: 
                case SECOND: 
                case DECADE: 
                case CENTURY: 
                case MILLENNIUM: {
                    String functionPostfix = StringUtils.capitalize((String)timeUnitStr.toLowerCase());
                    return FunctionCallFactory.createExpression("date_trunc_" + functionPostfix, args.subList(1, 2));
                }
            }
            throw new UnsupportedOperationException("date_trunc function supports the following time units: YEAR, MONTH, DAY, HOUR, MINUTE, SECOND, WEEK, QUARTER, DECADE, CENTURY, MILLENNIUM");
        }

        public LogicalExpression visitLiteral(RexLiteral literal) {
            switch (literal.getType().getSqlTypeName()) {
                case BIGINT: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return this.createNullExpr(TypeProtos.MinorType.BIGINT);
                    }
                    long l = ((BigDecimal)literal.getValue()).setScale(0, 4).longValue();
                    return ValueExpressions.getBigInt(l);
                }
                case BOOLEAN: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return this.createNullExpr(TypeProtos.MinorType.BIT);
                    }
                    return ValueExpressions.getBit((Boolean)literal.getValue());
                }
                case CHAR: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return this.createStringNullExpr(literal.getType().getPrecision());
                    }
                    return ValueExpressions.getChar(((NlsString)literal.getValue()).getValue(), literal.getType().getPrecision());
                }
                case DOUBLE: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return this.createNullExpr(TypeProtos.MinorType.FLOAT8);
                    }
                    double d = ((BigDecimal)literal.getValue()).doubleValue();
                    return ValueExpressions.getFloat8(d);
                }
                case FLOAT: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return this.createNullExpr(TypeProtos.MinorType.FLOAT4);
                    }
                    float f = ((BigDecimal)literal.getValue()).floatValue();
                    return ValueExpressions.getFloat4(f);
                }
                case INTEGER: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return this.createNullExpr(TypeProtos.MinorType.INT);
                    }
                    int a = ((BigDecimal)literal.getValue()).setScale(0, 4).intValue();
                    return ValueExpressions.getInt(a);
                }
                case DECIMAL: {
                    if (this.context.getPlannerSettings().getOptions().getBoolean(PlannerSettings.ENABLE_DECIMAL_DATA_TYPE.getOptionName())) {
                        if (DrillOptiq.isLiteralNull(literal)) {
                            return new TypedNullConstant(Types.withPrecisionAndScale(TypeProtos.MinorType.VARDECIMAL, TypeProtos.DataMode.OPTIONAL, literal.getType().getPrecision(), literal.getType().getScale()));
                        }
                        return ValueExpressions.getVarDecimal((BigDecimal)literal.getValue(), literal.getType().getPrecision(), literal.getType().getScale());
                    }
                    double dbl = ((BigDecimal)literal.getValue()).doubleValue();
                    logger.warn("Converting exact decimal into approximate decimal.\nPlease enable decimal data types using `planner.enable_decimal_data_type`.");
                    return ValueExpressions.getFloat8(dbl);
                }
                case VARCHAR: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return this.createStringNullExpr(literal.getType().getPrecision());
                    }
                    return ValueExpressions.getChar(((NlsString)literal.getValue()).getValue(), literal.getType().getPrecision());
                }
                case SYMBOL: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return this.createStringNullExpr(literal.getType().getPrecision());
                    }
                    return ValueExpressions.getChar(literal.getValue().toString(), literal.getType().getPrecision());
                }
                case DATE: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return this.createNullExpr(TypeProtos.MinorType.DATE);
                    }
                    return ValueExpressions.getDate((GregorianCalendar)literal.getValue());
                }
                case TIME: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return this.createNullExpr(TypeProtos.MinorType.TIME);
                    }
                    return ValueExpressions.getTime((GregorianCalendar)literal.getValue());
                }
                case TIMESTAMP: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return this.createNullExpr(TypeProtos.MinorType.TIMESTAMP);
                    }
                    return ValueExpressions.getTimeStamp((GregorianCalendar)literal.getValue());
                }
                case INTERVAL_YEAR: 
                case INTERVAL_MONTH: 
                case INTERVAL_YEAR_MONTH: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return this.createNullExpr(TypeProtos.MinorType.INTERVALYEAR);
                    }
                    return ValueExpressions.getIntervalYear(((BigDecimal)literal.getValue()).intValue());
                }
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    if (DrillOptiq.isLiteralNull(literal)) {
                        return this.createNullExpr(TypeProtos.MinorType.INTERVALDAY);
                    }
                    return ValueExpressions.getIntervalDay(((BigDecimal)literal.getValue()).longValue());
                }
                case NULL: {
                    return NullExpression.INSTANCE;
                }
                case ANY: {
                    if (!DrillOptiq.isLiteralNull(literal)) break;
                    return NullExpression.INSTANCE;
                }
            }
            throw new UnsupportedOperationException(String.format("Unable to convert the value of %s and type %s to a Drill constant expression.", literal, literal.getType().getSqlTypeName()));
        }

        private TypedNullConstant createNullExpr(TypeProtos.MinorType type) {
            return new TypedNullConstant(Types.optional(type));
        }

        private TypedNullConstant createStringNullExpr(int precision) {
            return new TypedNullConstant(Types.withPrecision(TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL, precision));
        }
    }
}

