/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Permutation;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.planner.DrillRelBuilder;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.exec.planner.physical.PrelFactories;

public class DrillMergeProjectRule
extends RelOptRule {
    private final FunctionImplementationRegistry functionRegistry;
    private final boolean force;

    public static DrillMergeProjectRule getInstance(boolean force, RelFactories.ProjectFactory pFactory, FunctionImplementationRegistry functionRegistry) {
        return new DrillMergeProjectRule(force, pFactory, functionRegistry);
    }

    private DrillMergeProjectRule(boolean force, RelFactories.ProjectFactory pFactory, FunctionImplementationRegistry functionRegistry) {
        super(DrillMergeProjectRule.operand(LogicalProject.class, (RelOptRuleOperand)DrillMergeProjectRule.operand(LogicalProject.class, (RelOptRuleOperandChildren)DrillMergeProjectRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), DrillRelBuilder.proto(pFactory), "DrillMergeProjectRule" + (force ? ":force_mode" : ""));
        this.force = force;
        this.functionRegistry = functionRegistry;
    }

    public boolean matches(RelOptRuleCall call) {
        Project topProject = (Project)call.rel(0);
        Project bottomProject = (Project)call.rel(1);
        return !this.checkComplexOutput(topProject) && !this.checkComplexOutput(bottomProject);
    }

    private boolean checkComplexOutput(Project project) {
        for (RexNode expr : project.getProjects()) {
            if (!(expr instanceof RexCall) || !this.functionRegistry.isFunctionComplexOutput(((RexCall)expr).getOperator().getName())) continue;
            return true;
        }
        return false;
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode input;
        Project topProject = (Project)call.rel(0);
        Project bottomProject = (Project)call.rel(1);
        RelBuilder relBuilder = call.builder();
        Permutation topPermutation = topProject.getPermutation();
        if (topPermutation != null) {
            if (topPermutation.isIdentity()) {
                return;
            }
            Permutation bottomPermutation = bottomProject.getPermutation();
            if (bottomPermutation != null) {
                if (bottomPermutation.isIdentity()) {
                    return;
                }
                Permutation product = topPermutation.product(bottomPermutation);
                relBuilder.push(bottomProject.getInput());
                relBuilder.project((Iterable)relBuilder.fields((Mappings.TargetMapping)product), (Iterable)topProject.getRowType().getFieldNames());
                call.transformTo(relBuilder.build());
                return;
            }
        }
        if (!this.force && RexUtil.isIdentity((List)topProject.getProjects(), (RelDataType)topProject.getInput().getRowType())) {
            return;
        }
        List pushedProjects = RelOptUtil.pushPastProject((List)topProject.getProjects(), (Project)bottomProject);
        List<RexNode> newProjects = DrillMergeProjectRule.simplifyCast(pushedProjects);
        if (RexUtil.isIdentity(newProjects, (RelDataType)(input = bottomProject.getInput()).getRowType()) && (this.force || input.getRowType().getFieldNames().equals(topProject.getRowType().getFieldNames()))) {
            call.transformTo(input);
            return;
        }
        relBuilder.push(bottomProject.getInput());
        relBuilder.project(newProjects, (Iterable)topProject.getRowType().getFieldNames());
        call.transformTo(relBuilder.build());
    }

    public static List<RexNode> simplifyCast(List<RexNode> projectExprs) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        for (RexNode rex : projectExprs) {
            if (rex.getKind() == SqlKind.CAST) {
                RexNode operand = (RexNode)((RexCall)rex).getOperands().get(0);
                while (operand.getKind() == SqlKind.CAST && operand.getType().equals(rex.getType())) {
                    rex = operand;
                    operand = (RexNode)((RexCall)rex).getOperands().get(0);
                }
            }
            list.add(rex);
        }
        return list;
    }

    public static Project replace(Project topProject, Project bottomProject) {
        List newProjects = RelOptUtil.pushPastProject((List)topProject.getProjects(), (Project)bottomProject);
        if (topProject instanceof DrillProjectRel) {
            RelNode newProjectRel = DrillRelFactories.DRILL_LOGICAL_PROJECT_FACTORY.createProject(bottomProject.getInput(), Collections.emptyList(), newProjects, topProject.getRowType().getFieldNames());
            return (Project)newProjectRel;
        }
        RelNode newProjectRel = PrelFactories.PROJECT_FACTORY.createProject(bottomProject.getInput(), Collections.emptyList(), newProjects, topProject.getRowType().getFieldNames());
        return (Project)newProjectRel;
    }
}

