/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexUtil;

public class DrillMergeFilterRule
extends RelOptRule {
    public static final DrillMergeFilterRule INSTANCE = new DrillMergeFilterRule(RelFactories.DEFAULT_FILTER_FACTORY);
    private final RelFactories.FilterFactory filterFactory;

    private DrillMergeFilterRule(RelFactories.FilterFactory filterFactory) {
        super(DrillMergeFilterRule.operand(Filter.class, (RelOptRuleOperand)DrillMergeFilterRule.operand(Filter.class, (RelOptRuleOperandChildren)DrillMergeFilterRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        this.filterFactory = filterFactory;
    }

    public void onMatch(RelOptRuleCall call) {
        Filter topFilter = (Filter)call.rel(0);
        Filter bottomFilter = (Filter)call.rel(1);
        RexBuilder rexBuilder = topFilter.getCluster().getRexBuilder();
        RexProgram bottomProgram = this.createProgram(bottomFilter);
        RexProgram topProgram = this.createProgram(topFilter);
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms((RexProgram)topProgram, (RexProgram)bottomProgram, (RexBuilder)rexBuilder);
        RexNode newCondition = mergedProgram.expandLocalRef(mergedProgram.getCondition());
        Filter newFilterRel = (Filter)this.filterFactory.createFilter(bottomFilter.getInput(), RexUtil.flatten((RexBuilder)rexBuilder, (RexNode)newCondition));
        call.transformTo((RelNode)newFilterRel);
    }

    private RexProgram createProgram(Filter filterRel) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(filterRel.getRowType(), filterRel.getCluster().getRexBuilder());
        programBuilder.addIdentity();
        programBuilder.addCondition(filterRel.getCondition());
        return programBuilder.getProgram();
    }
}

