/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.drill.exec.planner.logical.DrillLimitRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.exec.planner.logical.RelOptHelper;

public class DrillLimitRule
extends RelOptRule {
    public static DrillLimitRule INSTANCE = new DrillLimitRule();

    private DrillLimitRule() {
        super(RelOptHelper.any(LogicalSort.class, (RelTrait)Convention.NONE), DrillRelFactories.LOGICAL_BUILDER, "DrillLimitRule");
    }

    public boolean matches(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        return sort.offset != null || sort.fetch != null;
    }

    public void onMatch(RelOptRuleCall call) {
        Sort incomingSort = (Sort)call.rel(0);
        RelTraitSet incomingTraits = incomingSort.getTraitSet();
        RelNode input = incomingSort.getInput();
        if (!incomingSort.getCollation().getFieldCollations().isEmpty()) {
            input = incomingSort.copy(incomingTraits, input, incomingSort.getCollation(), null, null);
        }
        RelNode convertedInput = DrillLimitRule.convert((RelNode)input, (RelTraitSet)input.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL).simplify());
        call.transformTo((RelNode)new DrillLimitRel(incomingSort.getCluster(), convertedInput.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL), convertedInput, incomingSort.offset, incomingSort.fetch));
    }
}

