/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.drill.common.logical.data.LateralJoin;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.exec.planner.common.DrillLateralJoinRelBase;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillJoinRel;
import org.apache.drill.exec.planner.logical.DrillRel;

public class DrillLateralJoinRel
extends DrillLateralJoinRelBase
implements DrillRel {
    protected DrillLateralJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, boolean excludeCorrelateCol, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType semiJoinType) {
        super(cluster, traits, left, right, excludeCorrelateCol, correlationId, requiredColumns, semiJoinType);
    }

    public Correlate copy(RelTraitSet traitSet, RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType joinType) {
        return new DrillLateralJoinRel(this.getCluster(), this.getTraitSet(), left, right, this.excludeCorrelateColumn, correlationId, requiredColumns, this.getJoinType());
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("exclude correlate column: ", (Object)this.excludeCorrelateColumn);
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.addAll(this.getInput(0).getRowType().getFieldNames());
        fields.addAll(this.getInput(1).getRowType().getFieldNames());
        assert (DrillJoinRel.isUnique(fields));
        int leftCount = this.getInputSize(0);
        LogicalOperator leftOp = DrillJoinRel.implementInput(implementor, 0, 0, this.left, this, fields);
        LogicalOperator rightOp = DrillJoinRel.implementInput(implementor, 1, leftCount, this.right, this, fields);
        return new LateralJoin(leftOp, rightOp);
    }
}

