/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.drill.exec.planner.logical.DrillFilterRel;
import org.apache.drill.exec.planner.logical.DrillJoinRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.exec.planner.logical.DrillSemiJoinRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;

public class DrillJoinRule
extends RelOptRule {
    public static final RelOptRule INSTANCE = new DrillJoinRule();
    protected static final Logger tracer = CalciteTrace.getPlannerTracer();

    private DrillJoinRule() {
        super(RelOptHelper.any(LogicalJoin.class, (RelTrait)Convention.NONE), DrillRelFactories.LOGICAL_BUILDER, "DrillJoinRule");
    }

    public void onMatch(RelOptRuleCall call) {
        boolean hasEquijoins;
        RexNode origJoinCondition;
        LogicalJoin join = (LogicalJoin)call.rel(0);
        RelNode left = join.getLeft();
        RelNode right = join.getRight();
        RelTraitSet traits = join.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL);
        RelNode convertedLeft = DrillJoinRule.convert((RelNode)left, (RelTraitSet)left.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL).simplify());
        RelNode convertedRight = DrillJoinRule.convert((RelNode)right, (RelTraitSet)right.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL).simplify());
        ArrayList<Integer> leftKeys = Lists.newArrayList();
        ArrayList<Integer> rightKeys = Lists.newArrayList();
        ArrayList<Boolean> filterNulls = Lists.newArrayList();
        boolean addFilter = false;
        RexNode newJoinCondition = origJoinCondition = join.getCondition();
        RexNode remaining = RelOptUtil.splitJoinCondition((RelNode)convertedLeft, (RelNode)convertedRight, (RexNode)origJoinCondition, leftKeys, rightKeys, filterNulls);
        boolean bl = hasEquijoins = leftKeys.size() == rightKeys.size() && leftKeys.size() > 0;
        if (!remaining.isAlwaysTrue()) {
            if (hasEquijoins && join.getJoinType() == JoinRelType.INNER) {
                addFilter = true;
                newJoinCondition = this.buildJoinCondition(convertedLeft, convertedRight, leftKeys, rightKeys, filterNulls, join.getCluster().getRexBuilder());
            }
        } else {
            newJoinCondition = this.buildJoinCondition(convertedLeft, convertedRight, leftKeys, rightKeys, filterNulls, join.getCluster().getRexBuilder());
        }
        try {
            if (join.isSemiJoin()) {
                DrillSemiJoinRel joinRel = new DrillSemiJoinRel(join.getCluster(), traits, convertedLeft, convertedRight, newJoinCondition, leftKeys, rightKeys);
                call.transformTo((RelNode)joinRel);
                return;
            }
            if (!addFilter) {
                DrillJoinRel joinRel = new DrillJoinRel(join.getCluster(), traits, convertedLeft, convertedRight, newJoinCondition, join.getJoinType(), leftKeys, rightKeys);
                call.transformTo((RelNode)joinRel);
            } else {
                DrillJoinRel joinRel = new DrillJoinRel(join.getCluster(), traits, convertedLeft, convertedRight, newJoinCondition, join.getJoinType(), leftKeys, rightKeys);
                call.transformTo((RelNode)new DrillFilterRel(join.getCluster(), traits, joinRel, remaining));
            }
        }
        catch (InvalidRelException e) {
            tracer.warn(e.toString());
        }
    }

    private RexNode buildJoinCondition(RelNode convertedLeft, RelNode convertedRight, List<Integer> leftKeys, List<Integer> rightKeys, List<Boolean> filterNulls, RexBuilder builder) {
        ArrayList<RexNode> equijoinList = Lists.newArrayList();
        int numLeftFields = convertedLeft.getRowType().getFieldCount();
        List leftTypes = convertedLeft.getRowType().getFieldList();
        List rightTypes = convertedRight.getRowType().getFieldList();
        for (int i = 0; i < leftKeys.size(); ++i) {
            int leftKeyOrdinal = leftKeys.get(i);
            int rightKeyOrdinal = rightKeys.get(i);
            equijoinList.add(builder.makeCall((SqlOperator)(filterNulls.get(i) != false ? SqlStdOperatorTable.EQUALS : SqlStdOperatorTable.IS_NOT_DISTINCT_FROM), new RexNode[]{builder.makeInputRef(((RelDataTypeField)leftTypes.get(leftKeyOrdinal)).getType(), leftKeyOrdinal), builder.makeInputRef(((RelDataTypeField)rightTypes.get(rightKeyOrdinal)).getType(), rightKeyOrdinal + numLeftFields)}));
        }
        return RexUtil.composeConjunction((RexBuilder)builder, equijoinList, (boolean)false);
    }
}

