/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.Pair;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.logical.data.Join;
import org.apache.drill.common.logical.data.JoinCondition;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.Project;
import org.apache.drill.exec.planner.common.DrillJoinRelBase;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.ExprHelper;
import org.apache.drill.exec.planner.torel.ConversionContext;

public class DrillJoinRel
extends DrillJoinRelBase
implements DrillRel {
    public static final String EQUALITY_CONDITION = "==";
    private int joinControl = 0;

    public DrillJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType) {
        super(cluster, traits, left, right, condition, joinType);
        assert (traits.contains((RelTrait)DrillRel.DRILL_LOGICAL));
        RelOptUtil.splitJoinCondition((RelNode)left, (RelNode)right, (RexNode)condition, (List)this.leftKeys, (List)this.rightKeys, (List)this.filterNulls);
    }

    public DrillJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, int joinControl) {
        super(cluster, traits, left, right, condition, joinType);
        assert (traits.contains((RelTrait)DrillRel.DRILL_LOGICAL));
        RelOptUtil.splitJoinCondition((RelNode)left, (RelNode)right, (RexNode)condition, (List)this.leftKeys, (List)this.rightKeys, (List)this.filterNulls);
        this.joinControl = joinControl;
    }

    public DrillJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, List<Integer> leftKeys, List<Integer> rightKeys) throws InvalidRelException {
        super(cluster, traits, left, right, condition, joinType);
        assert (traits.contains((RelTrait)DrillRel.DRILL_LOGICAL));
        assert (leftKeys != null && rightKeys != null);
        this.leftKeys = leftKeys;
        this.rightKeys = rightKeys;
    }

    public DrillJoinRel copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new DrillJoinRel(this.getCluster(), traitSet, left, right, condition, joinType);
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        List fields = this.getRowType().getFieldNames();
        assert (DrillJoinRel.isUnique(fields));
        int leftCount = this.left.getRowType().getFieldCount();
        List leftFields = fields.subList(0, leftCount);
        List rightFields = fields.subList(leftCount, fields.size());
        LogicalOperator leftOp = this.implementInput(implementor, 0, 0, this.left);
        LogicalOperator rightOp = this.implementInput(implementor, 1, leftCount, this.right);
        Join.Builder builder = Join.builder();
        builder.type(this.joinType);
        builder.left(leftOp);
        builder.right(rightOp);
        for (Pair pair : Pair.zip((List)this.leftKeys, (List)this.rightKeys)) {
            builder.addCondition(EQUALITY_CONDITION, new FieldReference((CharSequence)leftFields.get((Integer)pair.left)), new FieldReference((CharSequence)rightFields.get((Integer)pair.right)));
        }
        return builder.build();
    }

    private LogicalOperator implementInput(DrillImplementor implementor, int i, int offset, RelNode input) {
        return DrillJoinRel.implementInput(implementor, i, offset, input, this, this.getRowType().getFieldNames());
    }

    public static LogicalOperator implementInput(DrillImplementor implementor, int i, int offset, RelNode input, DrillRel currentNode, List<String> parentFields) {
        LogicalOperator inputOp = implementor.visitChild(currentNode, i, input);
        assert (DrillJoinRel.uniqueFieldNames(input.getRowType()));
        List inputFields = input.getRowType().getFieldNames();
        List<String> outputFields = parentFields.subList(offset, offset + inputFields.size());
        if (!outputFields.equals(inputFields)) {
            return DrillJoinRel.rename(implementor, inputOp, inputFields, outputFields);
        }
        return inputOp;
    }

    private static LogicalOperator rename(DrillImplementor implementor, LogicalOperator inputOp, List<String> inputFields, List<String> outputFields) {
        Project.Builder builder = Project.builder();
        builder.setInput(inputOp);
        for (Pair pair : Pair.zip(inputFields, outputFields)) {
            builder.addExpr(new FieldReference((CharSequence)pair.right), new FieldReference((CharSequence)pair.left));
        }
        return builder.build();
    }

    protected static Pair<RelNode, RelNode> getJoinInputs(Join join, ConversionContext context) throws InvalidRelException {
        RelNode left = context.toRel(join.getLeft());
        RelNode right = context.toRel(join.getRight());
        return Pair.of((Object)left, (Object)right);
    }

    protected static RexNode getJoinCondition(Join join, ConversionContext context) throws InvalidRelException {
        Pair<RelNode, RelNode> inputs = DrillJoinRel.getJoinInputs(join, context);
        ArrayList<RexNode> joinConditions = new ArrayList<RexNode>();
        int rightInputOffset = ((RelNode)inputs.left).getRowType().getFieldCount();
        for (JoinCondition condition : join.getConditions()) {
            RelDataTypeField leftField = ((RelNode)inputs.left).getRowType().getField(ExprHelper.getFieldName(condition.getLeft()), true, false);
            RelDataTypeField rightField = ((RelNode)inputs.right).getRowType().getField(ExprHelper.getFieldName(condition.getRight()), true, false);
            joinConditions.add(context.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{context.getRexBuilder().makeInputRef(leftField.getType(), leftField.getIndex()), context.getRexBuilder().makeInputRef(rightField.getType(), rightInputOffset + rightField.getIndex())}));
        }
        RexNode rexCondition = RexUtil.composeConjunction((RexBuilder)context.getRexBuilder(), joinConditions, (boolean)false);
        return rexCondition;
    }

    public static DrillJoinRel convert(Join join, ConversionContext context) throws InvalidRelException {
        Pair<RelNode, RelNode> inputs = DrillJoinRel.getJoinInputs(join, context);
        RexNode rexCondition = DrillJoinRel.getJoinCondition(join, context);
        DrillJoinRel joinRel = new DrillJoinRel(context.getCluster(), context.getLogicalTraits(), (RelNode)inputs.left, (RelNode)inputs.right, rexCondition, join.getJoinType());
        return joinRel;
    }
}

