/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.planner.logical.DrillFilterRel;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.FieldsReWriterUtil;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.types.RelDataTypeDrillImpl;
import org.apache.drill.exec.planner.types.RelDataTypeHolder;
import org.apache.drill.exec.store.parquet.AbstractParquetGroupScan;

public class DrillFilterItemStarReWriterRule {
    public static final ProjectOnScan PROJECT_ON_SCAN = new ProjectOnScan(RelOptHelper.some(DrillProjectRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), "DrillFilterItemStarReWriterRule.ProjectOnScan");
    public static final FilterOnScan FILTER_ON_SCAN = new FilterOnScan(RelOptHelper.some(DrillFilterRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), "DrillFilterItemStarReWriterRule.FilterOnScan");
    public static final FilterProjectScan FILTER_PROJECT_SCAN = new FilterProjectScan(RelOptHelper.some(DrillFilterRel.class, RelOptHelper.some(DrillProjectRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "DrillFilterItemStarReWriterRule.FilterProjectScan");

    private static void transformFilterCall(DrillFilterRel filterRel, DrillProjectRel projectRel, DrillScanRel scanRel, RelOptRuleCall call) {
        List fieldNames = projectRel == null ? scanRel.getRowType().getFieldNames() : projectRel.getRowType().getFieldNames();
        ItemStarFieldsVisitor itemStarFieldsVisitor = new ItemStarFieldsVisitor(fieldNames);
        filterRel.getCondition().accept((RexVisitor)itemStarFieldsVisitor);
        if (itemStarFieldsVisitor.hasNoItemStarFields()) {
            return;
        }
        Map<String, FieldsReWriterUtil.DesiredField> itemStarFields = itemStarFieldsVisitor.getItemStarFields();
        DrillScanRel newScan = DrillFilterItemStarReWriterRule.createNewScan(scanRel, itemStarFields);
        DrillRel newProject = null;
        if (projectRel != null) {
            int projectIndex = scanRel.getRowType().getFieldCount();
            ArrayList<RexInputRef> newProjects = new ArrayList<RexInputRef>(projectRel.getProjects());
            for (FieldsReWriterUtil.DesiredField desiredField : itemStarFields.values()) {
                newProjects.add(new RexInputRef(projectIndex, desiredField.getType()));
                ++projectIndex;
            }
            RelDataType newProjectRowType = DrillFilterItemStarReWriterRule.createNewRowType(projectRel.getCluster().getTypeFactory(), projectRel.getRowType().getFieldList(), itemStarFields.keySet());
            newProject = new DrillProjectRel(projectRel.getCluster(), projectRel.getTraitSet(), newScan, newProjects, newProjectRowType);
        }
        Map<RexNode, Integer> fieldMapper = DrillFilterItemStarReWriterRule.createFieldMapper(itemStarFields.values(), scanRel.getRowType().getFieldCount());
        FieldsReWriterUtil.FieldsReWriter fieldsReWriter = new FieldsReWriterUtil.FieldsReWriter(fieldMapper);
        RexNode newCondition = (RexNode)filterRel.getCondition().accept((RexVisitor)fieldsReWriter);
        DrillFilterRel newFilter = DrillFilterRel.create(newProject != null ? newProject : newScan, newCondition);
        ArrayList<RexInputRef> newProjects = new ArrayList<RexInputRef>();
        RelDataType rowType = filterRel.getRowType();
        List fieldList = rowType.getFieldList();
        for (RelDataTypeField field : fieldList) {
            RexInputRef inputRef = new RexInputRef(field.getIndex(), field.getType());
            newProjects.add(inputRef);
        }
        DrillProjectRel wrapper = new DrillProjectRel(filterRel.getCluster(), filterRel.getTraitSet(), newFilter, newProjects, filterRel.getRowType());
        call.transformTo((RelNode)wrapper);
    }

    private static RelDataType createNewRowType(RelDataTypeFactory typeFactory, List<RelDataTypeField> originalFields, Collection<String> newFields) {
        RelDataTypeHolder relDataTypeHolder = new RelDataTypeHolder();
        for (RelDataTypeField field : originalFields) {
            relDataTypeHolder.getField(typeFactory, field.getName());
        }
        for (String fieldName : newFields) {
            relDataTypeHolder.getField(typeFactory, fieldName);
        }
        return new RelDataTypeDrillImpl(relDataTypeHolder, typeFactory);
    }

    private static DrillScanRel createNewScan(DrillScanRel scanRel, Map<String, FieldsReWriterUtil.DesiredField> itemStarFields) {
        RelDataType newScanRowType = DrillFilterItemStarReWriterRule.createNewRowType(scanRel.getCluster().getTypeFactory(), scanRel.getRowType().getFieldList(), itemStarFields.keySet());
        ArrayList<SchemaPath> columns = new ArrayList<SchemaPath>(scanRel.getColumns());
        for (FieldsReWriterUtil.DesiredField desiredField : itemStarFields.values()) {
            String name = desiredField.getName();
            PathSegment.NameSegment nameSegment = new PathSegment.NameSegment(name);
            columns.add(new SchemaPath(nameSegment));
        }
        return new DrillScanRel(scanRel.getCluster(), scanRel.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL), scanRel.getTable(), newScanRowType, columns);
    }

    private static Map<RexNode, Integer> createFieldMapper(Collection<FieldsReWriterUtil.DesiredField> desiredFields, int startingIndex) {
        HashMap<RexNode, Integer> fieldMapper = new HashMap<RexNode, Integer>();
        int index = startingIndex;
        for (FieldsReWriterUtil.DesiredField desiredField : desiredFields) {
            for (RexNode node : desiredField.getNodes()) {
                fieldMapper.put(node, index);
            }
            ++index;
        }
        return fieldMapper;
    }

    private static class ItemStarFieldsVisitor
    extends RexVisitorImpl<RexNode> {
        private final Map<String, FieldsReWriterUtil.DesiredField> itemStarFields = new HashMap<String, FieldsReWriterUtil.DesiredField>();
        private final List<String> fieldNames;

        ItemStarFieldsVisitor(List<String> fieldNames) {
            super(true);
            this.fieldNames = fieldNames;
        }

        boolean hasNoItemStarFields() {
            return this.itemStarFields.isEmpty();
        }

        Map<String, FieldsReWriterUtil.DesiredField> getItemStarFields() {
            return this.itemStarFields;
        }

        public RexNode visitCall(RexCall call) {
            String fieldName = FieldsReWriterUtil.getFieldNameFromItemStarField(call, this.fieldNames);
            if (fieldName != null) {
                FieldsReWriterUtil.DesiredField desiredField = this.itemStarFields.get(fieldName);
                if (desiredField == null) {
                    this.itemStarFields.put(fieldName, new FieldsReWriterUtil.DesiredField(fieldName, call.getType(), (RexNode)call));
                } else {
                    desiredField.addNode((RexNode)call);
                }
            }
            return (RexNode)super.visitCall(call);
        }
    }

    private static class ProjectOnScan
    extends RelOptRule {
        ProjectOnScan(RelOptRuleOperand operand, String id) {
            super(operand, id);
        }

        public boolean matches(RelOptRuleCall call) {
            DrillScanRel scan = (DrillScanRel)call.rel(1);
            return scan.getGroupScan() instanceof AbstractParquetGroupScan && super.matches(call);
        }

        public void onMatch(RelOptRuleCall call) {
            DrillProjectRel projectRel = (DrillProjectRel)call.rel(0);
            DrillScanRel scanRel = (DrillScanRel)call.rel(1);
            ItemStarFieldsVisitor itemStarFieldsVisitor = new ItemStarFieldsVisitor(scanRel.getRowType().getFieldNames());
            List projects = projectRel.getProjects();
            for (RexNode project : projects) {
                project.accept((RexVisitor)itemStarFieldsVisitor);
            }
            if (itemStarFieldsVisitor.hasNoItemStarFields()) {
                return;
            }
            Map<String, FieldsReWriterUtil.DesiredField> itemStarFields = itemStarFieldsVisitor.getItemStarFields();
            DrillScanRel newScan = DrillFilterItemStarReWriterRule.createNewScan(scanRel, itemStarFields);
            Map fieldMapper = DrillFilterItemStarReWriterRule.createFieldMapper(itemStarFields.values(), scanRel.getRowType().getFieldCount());
            FieldsReWriterUtil.FieldsReWriter fieldsReWriter = new FieldsReWriterUtil.FieldsReWriter(fieldMapper);
            List newProjects = projectRel.getProjects().stream().map(node -> (RexNode)node.accept((RexVisitor)fieldsReWriter)).collect(Collectors.toList());
            DrillProjectRel newProject = new DrillProjectRel(projectRel.getCluster(), projectRel.getTraitSet(), newScan, newProjects, projectRel.getRowType());
            if (ProjectRemoveRule.isTrivial((Project)newProject)) {
                call.transformTo((RelNode)newScan);
            } else {
                call.transformTo((RelNode)newProject);
            }
        }
    }

    private static class FilterOnScan
    extends RelOptRule {
        FilterOnScan(RelOptRuleOperand operand, String id) {
            super(operand, id);
        }

        public boolean matches(RelOptRuleCall call) {
            DrillScanRel scan = (DrillScanRel)call.rel(1);
            return scan.getGroupScan() instanceof AbstractParquetGroupScan && super.matches(call);
        }

        public void onMatch(RelOptRuleCall call) {
            DrillFilterRel filterRel = (DrillFilterRel)call.rel(0);
            DrillScanRel scanRel = (DrillScanRel)call.rel(1);
            DrillFilterItemStarReWriterRule.transformFilterCall(filterRel, null, scanRel, call);
        }
    }

    private static class FilterProjectScan
    extends RelOptRule {
        FilterProjectScan(RelOptRuleOperand operand, String id) {
            super(operand, id);
        }

        public boolean matches(RelOptRuleCall call) {
            DrillScanRel scan = (DrillScanRel)call.rel(2);
            return scan.getGroupScan() instanceof AbstractParquetGroupScan && super.matches(call);
        }

        public void onMatch(RelOptRuleCall call) {
            DrillFilterRel filterRel = (DrillFilterRel)call.rel(0);
            DrillProjectRel projectRel = (DrillProjectRel)call.rel(1);
            DrillScanRel scanRel = (DrillScanRel)call.rel(2);
            DrillFilterItemStarReWriterRule.transformFilterCall(filterRel, projectRel, scanRel, call);
        }
    }
}

