/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.drill.exec.physical.impl.join.JoinUtils;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.exec.planner.logical.RelOptHelper;

public class DrillDistinctJoinToSemiJoinRule
extends RelOptRule {
    public static final RelOptRule INSTANCE = new DrillDistinctJoinToSemiJoinRule();

    public DrillDistinctJoinToSemiJoinRule() {
        super(RelOptHelper.any(Project.class, Join.class), DrillRelFactories.LOGICAL_BUILDER, "DrillDistinctJoinToSemiJoinRule");
    }

    public boolean matches(RelOptRuleCall call) {
        RelMetadataQuery mq = call.getMetadataQuery();
        Project project = (Project)call.rel(0);
        Join join = (Join)call.rel(1);
        ImmutableBitSet bits = RelOptUtil.InputFinder.bits((List)project.getProjects(), null);
        ImmutableBitSet rightBits = ImmutableBitSet.range((int)join.getLeft().getRowType().getFieldCount(), (int)join.getRowType().getFieldCount());
        JoinInfo joinInfo = join.analyzeCondition();
        return !JoinUtils.checkCartesianJoin((RelNode)join) && !bits.intersects(rightBits) && joinInfo.isEqui() && SqlFunctions.isTrue((Boolean)mq.areColumnsUnique(join.getRight(), joinInfo.rightSet()));
    }

    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        Join join = (Join)call.rel(1);
        RelBuilder relBuilder = call.builder();
        RelNode relNode = relBuilder.push(join.getLeft()).push(join.getRight()).semiJoin(new RexNode[]{join.getCondition()}).project((Iterable)project.getProjects()).build();
        call.transformTo(relNode);
    }
}

