/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.expr.IsPredicate;
import org.apache.drill.exec.metastore.ColumnNamesOptions;
import org.apache.drill.exec.metastore.analyze.AnalyzeColumnUtils;
import org.apache.drill.exec.metastore.analyze.MetadataAggregateContext;
import org.apache.drill.exec.metastore.store.parquet.ParquetMetadataProvider;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.planner.logical.DrillDirectScanRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.MetadataAggRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.DictColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.FormatSelection;
import org.apache.drill.exec.store.direct.DirectGroupScan;
import org.apache.drill.exec.store.parquet.BaseParquetMetadataProvider;
import org.apache.drill.exec.store.parquet.ParquetGroupScan;
import org.apache.drill.exec.store.pojo.DynamicPojoRecordReader;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.exec.util.Utilities;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.metadata.RowGroupMetadata;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.statistics.ColumnStatisticsKind;
import org.apache.drill.metastore.statistics.StatisticsKind;
import org.apache.drill.metastore.statistics.TableStatisticsKind;
import org.apache.drill.shaded.guava.com.google.common.collect.HashBasedTable;
import org.apache.drill.shaded.guava.com.google.common.collect.Multimap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertMetadataAggregateToDirectScanRule
extends RelOptRule {
    private static final Logger logger = LoggerFactory.getLogger(ConvertMetadataAggregateToDirectScanRule.class);
    public static final ConvertMetadataAggregateToDirectScanRule INSTANCE = new ConvertMetadataAggregateToDirectScanRule();

    public ConvertMetadataAggregateToDirectScanRule() {
        super(RelOptHelper.some(MetadataAggRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), DrillRelFactories.LOGICAL_BUILDER, "ConvertMetadataAggregateToDirectScanRule");
    }

    public void onMatch(RelOptRuleCall call) {
        MetadataAggRel agg = (MetadataAggRel)call.rel(0);
        DrillScanRel scan = (DrillScanRel)call.rel(1);
        GroupScan oldGrpScan = scan.getGroupScan();
        PlannerSettings settings = PrelUtil.getPlannerSettings(call.getPlanner());
        if (!(oldGrpScan instanceof ParquetGroupScan) || oldGrpScan.getTableMetadata().getInterestingColumns() != null && !oldGrpScan.getTableMetadata().getInterestingColumns().containsAll(agg.getContext().interestingColumns())) {
            return;
        }
        try {
            DirectGroupScan directScan = this.buildDirectScan(agg.getContext().interestingColumns(), scan, settings);
            if (directScan == null) {
                logger.warn("Unable to use parquet metadata for ANALYZE since some required metadata is absent within parquet metadata");
                return;
            }
            DrillRel converted = new DrillDirectScanRel(scan.getCluster(), scan.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL), directScan, scan.getRowType());
            if (agg.getContext().metadataLevel() != MetadataType.ROW_GROUP) {
                MetadataAggregateContext updatedContext = agg.getContext().toBuilder().createNewAggregations(false).build();
                converted = new MetadataAggRel(agg.getCluster(), agg.getTraitSet(), converted, updatedContext);
            }
            call.transformTo((RelNode)converted);
        }
        catch (Exception e) {
            logger.warn("Unable to use parquet metadata for ANALYZE: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private DirectGroupScan buildDirectScan(List<SchemaPath> interestingColumns, DrillScanRel scan, PlannerSettings settings) throws IOException {
        DrillTable drillTable = Utilities.getDrillTable(scan.getTable());
        ColumnNamesOptions columnNamesOptions = new ColumnNamesOptions(settings.getOptions());
        FormatSelection selection = (FormatSelection)drillTable.getSelection();
        Map<String, Class<?>> schema = ColumnExplorer.getPartitionColumnNames(selection.getSelection(), columnNamesOptions).stream().collect(Collectors.toMap(Function.identity(), s -> String.class, (o, n) -> n));
        schema.put("schema", String.class);
        schema.put("location", String.class);
        schema.put(columnNamesOptions.rowGroupIndex(), String.class);
        schema.put(columnNamesOptions.rowGroupStart(), String.class);
        schema.put(columnNamesOptions.rowGroupLength(), String.class);
        schema.put(columnNamesOptions.lastModifiedTime(), String.class);
        return this.populateRecords(interestingColumns, schema, scan, columnNamesOptions);
    }

    private DirectGroupScan populateRecords(Collection<SchemaPath> interestingColumns, Map<String, Class<?>> schema, DrillScanRel scan, ColumnNamesOptions columnNamesOptions) throws IOException {
        ParquetGroupScan parquetGroupScan = (ParquetGroupScan)scan.getGroupScan();
        DrillTable drillTable = Utilities.getDrillTable(scan.getTable());
        Multimap<Path, RowGroupMetadata> rowGroupsMetadataMap = ((ParquetMetadataProvider)parquetGroupScan.getMetadataProvider()).getRowGroupsMetadataMap();
        HashBasedTable<String, Integer, Object> recordsTable = HashBasedTable.create();
        FormatSelection selection = (FormatSelection)drillTable.getSelection();
        List<String> partitionColumnNames = ColumnExplorer.getPartitionColumnNames(selection.getSelection(), columnNamesOptions);
        FileSystem rawFs = selection.getSelection().getSelectionRoot().getFileSystem(new Configuration());
        DrillFileSystem fileSystem = ImpersonationUtil.createFileSystem(ImpersonationUtil.getProcessUserName(), rawFs.getConf());
        int rowIndex = 0;
        for (Map.Entry<Path, RowGroupMetadata> entry : rowGroupsMetadataMap.entries()) {
            Path path = entry.getKey();
            RowGroupMetadata rowGroupMetadata = entry.getValue();
            List<String> partitionValues = ColumnExplorer.listPartitionValues(path, selection.getSelection().getSelectionRoot(), false);
            for (int i = 0; i < partitionValues.size(); ++i) {
                String string = partitionColumnNames.get(i);
                recordsTable.put(string, rowIndex, partitionValues.get(i));
            }
            recordsTable.put("location", rowIndex, ColumnExplorer.ImplicitFileColumns.FQN.getValue(path));
            recordsTable.put(columnNamesOptions.rowGroupIndex(), rowIndex, String.valueOf(rowGroupMetadata.getRowGroupIndex()));
            if (interestingColumns == null) {
                interestingColumns = rowGroupMetadata.getColumnsStatistics().keySet();
            }
            for (SchemaPath schemaPath : interestingColumns) {
                ColumnStatistics<?> columnStatistics = rowGroupMetadata.getColumnsStatistics().get(schemaPath);
                if (ConvertMetadataAggregateToDirectScanRule.containsArrayColumn(rowGroupMetadata.getSchema(), schemaPath)) continue;
                if (IsPredicate.isNullOrEmpty(columnStatistics)) {
                    logger.debug("Statistics for {} column wasn't found within {} row group.", (Object)schemaPath, (Object)path);
                    return null;
                }
                for (StatisticsKind<?> statisticsKind : AnalyzeColumnUtils.COLUMN_STATISTICS_FUNCTIONS.keySet()) {
                    Long statsValue = statisticsKind.getName().equalsIgnoreCase(TableStatisticsKind.ROW_COUNT.getName()) ? TableStatisticsKind.ROW_COUNT.getValue(rowGroupMetadata) : (statisticsKind.getName().equalsIgnoreCase(ColumnStatisticsKind.NON_NULL_VALUES_COUNT.getName()) ? Long.valueOf(TableStatisticsKind.ROW_COUNT.getValue(rowGroupMetadata) - ColumnStatisticsKind.NULLS_COUNT.getFrom(columnStatistics)) : columnStatistics.get(statisticsKind));
                    String columnStatisticsFieldName = AnalyzeColumnUtils.getColumnStatisticsFieldName(schemaPath.toExpr(), statisticsKind);
                    if (statsValue != null) {
                        schema.putIfAbsent(columnStatisticsFieldName, statsValue.getClass());
                        recordsTable.put(columnStatisticsFieldName, rowIndex, statsValue);
                        continue;
                    }
                    recordsTable.put(columnStatisticsFieldName, rowIndex, BaseParquetMetadataProvider.NULL_VALUE);
                }
            }
            for (StatisticsKind statisticsKind : AnalyzeColumnUtils.META_STATISTICS_FUNCTIONS.keySet()) {
                String metadataStatisticsFieldName = AnalyzeColumnUtils.getMetadataStatisticsFieldName(statisticsKind);
                Object statisticsValue = rowGroupMetadata.getStatistic(statisticsKind);
                if (statisticsValue != null) {
                    schema.putIfAbsent(metadataStatisticsFieldName, statisticsValue.getClass());
                    recordsTable.put(metadataStatisticsFieldName, rowIndex, statisticsValue);
                    continue;
                }
                recordsTable.put(metadataStatisticsFieldName, rowIndex, BaseParquetMetadataProvider.NULL_VALUE);
            }
            recordsTable.put("schema", rowIndex, rowGroupMetadata.getSchema().jsonString());
            recordsTable.put(columnNamesOptions.rowGroupStart(), rowIndex, Long.toString((Long)rowGroupMetadata.getStatistic(() -> "start")));
            recordsTable.put(columnNamesOptions.rowGroupLength(), rowIndex, Long.toString((Long)rowGroupMetadata.getStatistic(() -> "length")));
            recordsTable.put(columnNamesOptions.lastModifiedTime(), rowIndex, String.valueOf(fileSystem.getFileStatus(path).getModificationTime()));
            ++rowIndex;
        }
        LinkedHashMap orderedSchema = new LinkedHashMap();
        for (String s : recordsTable.rowKeySet()) {
            Class<?> clazz = schema.get(s);
            if (clazz != null) {
                orderedSchema.put(s, clazz);
                continue;
            }
            return null;
        }
        IntFunction<List> intFunction = currentIndex -> orderedSchema.keySet().stream().map(column -> recordsTable.get(column, currentIndex)).map(value -> value != BaseParquetMetadataProvider.NULL_VALUE ? value : null).collect(Collectors.toList());
        List records = IntStream.range(0, rowIndex).mapToObj(intFunction).collect(Collectors.toList());
        DynamicPojoRecordReader reader = new DynamicPojoRecordReader(orderedSchema, records);
        ScanStats scanStats = new ScanStats(ScanStats.GroupScanProperty.EXACT_ROW_COUNT, records.size(), 1.0, schema.size());
        return new DirectGroupScan(reader, scanStats);
    }

    private static boolean containsArrayColumn(TupleMetadata schema, SchemaPath schemaPath) {
        PathSegment currentPath = schemaPath.getRootSegment();
        ColumnMetadata columnMetadata = schema.metadata(currentPath.getNameSegment().getPath());
        while (columnMetadata != null) {
            if (columnMetadata.isArray()) {
                return true;
            }
            if (columnMetadata.isMap()) {
                currentPath = currentPath.getChild();
                columnMetadata = columnMetadata.tupleSchema().metadata(currentPath.getNameSegment().getPath());
                continue;
            }
            if (columnMetadata.isDict()) {
                currentPath = currentPath.getChild();
                columnMetadata = ((DictColumnMetadata)columnMetadata).valueColumnMetadata();
                continue;
            }
            return false;
        }
        return false;
    }
}

