/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index.rules;

import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.DbGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.index.rules.MatchFunction;
import org.apache.drill.exec.planner.logical.DrillScanRel;

public abstract class AbstractMatchFunction<T>
implements MatchFunction<T> {
    public boolean checkScan(DrillScanRel scanRel) {
        GroupScan groupScan = scanRel.getGroupScan();
        if (groupScan instanceof DbGroupScan) {
            DbGroupScan dbscan = (DbGroupScan)groupScan;
            return dbscan.supportsSecondaryIndex() && !dbscan.isIndexScan() && !dbscan.isRestrictedScan();
        }
        return false;
    }

    public boolean checkScan(GroupScan groupScan) {
        if (groupScan instanceof DbGroupScan) {
            DbGroupScan dbscan = (DbGroupScan)groupScan;
            return dbscan.supportsSecondaryIndex() && !dbscan.isRestrictedScan() && (!dbscan.isFilterPushedDown() || dbscan.isIndexScan()) && !AbstractMatchFunction.containsStar(dbscan);
        }
        return false;
    }

    public static boolean containsStar(DbGroupScan dbscan) {
        for (SchemaPath column : dbscan.getColumns()) {
            if (!column.getRootSegment().getPath().startsWith("*")) continue;
            return true;
        }
        return false;
    }
}

