/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index.generators;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.DbGroupScan;
import org.apache.drill.exec.physical.base.IndexGroupScan;
import org.apache.drill.exec.planner.index.FunctionalIndexHelper;
import org.apache.drill.exec.planner.index.FunctionalIndexInfo;
import org.apache.drill.exec.planner.index.IndexConditionInfo;
import org.apache.drill.exec.planner.index.IndexDescriptor;
import org.apache.drill.exec.planner.index.IndexLogicalPlanCallContext;
import org.apache.drill.exec.planner.index.IndexPlanUtils;
import org.apache.drill.exec.planner.index.generators.AbstractIndexPlanGenerator;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.apache.drill.exec.planner.physical.FilterPrel;
import org.apache.drill.exec.planner.physical.HashJoinPrel;
import org.apache.drill.exec.planner.physical.JoinPrel;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.RowKeyJoinPrel;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexIntersectPlanGenerator
extends AbstractIndexPlanGenerator {
    static final Logger logger = LoggerFactory.getLogger(IndexIntersectPlanGenerator.class);
    final Map<IndexDescriptor, IndexConditionInfo> indexInfoMap;

    public IndexIntersectPlanGenerator(IndexLogicalPlanCallContext indexContext, Map<IndexDescriptor, IndexConditionInfo> indexInfoMap, RexBuilder builder, PlannerSettings settings) {
        super(indexContext, null, null, builder, settings);
        this.indexInfoMap = indexInfoMap;
    }

    public RelNode buildRowKeyJoin(RelNode left, RelNode right, boolean isRowKeyJoin, int htControl) throws InvalidRelException {
        int leftRowKeyIdx = IndexIntersectPlanGenerator.getRowKeyIndex(left.getRowType(), this.origScan);
        boolean rightRowKeyIdx = false;
        assert (leftRowKeyIdx >= 0);
        ImmutableList<Integer> leftJoinKeys = ImmutableList.of(Integer.valueOf(leftRowKeyIdx));
        ImmutableList<Integer> rightJoinKeys = ImmutableList.of(Integer.valueOf(0));
        logger.trace(String.format("buildRowKeyJoin: leftIdx: %d, rightIdx: %d", leftRowKeyIdx, 0));
        RexNode joinCondition = RelOptUtil.createEquiJoinCondition((RelNode)left, leftJoinKeys, (RelNode)right, rightJoinKeys, (RexBuilder)this.builder);
        if (isRowKeyJoin) {
            JoinPrel newRel;
            if (this.settings.isIndexUseHashJoinNonCovering()) {
                HashJoinPrel hjPrel = new HashJoinPrel(left.getCluster(), left.getTraitSet(), left, right, joinCondition, JoinRelType.INNER, false, null, isRowKeyJoin, htControl);
                newRel = hjPrel;
            } else {
                RowKeyJoinPrel rjPrel;
                newRel = rjPrel = new RowKeyJoinPrel(left.getCluster(), left.getTraitSet(), left, right, joinCondition, JoinRelType.INNER);
            }
            return this.buildOriginalProject(newRel);
        }
        HashJoinPrel hjPrel = new HashJoinPrel(left.getCluster(), left.getTraitSet(), left, right, joinCondition, JoinRelType.INNER, false, null, isRowKeyJoin, htControl);
        return this.buildRowKeyProject(hjPrel, leftRowKeyIdx);
    }

    public RelNode buildRowKeyProject(RelNode inputRel, int fieldIndex) {
        List inputFields = inputRel.getRowType().getFieldList();
        RelDataTypeField rowKeyField = (RelDataTypeField)inputFields.get(fieldIndex);
        RexInputRef expr = this.builder.makeInputRef(rowKeyField.getType(), rowKeyField.getIndex());
        ArrayList<RexNode> exprs = Lists.newArrayList();
        exprs.add((RexNode)expr);
        RelDataTypeFactory.FieldInfoBuilder rightFieldTypeBuilder = inputRel.getCluster().getTypeFactory().builder();
        rightFieldTypeBuilder.add(rowKeyField);
        RelDataType projectRowType = rightFieldTypeBuilder.build();
        ProjectPrel proj = new ProjectPrel(inputRel.getCluster(), inputRel.getTraitSet(), inputRel, exprs, projectRowType);
        return proj;
    }

    public RelNode buildOriginalProject(RelNode newRel) {
        RelDataType origRowType = this.origProject == null ? this.origScan.getRowType() : this.origProject.getRowType();
        RelDataTypeFactory.FieldInfoBuilder finalFieldTypeBuilder = this.origScan.getCluster().getTypeFactory().builder();
        List hjRowFields = newRel.getRowType().getFieldList();
        int toRemoveRowKeyCount = 1;
        if (IndexIntersectPlanGenerator.getRowKeyIndex(origRowType, this.origScan) < 0) {
            toRemoveRowKeyCount = 2;
        }
        finalFieldTypeBuilder.addAll(hjRowFields.subList(0, hjRowFields.size() - toRemoveRowKeyCount));
        RelDataType finalProjectRowType = finalFieldTypeBuilder.build();
        ArrayList<RexNode> resetExprs = Lists.newArrayList();
        for (int idx = 0; idx < hjRowFields.size() - toRemoveRowKeyCount; ++idx) {
            resetExprs.add((RexNode)RexInputRef.of((int)idx, (RelDataType)newRel.getRowType()));
        }
        ProjectPrel resetProjectPrel = new ProjectPrel(newRel.getCluster(), newRel.getTraitSet(), newRel, resetExprs, finalProjectRowType);
        newRel = resetProjectPrel;
        RelNode finalRel = Prule.convert(newRel, newRel.getTraitSet());
        return finalRel;
    }

    private FunctionalIndexInfo getFunctionalIndexInfo(IndexDescriptor index) {
        return index.getFunctionalInfo();
    }

    public RelNode buildIntersectPlan(Map.Entry<IndexDescriptor, RexNode> pair, RelNode right, boolean generateDistribution) throws InvalidRelException {
        IndexDescriptor index = pair.getKey();
        RexNode condition = pair.getValue();
        FunctionalIndexInfo functionInfo = this.getFunctionalIndexInfo(index);
        IndexGroupScan indexScan = index.getIndexGroupScan();
        RelDataType indexScanRowType = FunctionalIndexHelper.convertRowTypeForIndexScan(this.origScan, this.indexContext.getOrigMarker(), indexScan, functionInfo);
        DrillDistributionTrait partition = IndexPlanUtils.scanIsPartition(IndexPlanUtils.getGroupScan(this.origScan)) ? DrillDistributionTrait.RANDOM_DISTRIBUTED : DrillDistributionTrait.SINGLETON;
        ScanPrel indexScanPrel = new ScanPrel(this.origScan.getCluster(), this.origScan.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)partition), indexScan, indexScanRowType, this.origScan.getTable());
        FilterPrel indexFilterPrel = new FilterPrel(indexScanPrel.getCluster(), indexScanPrel.getTraitSet(), indexScanPrel, FunctionalIndexHelper.convertConditionForIndexScan(condition, this.origScan, indexScanRowType, this.builder, functionInfo));
        ArrayList<RexNode> indexProjectExprs = Lists.newArrayList();
        int rowKeyIndex = IndexIntersectPlanGenerator.getRowKeyIndex(indexScanPrel.getRowType(), this.origScan);
        assert (rowKeyIndex >= 0);
        indexProjectExprs.add((RexNode)RexInputRef.of((int)rowKeyIndex, (RelDataType)indexScanPrel.getRowType()));
        RelDataTypeFactory.FieldInfoBuilder rightFieldTypeBuilder = indexScanPrel.getCluster().getTypeFactory().builder();
        List indexScanFields = indexScanPrel.getRowType().getFieldList();
        RelDataTypeField rightRowKeyField = (RelDataTypeField)indexScanFields.get(rowKeyIndex);
        rightFieldTypeBuilder.add(rightRowKeyField);
        RelDataType indexProjectRowType = rightFieldTypeBuilder.build();
        ProjectPrel indexProjectPrel = new ProjectPrel(indexScanPrel.getCluster(), indexScanPrel.getTraitSet(), indexFilterPrel, indexProjectExprs, indexProjectRowType);
        RelTraitSet rightSideTraits = this.newTraitSet(new RelTrait[0]).plus((RelTrait)Prel.DRILL_PHYSICAL);
        RelMetadataQuery mq = indexProjectPrel.getCluster().getMetadataQuery();
        if (right == null && partition == DrillDistributionTrait.RANDOM_DISTRIBUTED && (double)this.settings.getSliceTarget() < indexProjectPrel.estimateRowCount(mq)) {
            DrillDistributionTrait distRight = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.BROADCAST_DISTRIBUTED);
            rightSideTraits = this.newTraitSet(distRight).plus((RelTrait)Prel.DRILL_PHYSICAL);
        }
        RelNode converted = Prule.convert(indexProjectPrel, rightSideTraits);
        if (right == null) {
            return converted;
        }
        RelNode finalRel = this.buildRowKeyJoin(converted, right, false, 1);
        if (generateDistribution && right.getTraitSet().getTrait((RelTraitDef)DrillDistributionTraitDef.INSTANCE) != DrillDistributionTrait.SINGLETON) {
            DrillDistributionTrait distRight = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.BROADCAST_DISTRIBUTED);
            rightSideTraits = this.newTraitSet(distRight).plus((RelTrait)Prel.DRILL_PHYSICAL);
            finalRel = Prule.convert(finalRel, rightSideTraits);
        }
        logger.trace("IndexIntersectPlanGenerator got finalRel {} from origScan {}", (Object)finalRel.toString(), (Object)this.origScan.toString());
        return finalRel;
    }

    private Pair<RelNode, DbGroupScan> buildRestrictedDBScan(RexNode remnant, boolean isAnyIndexAsync) {
        ScanPrel dbScan;
        DbGroupScan restrictedGroupScan;
        DbGroupScan origDbGroupScan = (DbGroupScan)IndexPlanUtils.getGroupScan(this.origScan);
        ArrayList<SchemaPath> cols = new ArrayList<SchemaPath>(origDbGroupScan.getColumns());
        if (!this.checkRowKey(cols)) {
            cols.add(origDbGroupScan.getRowKeyPath());
        }
        if ((restrictedGroupScan = origDbGroupScan.getRestrictedScan(cols)) == null) {
            logger.error("Null restricted groupscan in IndexIntersectPlanGenerator.convertChild");
            return null;
        }
        DrillDistributionTrait partition = IndexPlanUtils.scanIsPartition(IndexPlanUtils.getGroupScan(this.origScan)) ? DrillDistributionTrait.RANDOM_DISTRIBUTED : DrillDistributionTrait.SINGLETON;
        RelDataType dbscanRowType = this.convertRowType(this.origScan.getRowType(), this.origScan.getCluster().getTypeFactory());
        Prel lastRelNode = dbScan = new ScanPrel(this.origScan.getCluster(), this.origScan.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL).plus((RelTrait)partition), restrictedGroupScan, dbscanRowType, this.origScan.getTable());
        ArrayList<RexNode> leftProjectExprs = Lists.newArrayList();
        int leftRowKeyIndex = IndexIntersectPlanGenerator.getRowKeyIndex(dbScan.getRowType(), this.origScan);
        RelDataTypeField leftRowKeyField = (RelDataTypeField)dbScan.getRowType().getFieldList().get(leftRowKeyIndex);
        RelDataTypeFactory.FieldInfoBuilder leftFieldTypeBuilder = dbScan.getCluster().getTypeFactory().builder();
        Object leftIndexFilterPrel = null;
        if (isAnyIndexAsync) {
            new FilterPrel(dbScan.getCluster(), dbScan.getTraitSet(), dbScan, this.indexContext.getOrigCondition());
            lastRelNode = leftIndexFilterPrel;
        }
        ProjectPrel leftIndexProjectPrel = null;
        if (this.origProject != null) {
            RelDataType origRowType = this.origProject.getRowType();
            List origProjFields = origRowType.getFieldList();
            leftFieldTypeBuilder.addAll((Iterable)origProjFields);
            leftProjectExprs.addAll(IndexPlanUtils.getProjects(this.origProject));
            if (IndexIntersectPlanGenerator.getRowKeyIndex(origRowType, this.origScan) < 0) {
                leftFieldTypeBuilder.add(leftRowKeyField);
                leftProjectExprs.add((RexNode)RexInputRef.of((int)leftRowKeyIndex, (RelDataType)dbScan.getRowType()));
            }
            RelDataType leftProjectRowType = leftFieldTypeBuilder.build();
            leftIndexProjectPrel = new ProjectPrel(dbScan.getCluster(), dbScan.getTraitSet(), leftIndexFilterPrel == null ? dbScan : leftIndexFilterPrel, leftProjectExprs, leftProjectRowType);
            lastRelNode = leftIndexProjectPrel;
        }
        RelTraitSet leftTraits = dbScan.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL);
        RelNode convertedLeft = Prule.convert(lastRelNode, leftTraits);
        return new Pair((Object)convertedLeft, (Object)restrictedGroupScan);
    }

    @Override
    public RelNode convertChild(RelNode filter, RelNode input) throws InvalidRelException {
        LinkedHashMap<IndexDescriptor, RexNode> idxConditionMap = Maps.newLinkedHashMap();
        boolean isAnyIndexAsync = false;
        for (IndexDescriptor idx : this.indexInfoMap.keySet()) {
            idxConditionMap.put(idx, this.indexInfoMap.get((Object)idx).indexCondition);
            if (isAnyIndexAsync || !idx.isAsyncIndex()) continue;
            isAnyIndexAsync = true;
        }
        RelNode indexPlan = null;
        int curIdx = 0;
        RexNode remnant = this.indexContext.getFilterCondition();
        for (Map.Entry<IndexDescriptor, RexNode> entry : idxConditionMap.entrySet()) {
            boolean generateDistribution = idxConditionMap.entrySet().size() - 1 - curIdx > 0;
            indexPlan = this.buildIntersectPlan(entry, indexPlan, generateDistribution);
            remnant = this.indexInfoMap.get((Object)entry.getKey()).remainderCondition;
            ++curIdx;
        }
        RelDataTypeField rightRowKeyField = (RelDataTypeField)indexPlan.getRowType().getFieldList().get(0);
        RelNode relNode = this.createRangeDistRight(indexPlan, rightRowKeyField, (DbGroupScan)IndexPlanUtils.getGroupScan(this.origScan));
        Pair<RelNode, DbGroupScan> leftRelAndScan = this.buildRestrictedDBScan(remnant, isAnyIndexAsync);
        RelNode finalRel = this.buildRowKeyJoin((RelNode)leftRelAndScan.left, relNode, true, 0);
        if (this.upperProject != null) {
            ProjectPrel cap = new ProjectPrel(finalRel.getCluster(), finalRel.getTraitSet(), finalRel, IndexPlanUtils.getProjects(this.upperProject), this.upperProject.getRowType());
            finalRel = cap;
        }
        return finalRel;
    }
}

