/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index.generators;

import java.util.ArrayList;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.exec.physical.base.DbGroupScan;
import org.apache.drill.exec.physical.base.IndexGroupScan;
import org.apache.drill.exec.planner.index.FunctionalIndexInfo;
import org.apache.drill.exec.planner.index.IndexCallContext;
import org.apache.drill.exec.planner.index.IndexDescriptor;
import org.apache.drill.exec.planner.index.IndexPlanUtils;
import org.apache.drill.exec.planner.index.generators.AbstractIndexPlanGenerator;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoveringPlanNoFilterGenerator
extends AbstractIndexPlanGenerator {
    private static final Logger logger = LoggerFactory.getLogger(CoveringPlanNoFilterGenerator.class);
    protected final IndexGroupScan indexGroupScan;
    protected final IndexDescriptor indexDesc;
    final boolean isSingletonSortedStream;
    protected final FunctionalIndexInfo functionInfo;

    public CoveringPlanNoFilterGenerator(IndexCallContext indexContext, FunctionalIndexInfo functionInfo, boolean isSingleton, PlannerSettings settings) {
        super(indexContext, null, null, null, settings);
        this.functionInfo = functionInfo;
        this.indexDesc = functionInfo == null ? null : functionInfo.getIndexDesc();
        this.indexGroupScan = functionInfo == null ? null : functionInfo.getIndexDesc().getIndexGroupScan();
        this.isSingletonSortedStream = isSingleton;
    }

    @Override
    public RelNode convertChild(RelNode filter, RelNode input) throws InvalidRelException {
        return this.convertChild();
    }

    public RelNode convertChild() throws InvalidRelException {
        Preconditions.checkNotNull(this.indexContext.getSort());
        if (this.indexGroupScan == null) {
            logger.error("Null indexgroupScan in CoveringIndexPlanGenerator.convertChild");
            return null;
        }
        IndexPlanUtils.updateSortExpression(this.indexContext, this.indexContext.getSort() != null ? this.indexContext.getCollation().getFieldCollations() : null);
        ScanPrel indexScanPrel = IndexPlanUtils.buildCoveringIndexScan(this.origScan, this.indexGroupScan, this.indexContext, this.indexDesc);
        ((IndexGroupScan)indexScanPrel.getGroupScan()).setStatistics(((DbGroupScan)IndexPlanUtils.getGroupScan(this.origScan)).getStatistics());
        RelTraitSet indexScanTraitSet = indexScanPrel.getTraitSet();
        Prel finalRel = indexScanPrel;
        if (this.indexContext.getLowerProject() != null) {
            RelCollation collation = IndexPlanUtils.buildCollationProject(this.indexContext.getLowerProject().getProjects(), null, this.indexContext.getScan(), this.functionInfo, this.indexContext);
            finalRel = new ProjectPrel(this.indexContext.getScan().getCluster(), indexScanTraitSet.plus((RelTrait)collation), indexScanPrel, this.indexContext.getLowerProject().getProjects(), this.indexContext.getLowerProject().getRowType());
            if (this.functionInfo.hasFunctional()) {
                ProjectPrel newProject = (ProjectPrel)finalRel;
                ArrayList<RexNode> newProjects = Lists.newArrayList();
                DrillParseContext parseContxt = new DrillParseContext(PrelUtil.getPlannerSettings(newProject.getCluster()));
                for (RexNode projectRex : newProject.getProjects()) {
                    RexNode newRex = IndexPlanUtils.rewriteFunctionalRex(this.indexContext, parseContxt, null, this.origScan, projectRex, indexScanPrel.getRowType(), this.functionInfo);
                    newProjects.add(newRex);
                }
                ProjectPrel rewrittenProject = new ProjectPrel(newProject.getCluster(), collation == null ? newProject.getTraitSet() : newProject.getTraitSet().plus((RelTrait)collation), indexScanPrel, newProjects, newProject.getRowType());
                finalRel = rewrittenProject;
            }
        }
        if ((finalRel = CoveringPlanNoFilterGenerator.getSortNode(this.indexContext, finalRel, true, this.isSingletonSortedStream, this.indexContext.getExchange() != null)) == null) {
            return null;
        }
        finalRel = Prule.convert(finalRel, finalRel.getTraitSet().plus((RelTrait)Prel.DRILL_PHYSICAL));
        logger.debug("CoveringPlanNoFilterGenerator got finalRel {} from origScan {}, original digest {}, new digest {}.", new Object[]{finalRel.toString(), this.indexContext.getScan().toString(), this.indexContext.getLowerProject() != null ? this.indexContext.getLowerProject().getDigest() : this.indexContext.getScan().getDigest(), finalRel.getDigest()});
        return finalRel;
    }
}

