/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.NlsString;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.exec.planner.index.ExprToRex;
import org.apache.drill.exec.planner.index.IndexableExprMarker;
import org.apache.drill.exec.util.Utilities;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;

public class SimpleRexRemap {
    final RelNode origRel;
    final RelDataType origRowType;
    final RelDataType newRowType;
    private RexBuilder builder;
    private Map<LogicalExpression, LogicalExpression> destExprMap;

    public SimpleRexRemap(RelNode origRel, RelDataType newRowType, RexBuilder builder) {
        this.origRel = origRel;
        this.origRowType = origRel.getRowType();
        this.newRowType = newRowType;
        this.builder = builder;
        this.destExprMap = Maps.newHashMap();
    }

    public SimpleRexRemap setExpressionMap(Map<LogicalExpression, LogicalExpression> exprMap) {
        this.destExprMap.putAll(exprMap);
        return this;
    }

    public RexNode rewriteEqualOnCharToLike(RexNode expr, Map<RexNode, LogicalExpression> equalOnCastCharExprs) {
        IdentityHashMap<RexNode, RexNode> srcToReplace = Maps.newIdentityHashMap();
        for (Map.Entry<RexNode, LogicalExpression> entry : equalOnCastCharExprs.entrySet()) {
            RexNode equalOp = entry.getKey();
            LogicalExpression opInput = entry.getValue();
            List operands = ((RexCall)equalOp).getOperands();
            RexLiteral newLiteral = null;
            RexNode input = null;
            if (operands.size() == 2) {
                RexLiteral oplit = null;
                if (operands.get(0) instanceof RexLiteral) {
                    oplit = (RexLiteral)operands.get(0);
                    if (oplit.getTypeName() == SqlTypeName.CHAR) {
                        newLiteral = this.builder.makeLiteral(((NlsString)oplit.getValue()).getValue() + "%");
                        input = (RexNode)operands.get(1);
                    }
                } else if (operands.get(1) instanceof RexLiteral && (oplit = (RexLiteral)operands.get(1)).getTypeName() == SqlTypeName.CHAR) {
                    newLiteral = this.builder.makeLiteral(((NlsString)oplit.getValue()).getValue() + "%");
                    input = (RexNode)operands.get(0);
                }
            }
            if (newLiteral == null) continue;
            srcToReplace.put(equalOp, this.builder.makeCall((SqlOperator)SqlStdOperatorTable.LIKE, new RexNode[]{input, newLiteral}));
        }
        if (srcToReplace.size() > 0) {
            RexReplace replacer = new RexReplace(srcToReplace);
            RexNode resultRex = (RexNode)expr.accept((RexVisitor)replacer);
            return resultRex;
        }
        return expr;
    }

    public RexNode rewriteWithMap(RexNode srcRex, Map<RexNode, LogicalExpression> mapRexToExpr) {
        HashMap<RexNode, RexNode> destNodeMap = Maps.newHashMap();
        for (Map.Entry<RexNode, LogicalExpression> entry : mapRexToExpr.entrySet()) {
            LogicalExpression entryExpr = entry.getValue();
            LogicalExpression destExpr = this.destExprMap.get(entryExpr);
            RexNode destRex = this.buildRexForField(destExpr == null ? entryExpr : destExpr, this.newRowType);
            destNodeMap.put(entry.getKey(), destRex);
        }
        RexReplace replacer = new RexReplace(destNodeMap);
        RexNode resultRex = (RexNode)srcRex.accept((RexVisitor)replacer);
        return resultRex;
    }

    public RexNode rewrite(RexNode expr) {
        IndexableExprMarker marker = new IndexableExprMarker(this.origRel);
        expr.accept((RexVisitor)marker);
        return this.rewriteWithMap(expr, marker.getIndexableExpression());
    }

    private RexNode buildRexForField(LogicalExpression expr, RelDataType newRowType) {
        ExprToRex toRex = new ExprToRex(this.origRel, newRowType, this.builder);
        return expr.accept(toRex, null);
    }

    public static String getFullPath(PathSegment pathSeg) {
        PathSegment.NameSegment nameSeg = (PathSegment.NameSegment)pathSeg;
        if (nameSeg.isLastPath()) {
            return nameSeg.getPath();
        }
        return String.format("%s.%s", nameSeg.getPath(), SimpleRexRemap.getFullPath(nameSeg.getChild()));
    }

    public static class RexReplace
    extends RexShuttle {
        final Map<RexNode, RexNode> rexMap;

        public RexReplace(Map<RexNode, RexNode> rexMap) {
            this.rexMap = rexMap;
        }

        boolean toReplace(RexNode node) {
            return this.rexMap.containsKey(node);
        }

        RexNode replace(RexNode node) {
            return this.rexMap.get(node);
        }

        public RexNode visitOver(RexOver over) {
            return this.toReplace((RexNode)over) ? this.replace((RexNode)over) : super.visitOver(over);
        }

        public RexNode visitCall(RexCall call) {
            return this.toReplace((RexNode)call) ? this.replace((RexNode)call) : super.visitCall(call);
        }

        public RexNode visitCorrelVariable(RexCorrelVariable variable) {
            return variable;
        }

        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            return this.toReplace((RexNode)fieldAccess) ? this.replace((RexNode)fieldAccess) : super.visitFieldAccess(fieldAccess);
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            return this.toReplace((RexNode)inputRef) ? this.replace((RexNode)inputRef) : super.visitInputRef(inputRef);
        }

        public RexNode visitLocalRef(RexLocalRef localRef) {
            return this.toReplace((RexNode)localRef) ? this.replace((RexNode)localRef) : super.visitLocalRef(localRef);
        }

        public RexNode visitLiteral(RexLiteral literal) {
            return literal;
        }

        public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
            return dynamicParam;
        }

        public RexNode visitRangeRef(RexRangeRef rangeRef) {
            return this.toReplace((RexNode)rangeRef) ? this.replace((RexNode)rangeRef) : super.visitRangeRef(rangeRef);
        }
    }

    public static class FieldsMarker
    extends RexVisitorImpl<PathSegment> {
        final List<String> fieldNames;
        final List<RelDataTypeField> fields;
        final Map<RexNode, String> desiredFields = Maps.newHashMap();
        int stackDepth;

        public FieldsMarker(RelDataType rowType) {
            super(true);
            this.fieldNames = rowType.getFieldNames();
            this.fields = rowType.getFieldList();
            this.stackDepth = 0;
        }

        private PathSegment newPath(PathSegment segment, RexNode node) {
            if (this.stackDepth == 0) {
                this.desiredFields.put(node, SimpleRexRemap.getFullPath(segment));
            }
            return segment;
        }

        private PathSegment newPath(String path, RexNode node) {
            PathSegment.NameSegment segment = new PathSegment.NameSegment(path);
            if (this.stackDepth == 0) {
                this.desiredFields.put(node, SimpleRexRemap.getFullPath(segment));
            }
            return segment;
        }

        public Map<RexNode, String> getFieldAndPos() {
            return ImmutableMap.copyOf(this.desiredFields);
        }

        public PathSegment visitInputRef(RexInputRef inputRef) {
            int index = inputRef.getIndex();
            String name = this.fieldNames.get(index);
            return this.newPath(name, (RexNode)inputRef);
        }

        public PathSegment visitCall(RexCall call) {
            if ("ITEM".equals(call.getOperator().getName())) {
                ++this.stackDepth;
                PathSegment mapOrArray = (PathSegment)((RexNode)call.operands.get(0)).accept((RexVisitor)this);
                --this.stackDepth;
                if (mapOrArray != null) {
                    if (call.operands.get(1) instanceof RexLiteral) {
                        PathSegment newFieldPath = this.newPath(mapOrArray.cloneWithNewChild(Utilities.convertLiteral((RexLiteral)call.operands.get(1))), (RexNode)call);
                        return newFieldPath;
                    }
                    return mapOrArray;
                }
            } else {
                for (RexNode operand : call.operands) {
                    operand.accept((RexVisitor)this);
                }
            }
            return null;
        }
    }
}

