/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index;

import java.util.Map;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.planner.common.DrillProjectRelBase;
import org.apache.drill.exec.planner.index.IndexPlanUtils;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;

public class RexToExpression {
    public static LogicalExpression toDrill(DrillParseContext context, DrillProjectRelBase project, RelNode input, RexNode expr) {
        RexToDrillExt visitor = new RexToDrillExt(context, project, input);
        return (LogicalExpression)expr.accept((RexVisitor)visitor);
    }

    public static class RexToDrillExt
    extends DrillOptiq.RexToDrill {
        private final DrillOptiq.RexToDrill projectToInput;
        private final DrillProjectRelBase project;
        private final Map<LogicalExpression, Set<RexNode>> exprToRexs;

        public RexToDrillExt(DrillParseContext context, DrillProjectRelBase project, RelNode input) {
            super(context, input);
            this.projectToInput = new DrillOptiq.RexToDrill(context, input);
            this.project = project;
            this.exprToRexs = Maps.newHashMap();
        }

        public Map<LogicalExpression, Set<RexNode>> getMapExprToRex() {
            return this.exprToRexs;
        }

        private LogicalExpression addExprToRexs(LogicalExpression expr, RexNode rex) {
            if (!this.exprToRexs.containsKey(expr)) {
                this.exprToRexs.put(expr, Sets.newHashSet(rex));
            } else {
                this.exprToRexs.get(expr).add(rex);
            }
            return expr;
        }

        @Override
        protected RelDataType getRowType() {
            if (this.project != null) {
                return this.project.getRowType();
            }
            return super.getRowType();
        }

        @Override
        protected RexBuilder getRexBuilder() {
            if (this.project != null) {
                return this.project.getCluster().getRexBuilder();
            }
            return super.getRexBuilder();
        }

        @Override
        public LogicalExpression visitInputRef(RexInputRef inputRef) {
            int index = inputRef.getIndex();
            if (this.project == null) {
                RelDataTypeField field = (RelDataTypeField)this.getRowType().getFieldList().get(index);
                return this.addExprToRexs(FieldReference.getWithQuotedRef(field.getName()), (RexNode)inputRef);
            }
            RexNode rex = IndexPlanUtils.getProjects(this.project).get(index);
            return this.addExprToRexs((LogicalExpression)rex.accept((RexVisitor)this.projectToInput), (RexNode)inputRef);
        }

        @Override
        public LogicalExpression visitCall(RexCall call) {
            return this.addExprToRexs(super.visitCall(call), (RexNode)call);
        }

        @Override
        public LogicalExpression visitLocalRef(RexLocalRef localRef) {
            return this.addExprToRexs(super.visitLocalRef(localRef), (RexNode)localRef);
        }

        @Override
        public LogicalExpression visitOver(RexOver over) {
            return this.addExprToRexs(super.visitOver(over), (RexNode)over);
        }

        @Override
        public LogicalExpression visitCorrelVariable(RexCorrelVariable correlVariable) {
            return this.addExprToRexs(super.visitCorrelVariable(correlVariable), (RexNode)correlVariable);
        }

        @Override
        public LogicalExpression visitDynamicParam(RexDynamicParam dynamicParam) {
            return this.addExprToRexs(super.visitDynamicParam(dynamicParam), (RexNode)dynamicParam);
        }

        @Override
        public LogicalExpression visitRangeRef(RexRangeRef rangeRef) {
            return this.addExprToRexs(super.visitRangeRef(rangeRef), (RexNode)rangeRef);
        }

        @Override
        public LogicalExpression visitFieldAccess(RexFieldAccess fieldAccess) {
            return this.addExprToRexs(super.visitFieldAccess(fieldAccess), (RexNode)fieldAccess);
        }
    }
}

