/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index;

import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.drill.common.expression.CastExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.planner.index.IndexableExprMarker;
import org.apache.drill.exec.planner.logical.partition.FindPartitionConditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;

public class RexSeparator {
    private final List<LogicalExpression> relatedPaths;
    private final RelNode inputRel;
    private final RexBuilder builder;

    public RexSeparator(List<LogicalExpression> relatedPaths, RelNode inputRel, RexBuilder builder) {
        this.relatedPaths = relatedPaths;
        this.inputRel = inputRel;
        this.builder = builder;
    }

    public RexNode getSeparatedCondition(RexNode expr) {
        IndexableExprMarker marker = new IndexableExprMarker(this.inputRel);
        expr.accept((RexVisitor)marker);
        HashMap<RexNode, LogicalExpression> markMap = Maps.newHashMap();
        Map<RexNode, LogicalExpression> relevantRexMap = marker.getIndexableExpression();
        for (Map.Entry<RexNode, LogicalExpression> entry : relevantRexMap.entrySet()) {
            CastExpression castExprInFilter;
            LogicalExpression relevantExpr = entry.getValue();
            int idxFound = this.relatedPaths.indexOf(relevantExpr);
            if (idxFound < 0 || (relevantExpr instanceof SchemaPath ? !((SchemaPath)relevantExpr).toExpr().equals(((SchemaPath)this.relatedPaths.get(idxFound)).toExpr()) : relevantExpr instanceof CastExpression && (castExprInFilter = (CastExpression)relevantExpr).getMajorType().getMinorType() == TypeProtos.MinorType.VARCHAR && castExprInFilter.getMajorType().getPrecision() > this.relatedPaths.get(idxFound).getMajorType().getPrecision())) continue;
            markMap.put(entry.getKey(), entry.getValue());
        }
        ConditionSeparator separator = new ConditionSeparator(markMap, this.builder);
        separator.analyze(expr);
        return separator.getFinalCondition();
    }

    private static class ConditionSeparator
    extends FindPartitionConditions {
        private final Map<RexNode, LogicalExpression> markMap;
        private boolean inAcceptedPath;

        public ConditionSeparator(Map<RexNode, LogicalExpression> markMap, RexBuilder builder) {
            super(new BitSet(), builder);
            this.markMap = markMap;
            this.inAcceptedPath = false;
        }

        @Override
        protected boolean inputRefToPush(RexInputRef inputRef) {
            return this.markMap.containsKey(inputRef) || this.inAcceptedPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitCall(RexCall call) {
            boolean oldValue = this.inAcceptedPath;
            try {
                if (this.markMap.containsKey(call)) {
                    this.inAcceptedPath = true;
                }
                Void void_ = super.visitCall(call);
                return void_;
            }
            finally {
                this.inAcceptedPath = oldValue;
            }
        }
    }
}

