/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.expression.CastExpression;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.FunctionHolderExpression;
import org.apache.drill.common.expression.IfExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;

public class PathInExpr
extends AbstractExprVisitor<Boolean, Void, RuntimeException> {
    private final Map<LogicalExpression, Set<SchemaPath>> pathsInExpr;
    private final Set<SchemaPath> allPaths;
    private final Set<LogicalExpression> remainderPaths;
    private final Set<LogicalExpression> remainderPathsInFunctions;

    public PathInExpr(Map<LogicalExpression, Set<SchemaPath>> pathsInExpr) {
        this.pathsInExpr = pathsInExpr;
        this.allPaths = Sets.newHashSet();
        this.remainderPaths = Sets.newHashSet();
        this.remainderPathsInFunctions = Sets.newHashSet();
        for (Map.Entry<LogicalExpression, Set<SchemaPath>> entry : pathsInExpr.entrySet()) {
            this.allPaths.addAll((Collection<SchemaPath>)entry.getValue());
        }
    }

    public Set<LogicalExpression> getRemainderPaths() {
        return this.remainderPaths;
    }

    public Set<LogicalExpression> getRemainderPathsInFunctions() {
        return this.remainderPathsInFunctions;
    }

    private boolean preProcess(LogicalExpression inExpr) {
        return this.pathsInExpr.containsKey(inExpr);
    }

    @Override
    public Boolean visitFunctionCall(FunctionCall call, Void value) throws RuntimeException {
        if (this.preProcess(call)) {
            return true;
        }
        boolean bret = true;
        for (LogicalExpression arg : call.args()) {
            if (!(bret &= arg.accept(this, null).booleanValue())) break;
        }
        return bret;
    }

    @Override
    public Boolean visitFunctionHolderExpression(FunctionHolderExpression holder, Void value) throws RuntimeException {
        if (this.preProcess(holder)) {
            return true;
        }
        for (LogicalExpression arg : holder.args) {
            arg.accept(this, null);
        }
        return null;
    }

    @Override
    public Boolean visitCastExpression(CastExpression castExpr, Void value) throws RuntimeException {
        if (this.preProcess(castExpr)) {
            return true;
        }
        return castExpr.getInput().accept(this, null);
    }

    @Override
    public Boolean visitIfExpression(IfExpression ifExpr, Void value) throws RuntimeException {
        return ifExpr.ifCondition.condition.accept(this, null) != false && ifExpr.ifCondition.expression.accept(this, null) != false && ifExpr.elseExpression.accept(this, null) != false;
    }

    @Override
    public Boolean visitSchemaPath(SchemaPath path, Void value) throws RuntimeException {
        this.remainderPaths.add(path);
        if (this.allPaths.contains(path)) {
            this.remainderPathsInFunctions.add(path);
            return false;
        }
        return true;
    }

    @Override
    public Boolean visitUnknown(LogicalExpression e, Void value) throws RuntimeException {
        return true;
    }
}

