/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.physical.base.DbGroupScan;
import org.apache.drill.exec.planner.common.DrillJoinRelBase;
import org.apache.drill.exec.planner.common.DrillScanRelBase;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.cost.PluginCost;
import org.apache.drill.exec.planner.index.FunctionalIndexInfo;
import org.apache.drill.exec.planner.index.IndexCallContext;
import org.apache.drill.exec.planner.index.IndexCollection;
import org.apache.drill.exec.planner.index.IndexConditionInfo;
import org.apache.drill.exec.planner.index.IndexDescriptor;
import org.apache.drill.exec.planner.index.IndexGroup;
import org.apache.drill.exec.planner.index.IndexPlanUtils;
import org.apache.drill.exec.planner.index.IndexProperties;
import org.apache.drill.exec.planner.index.Statistics;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSelector {
    static final Logger logger = LoggerFactory.getLogger(IndexSelector.class);
    private static final double COVERING_TO_NONCOVERING_FACTOR = 100.0;
    private RexNode indexCondition;
    private RexNode otherRemainderCondition;
    private double totalRows;
    private Statistics stats;
    private IndexConditionInfo.Builder builder;
    private List<IndexProperties> indexPropList;
    private DrillScanRelBase primaryTableScan;
    private IndexCallContext indexContext;
    private RexBuilder rexBuilder;

    public IndexSelector(RexNode indexCondition, RexNode otherRemainderCondition, IndexCallContext indexContext, IndexCollection collection, RexBuilder rexBuilder, double totalRows) {
        this.indexCondition = indexCondition;
        this.otherRemainderCondition = otherRemainderCondition;
        this.indexContext = indexContext;
        this.totalRows = totalRows;
        this.stats = indexContext.getGroupScan().getStatistics();
        this.rexBuilder = rexBuilder;
        this.builder = IndexConditionInfo.newBuilder(indexCondition, collection, rexBuilder, indexContext.getScan());
        this.primaryTableScan = indexContext.getScan();
        this.indexPropList = Lists.newArrayList();
    }

    public IndexSelector(IndexCallContext indexContext) {
        this.indexCondition = null;
        this.otherRemainderCondition = null;
        this.indexContext = indexContext;
        this.totalRows = -1.0;
        this.stats = indexContext.getGroupScan().getStatistics();
        this.rexBuilder = indexContext.getScan().getCluster().getRexBuilder();
        this.builder = null;
        this.primaryTableScan = indexContext.getScan();
        this.indexPropList = Lists.newArrayList();
    }

    public void addIndex(IndexDescriptor indexDesc, boolean isCovering, int numProjectedFields) {
        DrillIndexProperties indexProps = new DrillIndexProperties(indexDesc, isCovering, this.otherRemainderCondition, this.rexBuilder, numProjectedFields, this.totalRows, this.primaryTableScan);
        this.indexPropList.add(indexProps);
    }

    public void analyzePrefixMatches(IndexProperties indexProps) {
        RexNode initCondition = this.indexCondition.isAlwaysTrue() ? null : this.indexCondition;
        HashMap<LogicalExpression, RexNode> leadingPrefixMap = Maps.newHashMap();
        List<LogicalExpression> indexCols = indexProps.getIndexDesc().getIndexColumns();
        boolean satisfiesCollation = false;
        if (indexCols.size() > 0) {
            if (initCondition != null) {
                initCondition = IndexPlanUtils.getLeadingPrefixMap(leadingPrefixMap, indexCols, this.builder, this.indexCondition);
            }
            if (this.requiredCollation()) {
                satisfiesCollation = this.buildAndCheckCollation(indexProps);
            }
        }
        indexProps.setProperties(leadingPrefixMap, satisfiesCollation, initCondition, this.stats);
    }

    private boolean requiredCollation() {
        return this.indexContext.getCollation() != null;
    }

    private boolean buildAndCheckCollation(IndexProperties indexProps) {
        IndexDescriptor indexDesc = indexProps.getIndexDesc();
        FunctionalIndexInfo functionInfo = indexDesc.getFunctionalInfo();
        ScanPrel indexScanPrel = IndexPlanUtils.buildCoveringIndexScan(this.indexContext.getScan(), indexDesc.getIndexGroupScan(), this.indexContext, indexDesc);
        RelCollation inputCollation = (RelCollation)indexScanPrel.getTraitSet().getTrait((RelTraitDef)RelCollationTraitDef.INSTANCE);
        if (this.indexContext.hasLowerProject()) {
            inputCollation = IndexPlanUtils.buildCollationProject(this.indexContext.getLowerProject().getProjects(), null, this.indexContext.getScan(), functionInfo, this.indexContext);
        }
        if (this.indexContext.hasUpperProject()) {
            inputCollation = IndexPlanUtils.buildCollationProject(this.indexContext.getUpperProject().getProjects(), this.indexContext.getLowerProject(), this.indexContext.getScan(), functionInfo, this.indexContext);
        }
        return inputCollation != null && inputCollation.satisfies((RelTrait)this.indexContext.getCollation());
    }

    private void addIndexIntersections(List<IndexGroup> candidateIndexes, IndexConditionInfo.Builder infoBuilder, long maxIndexesToIntersect) {
        IndexGroup indexesInCandidate = new IndexGroup();
        double SELECTIVITY_UNKNOWN = -1.0;
        double prevSel = -1.0;
        for (int idx = 0; idx < candidateIndexes.size() && (long)indexesInCandidate.numIndexes() != maxIndexesToIntersect; ++idx) {
            if (candidateIndexes.get(idx).getIndexProps().get(0).isCovering()) continue;
            ArrayList<IndexDescriptor> candidateDescs = Lists.newArrayList();
            for (IndexProperties prop : indexesInCandidate.getIndexProps()) {
                candidateDescs.add(prop.getIndexDesc());
            }
            candidateDescs.add(candidateIndexes.get(idx).getIndexProps().get(0).getIndexDesc());
            Map<IndexDescriptor, IndexConditionInfo> intersectIdxInfoMap = infoBuilder.getIndexConditionMap(candidateDescs);
            if (intersectIdxInfoMap.keySet().size() < candidateDescs.size()) continue;
            IndexProperties curProp = candidateIndexes.get(idx).getIndexProps().get(0);
            indexesInCandidate.addIndexProp(curProp);
            double currSel = 1.0;
            if (!indexesInCandidate.isIntersectIndex()) continue;
            for (IndexProperties prop : indexesInCandidate.getIndexProps()) {
                currSel *= prop.getLeadingSelectivity();
            }
            if (prevSel == -1.0 || currSel / prevSel < 100.0) {
                prevSel = currSel;
                continue;
            }
            indexesInCandidate.removeIndexProp(curProp);
        }
        if (indexesInCandidate.isIntersectIndex()) {
            candidateIndexes.add(indexesInCandidate);
        }
    }

    public void getCandidateIndexes(IndexConditionInfo.Builder infoBuilder, List<IndexGroup> coveringIndexes, List<IndexGroup> nonCoveringIndexes, List<IndexGroup> intersectIndexes) {
        RelOptPlanner planner = this.indexContext.getCall().getPlanner();
        PlannerSettings settings = PrelUtil.getPlannerSettings(planner);
        ArrayList<IndexGroup> candidateIndexes = Lists.newArrayList();
        logger.info("index_plan_info: Analyzing {} indexes for prefix matches: {}", (Object)this.indexPropList.size(), this.indexPropList);
        for (IndexProperties p : this.indexPropList) {
            double selThreshold;
            this.analyzePrefixMatches(p);
            if (p.numLeadingFilters() <= 0 && !p.satisfiesCollation()) continue;
            double d = selThreshold = p.isCovering() ? settings.getIndexCoveringSelThreshold() : settings.getIndexNonCoveringSelThreshold();
            if (settings.isDisableFullTableScan() || p.getLeadingSelectivity() <= selThreshold) {
                IndexGroup index = new IndexGroup();
                index.addIndexProp(p);
                candidateIndexes.add(index);
                continue;
            }
            if (!(p.getLeadingSelectivity() > selThreshold)) continue;
            logger.debug("Skipping index {}. The leading selectivity {} is larger than threshold {}", new Object[]{p.getIndexDesc().getIndexName(), p.getLeadingSelectivity(), selThreshold});
        }
        if (candidateIndexes.size() == 0) {
            logger.info("index_plan_info: No suitable indexes found !");
            return;
        }
        int max_candidate_indexes = (int)PrelUtil.getPlannerSettings(planner).getIndexMaxChosenIndexesPerTable();
        if (candidateIndexes.size() > 1) {
            Collections.sort(candidateIndexes, new IndexComparator(planner, this.builder));
        }
        this.addIndexIntersections(candidateIndexes, infoBuilder, settings.getMaxIndexesToIntersect());
        if (candidateIndexes.size() > 1) {
            Collections.sort(candidateIndexes, new IndexComparator(planner, this.builder));
        }
        logger.info("index_plan_info: The top ranked indexes are: ");
        int count = 0;
        boolean foundCovering = false;
        boolean foundCoveringCollation = false;
        boolean foundNonCoveringCollation = false;
        for (int i = 0; i < candidateIndexes.size(); ++i) {
            IndexProperties indexProps;
            IndexGroup index = (IndexGroup)candidateIndexes.get(i);
            if (index.numIndexes() == 1 && index.getIndexProps().get(0).isCovering()) {
                indexProps = index.getIndexProps().get(0);
                if (foundCoveringCollation) {
                    logger.debug("index_plan_info: Skipping covering index {} because a higher ranked covering index with collation already exists.", (Object)indexProps.getIndexDesc().getIndexName());
                    continue;
                }
                coveringIndexes.add(index);
                logger.info("index_plan_info: name: {}, covering, collation: {}, leadingSelectivity: {}, cost: {}", new Object[]{indexProps.getIndexDesc().getIndexName(), indexProps.satisfiesCollation(), indexProps.getLeadingSelectivity(), indexProps.getSelfCost(planner)});
                ++count;
                foundCovering = true;
                if (indexProps.satisfiesCollation()) {
                    foundCoveringCollation = true;
                }
            } else if (index.numIndexes() == 1) {
                indexProps = index.getIndexProps().get(0);
                if (foundCoveringCollation || foundCovering && !indexProps.satisfiesCollation()) {
                    logger.debug("index_plan_info: Skipping non-covering index {} because it does not have collation and a higher ranked covering index already exists.", (Object)indexProps.getIndexDesc().getIndexName());
                    continue;
                }
                if (indexProps.satisfiesCollation()) {
                    foundNonCoveringCollation = true;
                }
                nonCoveringIndexes.add(index);
                logger.info("index_plan_info: name: {}, non-covering, collation: {}, leadingSelectivity: {}, cost: {}", new Object[]{indexProps.getIndexDesc().getIndexName(), indexProps.satisfiesCollation(), indexProps.getLeadingSelectivity(), indexProps.getSelfCost(planner)});
                ++count;
            } else {
                if (foundCoveringCollation || foundCovering && !index.getIndexProps().get(index.numIndexes() - 1).satisfiesCollation() || foundNonCoveringCollation) continue;
                IndexGroup intersectIndex = new IndexGroup();
                double isectLeadingSel = 1.0;
                String isectName = "Intersect-" + count;
                for (IndexProperties indexProps2 : index.getIndexProps()) {
                    intersectIndex.addIndexProp(indexProps2);
                    isectLeadingSel *= indexProps2.getLeadingSelectivity();
                    logger.info("name: {}, {}, collation: {}, leadingSelectivity: {}, cost: {}", new Object[]{indexProps2.getIndexDesc().getIndexName(), isectName, indexProps2.satisfiesCollation(), indexProps2.getLeadingSelectivity(), indexProps2.getSelfCost(planner)});
                }
                logger.info("name: {}, intersect-idx, collation: {}, leadingSelectivity: {}, cost: {}", new Object[]{isectName, index.getIndexProps().get(index.numIndexes() - 1).satisfiesCollation(), isectLeadingSel, index.getIndexProps().get(0).getIntersectCost(index, this.builder, planner)});
                intersectIndexes.add(intersectIndex);
            }
            if (count == max_candidate_indexes) break;
        }
    }

    public IndexProperties getBestIndexNoFilter() {
        if (this.indexPropList.size() == 0) {
            return null;
        }
        RelOptPlanner planner = this.indexContext.getCall().getPlanner();
        ArrayList<IndexGroup> candidateIndexes = Lists.newArrayList();
        for (IndexProperties p : this.indexPropList) {
            p.setSatisfiesCollation(this.buildAndCheckCollation(p));
            IndexGroup index = new IndexGroup();
            index.addIndexProp(p);
            candidateIndexes.add(index);
        }
        Collections.sort(candidateIndexes, new IndexComparator(planner, this.builder));
        return ((IndexGroup)candidateIndexes.get(0)).getIndexProps().get(0);
    }

    public static class DrillIndexProperties
    implements IndexProperties {
        private IndexDescriptor indexDescriptor;
        private double leadingSel = 1.0;
        private double remainderSel = 1.0;
        private boolean satisfiesCollation = false;
        private boolean isCovering = false;
        private double avgRowSize;
        private int numProjectedFields;
        private double totalRows;
        private DrillScanRelBase primaryTableScan = null;
        private RelOptCost selfCost = null;
        private List<RexNode> leadingFilters = Lists.newArrayList();
        private Map<LogicalExpression, RexNode> leadingPrefixMap;
        private RexNode indexColumnsRemainderFilter = null;
        private RexNode otherColumnsRemainderFilter = null;
        private RexBuilder rexBuilder;

        public DrillIndexProperties(IndexDescriptor indexDescriptor, boolean isCovering, RexNode otherColumnsRemainderFilter, RexBuilder rexBuilder, int numProjectedFields, double totalRows, DrillScanRelBase primaryTableScan) {
            this.indexDescriptor = indexDescriptor;
            this.isCovering = isCovering;
            this.otherColumnsRemainderFilter = otherColumnsRemainderFilter;
            this.rexBuilder = rexBuilder;
            this.numProjectedFields = numProjectedFields;
            this.totalRows = totalRows;
            this.primaryTableScan = primaryTableScan;
        }

        @Override
        public void setProperties(Map<LogicalExpression, RexNode> prefixMap, boolean satisfiesCollation, RexNode indexColumnsRemainderFilter, Statistics stats) {
            this.indexColumnsRemainderFilter = indexColumnsRemainderFilter;
            this.satisfiesCollation = satisfiesCollation;
            this.leadingPrefixMap = prefixMap;
            logger.info("index_plan_info: Index {}: leading prefix map: {}, satisfies collation: {}, remainder condition: {}", new Object[]{this.indexDescriptor.getIndexName(), this.leadingPrefixMap, satisfiesCollation, indexColumnsRemainderFilter});
            this.leadingFilters = IndexPlanUtils.getLeadingFilters(this.leadingPrefixMap, this.indexDescriptor.getIndexColumns());
            String idxIdentifier = stats.buildUniqueIndexIdentifier(this.getIndexDesc());
            for (RexNode filter : this.leadingFilters) {
                double filterRows = stats.getRowCount(filter, idxIdentifier, this.primaryTableScan);
                double sel = 1.0;
                if (filterRows != -1.0) {
                    sel = filterRows / this.totalRows;
                    logger.info("index_plan_info: Filter: {}, filterRows = {}, totalRows = {}, selectivity = {}", new Object[]{filter, filterRows, this.totalRows, sel});
                } else {
                    sel = RelMdUtil.guessSelectivity((RexNode)filter);
                    if (stats.isStatsAvailable()) {
                        logger.debug("index_plan_info: Filter row count is UNKNOWN for filter: {}, using guess {}", (Object)filter, (Object)sel);
                    }
                }
                this.leadingSel *= sel;
            }
            logger.debug("index_plan_info: Combined selectivity of all leading filters: {}", (Object)this.leadingSel);
            if (indexColumnsRemainderFilter != null) {
                double remFilterRows = stats.getRowCount(indexColumnsRemainderFilter, null, this.primaryTableScan);
                if (remFilterRows != -1.0) {
                    this.remainderSel = remFilterRows / this.totalRows;
                    logger.debug("index_plan_info: Selectivity of index columns remainder filters: {}", (Object)this.remainderSel);
                } else {
                    this.remainderSel = RelMdUtil.guessSelectivity((RexNode)indexColumnsRemainderFilter);
                    if (stats.isStatsAvailable()) {
                        logger.debug("index_plan_info: Filter row count is UNKNOWN for remainder filter : {}, using guess {}", (Object)indexColumnsRemainderFilter, (Object)this.remainderSel);
                    }
                }
            }
            this.avgRowSize = stats.getAvgRowSize(idxIdentifier, false);
            if (this.avgRowSize == -1.0) {
                this.avgRowSize = (long)this.numProjectedFields * 10L;
                if (stats.isStatsAvailable()) {
                    logger.debug("index_plan_info: Average row size is UNKNOWN based on leading filter: {}, using guess {}, columns {}, columnSize {}", new Object[]{this.leadingFilters.size() > 0 ? this.leadingFilters.get(0).toString() : "<NULL>", this.avgRowSize, this.numProjectedFields, 10L});
                }
            } else {
                logger.debug("index_plan_info: Filter: {}, Average row size: {}", (Object)(this.leadingFilters.size() > 0 ? this.leadingFilters.get(0).toString() : "<NULL>"), (Object)this.avgRowSize);
            }
        }

        @Override
        public double getLeadingSelectivity() {
            return this.leadingSel;
        }

        @Override
        public double getRemainderSelectivity() {
            return this.remainderSel;
        }

        @Override
        public boolean isCovering() {
            return this.isCovering;
        }

        @Override
        public double getTotalRows() {
            return this.totalRows;
        }

        @Override
        public IndexDescriptor getIndexDesc() {
            return this.indexDescriptor;
        }

        @Override
        public RexNode getLeadingColumnsFilter() {
            return IndexPlanUtils.getLeadingColumnsFilter(this.leadingFilters, this.rexBuilder);
        }

        @Override
        public RexNode getTotalRemainderFilter() {
            return IndexPlanUtils.getTotalRemainderFilter(this.indexColumnsRemainderFilter, this.otherColumnsRemainderFilter, this.rexBuilder);
        }

        @Override
        public boolean satisfiesCollation() {
            return this.satisfiesCollation;
        }

        @Override
        public void setSatisfiesCollation(boolean satisfiesCollation) {
            this.satisfiesCollation = satisfiesCollation;
        }

        @Override
        public RelOptCost getSelfCost(RelOptPlanner planner) {
            if (this.selfCost != null) {
                return this.selfCost;
            }
            this.selfCost = this.indexDescriptor.getCost(this, planner, this.numProjectedFields, IndexPlanUtils.getGroupScan(this.primaryTableScan));
            return this.selfCost;
        }

        @Override
        public RelOptCost getIntersectCost(IndexGroup index, IndexConditionInfo.Builder builder, RelOptPlanner planner) {
            return this.getIntersectCost(index, builder, planner, this.indexDescriptor.getPluginCostModel(), this.primaryTableScan);
        }

        @Override
        public int numLeadingFilters() {
            return this.leadingFilters.size();
        }

        @Override
        public double getAvgRowSize() {
            return this.avgRowSize;
        }

        @Override
        public DrillScanRelBase getPrimaryTableScan() {
            return this.primaryTableScan;
        }

        public RelOptCost getIntersectCost(IndexGroup index, IndexConditionInfo.Builder builder, RelOptPlanner planner, PluginCost costBase, DrillScanRelBase scanRel) {
            DrillCostBase.DrillCostFactory costFactory = (DrillCostBase.DrillCostFactory)planner.getCostFactory();
            double totLeadRowCount = 1.0;
            double totalRows = 0.0;
            double totCpuCost = 0.0;
            double totDiskCost = 0.0;
            double totNetworkCost = 0.0;
            double totMemoryCost = 0.0;
            double rightSideRows = -1.0;
            DbGroupScan primaryTableGroupScan = (DbGroupScan)IndexPlanUtils.getGroupScan(scanRel);
            ArrayList<RexNode> remFilterList = Lists.newArrayList();
            for (IndexProperties indexProps : index.getIndexProps()) {
                remFilterList.add(indexProps.getTotalRemainderFilter());
            }
            RexNode remFilters = RexUtil.composeConjunction((RexBuilder)scanRel.getCluster().getRexBuilder(), remFilterList, (boolean)false);
            for (IndexProperties indexProps : index.getIndexProps()) {
                totalRows = indexProps.getTotalRows();
                double leadRowCount = indexProps.getLeadingSelectivity() * indexProps.getRemainderSelectivity() * totalRows;
                totLeadRowCount *= indexProps.getLeadingSelectivity();
                double avgRowSize = indexProps.getAvgRowSize();
                Preconditions.checkArgument(primaryTableGroupScan instanceof DbGroupScan);
                double numBlocksIndex = Math.ceil(leadRowCount * avgRowSize / (double)costBase.getBlockSize(primaryTableGroupScan));
                double diskCostIndex = numBlocksIndex * (double)costBase.getSequentialBlockReadCost(primaryTableGroupScan);
                totDiskCost += diskCostIndex;
                if (rightSideRows != -1.0) {
                    DrillCostBase joinCost = (DrillCostBase)DrillJoinRelBase.computeHashJoinCostWithRowCntKeySize(planner, rightSideRows, leadRowCount, 1);
                    totDiskCost += joinCost.getIo();
                    totCpuCost += joinCost.getCpu();
                    totMemoryCost += joinCost.getMemory();
                    rightSideRows = PrelUtil.getPlannerSettings(planner).getRowCountEstimateFactor() * Math.max(leadRowCount, rightSideRows);
                } else {
                    rightSideRows = leadRowCount;
                }
                remFilters = this.remainderCondition(indexProps.getIndexDesc(), builder, remFilters);
            }
            DbGroupScan dbGroupScan = primaryTableGroupScan;
            double totalBlocksPrimary = Math.ceil((double)(dbGroupScan.getColumns().size() * costBase.getAverageColumnSize(dbGroupScan)) * totalRows / (double)costBase.getBlockSize(dbGroupScan));
            double diskBlocksPrimary = Math.min(totalBlocksPrimary, totLeadRowCount *= totalRows);
            double diskCostPrimary = diskBlocksPrimary * (double)costBase.getRandomBlockReadCost(dbGroupScan);
            totDiskCost += diskCostPrimary;
            if (remFilters != null) {
                totCpuCost += totLeadRowCount * 4.0;
            }
            double networkCost = 0.0;
            return costFactory.makeCost(totLeadRowCount, totCpuCost, totDiskCost, totNetworkCost, totMemoryCost);
        }

        public RexNode remainderCondition(IndexDescriptor indexDesc, IndexConditionInfo.Builder builder, RexNode initCondition) {
            List<LogicalExpression> indexCols = indexDesc.getIndexColumns();
            boolean prefix = true;
            if (indexCols.size() > 0 && initCondition != null) {
                int i = 0;
                while (prefix && i < indexCols.size()) {
                    LogicalExpression p;
                    ImmutableList<LogicalExpression> prefixCol;
                    IndexConditionInfo info;
                    if ((info = builder.indexConditionRelatedToFields(prefixCol = ImmutableList.of(p = indexCols.get(i++)), initCondition)) != null && info.hasIndexCol) {
                        initCondition = info.remainderCondition;
                        if (!initCondition.isAlwaysTrue()) continue;
                        initCondition = null;
                        break;
                    }
                    prefix = false;
                }
            }
            return initCondition;
        }
    }

    public static class IndexComparator
    implements Comparator<IndexGroup> {
        private RelOptPlanner planner;
        private IndexConditionInfo.Builder builder;
        private PlannerSettings settings;

        public IndexComparator(RelOptPlanner planner, IndexConditionInfo.Builder builder) {
            this.planner = planner;
            this.builder = builder;
            this.settings = PrelUtil.getPlannerSettings(planner);
        }

        @Override
        public int compare(IndexGroup index1, IndexGroup index2) {
            DrillCostBase o2SelfCost;
            DrillCostBase cost2;
            double o2LeadingSelectivity;
            boolean o2SatisfiesCollation;
            int o2NumLeadingFilters;
            boolean o2Covering;
            int idx;
            double o1LeadingSelectivity;
            boolean o1SatisfiesCollation;
            int o1NumLeadingFilters;
            boolean o1Covering;
            List<IndexProperties> o1 = index1.getIndexProps();
            List<IndexProperties> o2 = index2.getIndexProps();
            Preconditions.checkArgument(o1.size() > 0 && o2.size() > 0);
            if (o1.size() == 1) {
                o1Covering = o1.get(0).isCovering();
                o1NumLeadingFilters = o1.get(0).numLeadingFilters();
                o1SatisfiesCollation = o1.get(0).satisfiesCollation();
                o1LeadingSelectivity = o1.get(0).getLeadingSelectivity();
            } else {
                o1Covering = false;
                o1SatisfiesCollation = false;
                o1NumLeadingFilters = o1.get(0).numLeadingFilters();
                for (idx = 1; idx < o1.size(); ++idx) {
                    o1NumLeadingFilters += o1.get(idx).numLeadingFilters();
                }
                o1LeadingSelectivity = o1.get(0).getLeadingSelectivity();
                for (idx = 1; idx < o1.size(); ++idx) {
                    o1LeadingSelectivity *= o1.get(idx).getLeadingSelectivity();
                }
            }
            if (o2.size() == 1) {
                o2Covering = o2.get(0).isCovering();
                o2NumLeadingFilters = o2.get(0).numLeadingFilters();
                o2SatisfiesCollation = o2.get(0).satisfiesCollation();
                o2LeadingSelectivity = o2.get(0).getLeadingSelectivity();
            } else {
                o2Covering = false;
                o2SatisfiesCollation = false;
                o2NumLeadingFilters = o2.get(0).numLeadingFilters();
                for (idx = 1; idx < o2.size(); ++idx) {
                    o2NumLeadingFilters += o2.get(idx).numLeadingFilters();
                }
                o2LeadingSelectivity = o2.get(0).getLeadingSelectivity();
                for (idx = 1; idx < o2.size(); ++idx) {
                    o2LeadingSelectivity *= o2.get(idx).getLeadingSelectivity();
                }
            }
            if (o1Covering && !o2Covering && o1LeadingSelectivity / o2LeadingSelectivity < 100.0) {
                return -1;
            }
            if (o2Covering && !o1Covering && o2LeadingSelectivity / o1LeadingSelectivity < 100.0) {
                return 1;
            }
            if (!o1Covering && !o2Covering && (o1.size() > 1 ? o1LeadingSelectivity / o2LeadingSelectivity < 100.0 : o2.size() > 1 && o2LeadingSelectivity / o1LeadingSelectivity < 100.0)) {
                return -1;
            }
            if (o1SatisfiesCollation && !o2SatisfiesCollation) {
                return -1;
            }
            if (o2SatisfiesCollation && !o1SatisfiesCollation) {
                return 1;
            }
            DrillCostBase o1SelfCost = o1.size() == 1 ? (DrillCostBase)o1.get(0).getSelfCost(this.planner) : (DrillCostBase)o1.get(0).getIntersectCost(index1, this.builder, this.planner);
            DrillCostBase cost1 = o1SelfCost;
            if (cost1.isLt(cost2 = (o2SelfCost = o2.size() == 1 ? (DrillCostBase)o2.get(0).getSelfCost(this.planner) : (DrillCostBase)o2.get(0).getIntersectCost(index2, this.builder, this.planner)))) {
                return -1;
            }
            if (cost1.isEqWithEpsilon(cost2)) {
                if (o1NumLeadingFilters > o2NumLeadingFilters) {
                    return -1;
                }
                if (o1NumLeadingFilters < o2NumLeadingFilters) {
                    return 1;
                }
                return 0;
            }
            return 1;
        }
    }
}

